
/***************************************************************
 ************************** STOP !! ****************************
 ***************************************************************/

/*
   If you are looking at this file, it should only be for
   educational purposes.  If you want a code base to start
   from to use in your own program, use the CLIENT source
   code, not this code.  This code implements a server that
   is essentially just a pipe between two game programs.
 */

/* Name : gamemanager.c
 *
 * Revision 1.32 prints the move if an invalid move is returned
 * Revision 1.31 correctly check for ValidMove return code
 * Revision 1.3 for Upthrust 1998/10/16 by kjm
 *
 * Notes:  Based upon quixo.cc manager by idr
 * Revision 1.2  1996/10/08 19:47:12  idr
 * Revision 1.1  1996/10/07 22:24:59  idr
 * Initial revision
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include "globals.h"
#include "manager_game.h"

void ShowUsage( const char * name );
void StartProgram( const char * program, FILE * fd[], const char * flags);

/*****************************************************************************/
/* Name : main()
 *
 * Notes:
 *
 */

int main( int argc, char ** argv )
{
    int player1, player2;
    FILE *fd_player1[2], *fd_player2[2];
    int iWinner;
    char colors[15];
    int x,y;

    if ( argc < 4 )
    {
        ShowUsage( argv[ 0 ] );
        exit( 1 );
    }

    /* Create the structures for talking to our two players. */
    if (!strcmp("-",argv[1])) {
	player1 = PLAYERHUMAN;
    }
    else {
        player1 = PLAYER1;
	sprintf(colors,"%s 1", argv[3]);
    	StartProgram(argv[1], fd_player1, colors);
    }
    if (!strcmp("-",argv[2])) {
	player2 = PLAYERHUMAN;
    }
    else {
        player2 = PLAYER2;
	sprintf(colors,"%c%c%c%c 0", 
		argv[3][3], argv[3][2], argv[3][0], argv[3][1]);
    	StartProgram(argv[2], fd_player2,colors);
    }

    /* Initialize our board and the UI */
    InitGame(aryBoard, argv[3]);
    iTurnNum=0;
    iWhoseTurn=PLAYER1;

    /* Play the game until somebody wins, or until they hit ^C. :) */
    while ((iWinner=EndOfGame(aryBoard))==-1)
    {
	iTurnNum++;
	ShowBoard(aryBoard);

        /* Get the first player's move and do it.  If the move is not valid,
         * then display the move to the "console" and break out with player 2
         * as the winner.
         */
	if (player1==PLAYERHUMAN) {
        	fprintf(stdout,"Player 1, enter your move.\n");
		fscanf(stdin,"%d %d",&x,&y);
 	}
	else {
        	fprintf(stdout,"Waiting for computer player 1's move.\n");
		fscanf(fd_player1[0],"%d %d",&x,&y);
	}
	fprintf(stdout,"Player 1 moved from: %d %d\n", x,y);
	if (!MoveExists(aryBoard,PLAYER1)) {
	    if ((x==-1) && (y==-1)) {
		/* No move exists, skip turn */
	    }
	    else {
		/* Invalid move, a move was possible.  Player 2 wins */
		iWinner=PLAYER2;
		fprintf(stdout,"Player 1 entered an invalid move! (%d %d)\n",
			x,y);
		goto EndOfGame;
	    }
        }
	else {
	    if (ValidMove(aryBoard, x, y, PLAYER1)==1) {
		MakeMove(aryBoard, x, y);
     	    }
	    else {
		/* Invalid move, a move was possible.  Player 2 wins */
		iWinner=PLAYER2;
		fprintf(stdout,"Player 1 entered an invalid move! (%d %d)\n",
			x,y);
		goto EndOfGame;
	    }
	}
	iTurnNum++;
	ShowBoard(aryBoard);
	/* Check if this was a game winner */
	iWinner=EndOfGame(aryBoard);
	if (iWinner!=-1) goto EndOfGame;

        /* Tell player 2 what player 1 did. */
	if (player2!=PLAYERHUMAN) {
		fprintf(fd_player2[1],"%d %d\n", x,y);
       		fflush(fd_player2[1]);
		/* Get player 2's move */
        	fprintf(stdout,"Waiting for computer player 2's move.\n");
		fscanf(fd_player2[0],"%d %d",&x, &y);
 	}
	else {
        	fprintf(stdout,"Player 2, enter your move.\n");
		fscanf(stdin,"%d %d",&x,&y);
	}
	fprintf(stdout,"Player 2 moved from: %d %d\n", x,y);
	if (!MoveExists(aryBoard,PLAYER2)) {
	    if ((x==-1) && (y==-1)) {
		/* No move exists, skip turn */
	    }
	    else {
		/* Invalid move, a move was possible.  Player 1 wins */
		iWinner=PLAYER1;
		fprintf(stdout,"Player 2 entered an invalid move! (%d %d)\n",
			x,y);
		goto EndOfGame;
	    }
        }
	else {
	    if (ValidMove(aryBoard, x, y, PLAYER2)==1) {
		MakeMove(aryBoard, x, y);
     	    }
	    else {
		/* Invalid move, a move was possible.  Player 1 wins */
		iWinner=PLAYER1;
		fprintf(stdout,"Player 2 entered an invalid move! (%d %d)\n",
			x,y);
		goto EndOfGame;
	    }
	}

        /* Tell player 1 what player 2 did. */
	if (player1!=PLAYERHUMAN) {
		fprintf(fd_player1[1],"%d %d\n", x,y);
       		fflush(fd_player1[1]);
	}
    }

EndOfGame:

    /* Tell them who won, close up shop, and terminate. */
    ShowBoard(aryBoard);
    printf("\nGAME OVER.\n");
    if (iWinner==100) printf("The game is a TIE!\n");
    else if (iWinner==PLAYER1) printf("Player 1 is the winner!\n");
    else printf("Player 2 is the winner!\n");    
    return( 0 );
}


/*****************************************************************************/
/* Name : StartProgram()
 *
 * Notes: This function starts a new process and runs the named program.  It
 *        fills fd[0] with a file handle that is tied to the new program's
 *        STDOUT (i.e., you can read the output of the child program through
 *        this file), and fills fd[1] with a file handle that is tied to the
 *        new program's STDIN.
 */

void StartProgram( const char * program, FILE* fd[], const char * player )
{
    int     pipeIn[ 2 ];        /* Provides STDIN for the CHILD.    */
    int     pipeOut[ 2 ];       /* Provides STDOUT for the CHILD.   */

    /* First, create the two pipes that we will use to communicate with the
     * child processes.
     */

    if ( pipe( pipeIn ) == -1 )
    {
        perror( "pipe( pipeIn )" );
        exit( 1 );
    }

    if ( pipe( pipeOut ) == -1 )
    {
        perror( "pipe( pipeOut )" );
        exit( 1 );
    }

    /* Create the child process! */
    if ( fork() == 0 )
    {
        /* Close the default STDIN and STDOUT file handles.  We want our
         * STDIN and STDOUT tied directly to our parent process.
         */

        close( STDIN_FILENO );
        close( STDOUT_FILENO );


        /* Close the write part of our STDIN pipe and the read part of our
         * STDOUT pipe.  As the child, we can't use these.
         */

        close( pipeIn[ 1 ] );
        close( pipeOut[ 0 ] );



        if ( dup2( pipeIn[ 0 ], STDIN_FILENO ) == -1 )
        {
            perror( "dup2( pipeIn[ 0 ], STDIN_FILENO )" );
            exit( 1 );
        }

        if ( dup2( pipeOut[ 1 ], STDOUT_FILENO ) == -1 )
        {
            perror( "dup2( pipeOut[ 1 ], STDOUT_FILENO )" );
            exit( 1 );
        }


        /* Run the specified program. */

        execl( program, program, player, NULL );


        /* If we get to this point, it means that execl() failed.  Let's
         * print an error message and exit.
         */

        perror( "execl()" );
        exit( 1 );
    }

    /* Close the read part of the child's STDIN pipe and the out part of
     * the child's STDOUT pipe.  As the parent, we (can't) won't be using
     * these parts.
     */

    close( pipeIn[ 0 ] );
    close( pipeOut[ 1 ] );

    /* Convert the parts of the pipes that we will be using to normal
     * stdio style FILEs.
     */

    fd[ 0 ] = fdopen( pipeOut[ 0 ], "r" );
    if ( fd[ 0 ] == NULL )
    {
        perror( "fdopen" );
        exit( 1 );
    }

    fd[ 1 ] = fdopen( pipeIn[ 1 ], "w" );
    if ( fd[ 1 ] == NULL )
    {
        perror( "fdopen" );
        exit( 1 );
    }
}




/*****************************************************************************/
/* Name : ShowUsage()
 *
 * Notes: This function attempts to show the user how to properly run our
 *        little program.
 */

void ShowUsage( const char * name )
{
    fprintf( stderr, "\nUsage: %s player1_program player2_program colors\n" \
                     "If the player_program is \"-\", then the player " \
                     "actually a human player.\n",
             name );
    fprintf(stderr,"\nThe first two colors correspond to player 1 and\n");
    fprintf(stderr,"the next two colors correspond to player 2. For\n");
    fprintf(stderr,"example, to have player 1 be red and green where\n");
    fprintf(stderr,"player 1 is the program \"dumbclient\" and player 2\n");
    fprintf(stderr,"is a human, you would invoke the manager as:\n");
    fprintf(stderr,"     %s dumbclient - rgby\n\n",name);
}

