/****************************************************
 * Upthurst Smart Computer implementation
 *
 * This code is intended only as an example of
 * how to implement an AI game playing client
 * that will interface with the game manager.
 *
 * Feel free to use any code from this file.
 *
 * Kenrick Mock 10/17/98
 * kenrick@cs.pdx.edu
 *
 ****************************************************/
#include <stdio.h>
#include <stdlib.h>
#include "globals.h"
#include "smart_ai.h"
#include <unistd.h>
#include <signal.h>

int iCurMaxDepth;
int iAlarm;

void SignalHandler()
{
 iAlarm=1;
}

void ComputeMove(int board[4][11], int iWhoseTurn, int *iXloc, int *iYloc)
{
 int i, iBestX, iBestY;
 FILE *f;

 iCurMaxDepth=7;		
 iAlarm=0;
 signal(SIGALRM, SignalHandler);
 alarm(10);
 *iXloc = -1; *iYloc = -1;	
/*
 i=ComputeMove2(board, iWhoseTurn, iXloc, iYloc);
*/

 while (iAlarm==0) {
	i=ComputeMove2(board, iWhoseTurn, &iBestX, &iBestY);
	if ((*iXloc==-1) && (*iYloc==-1)) {
		*iXloc = iBestX;	
		*iYloc = iBestY;		
	}
/*
f=fopen("moveresults.txt","a");
fprintf(f,"ply=%d best=%d %d   val=%d\n", iCurMaxDepth, iBestX, iBestY, i);
fclose(f);
*/
	if (iAlarm==1) { 
		return; 
	}     
	if (i<=-1000) { alarm(0); return; }
	if (i>=1000) { alarm(0); return; }
	*iXloc = iBestX;	
	*iYloc = iBestY;		
 	iCurMaxDepth+=2;
 }
 alarm(0);
}

/***************************************************
 *
 ***************************************************/
int ComputeMove2(int board[4][11], int iWhoseTurn, int *iXloc, int *iYloc)
{
 int i,j,x;

 /* Check all locations and see if any valid move exists */
 for (i=0; i<4; i++) {
   for (j=0; j<11; j++) {
      if ((board[i][j]==aryPlayerToColor[iWhoseTurn][0])  ||
          (board[i][j]==aryPlayerToColor[iWhoseTurn][1])) {
	  if (ValidMove(board,i,j,iWhoseTurn)==1) {
		*iXloc = i; *iYloc=j;
		x=MaxValue(board, iWhoseTurn, iXloc, iYloc, 1, -10000, 10000);
		return x;
	  }
      }
   }
 }
 *iXloc=-1;
 *iYloc=-1;
 return -10000;
}

int MaxValue(int board[4][11], int iComputerTurn, int *iXloc, int *iYloc,
	     int iDepth, int iAlpha, int iBeta)
{
  int iOpponentColor;
  int i,j, boardcpy[4][11];
  int iH;
FILE *f;

  if (iComputerTurn==PLAYER1) iOpponentColor=PLAYER2;
  else iOpponentColor=PLAYER1;

  i=EndOfGame(board);
  if (i==iComputerTurn) {
    return 1000;
  }
  if (i==iOpponentColor) {
    return -1000;
  }
  if (i==100) {		/* tie */
    return 0;
  }
  if (iDepth>=iCurMaxDepth) {
    return (CalculateHeuristic(iComputerTurn, board) - CalculateHeuristic(iOpponentColor, board));
  }
  if (iAlarm==1) {
    return (CalculateHeuristic(iComputerTurn, board) - CalculateHeuristic(iOpponentColor, board));
  }
  if (!MoveExists(board, iComputerTurn)) {
	iH = MinValue(boardcpy, iComputerTurn, iXloc, iYloc, 
		iDepth+1, iAlpha, iBeta);
	if (iH>iAlpha) { 
		iAlpha=iH; 
		if (iDepth==1) {
			*iXloc = i; *iYloc = j; 
		}
	}
	return iAlpha; 
/*
    return (CalculateHeuristic(iComputerTurn, board) - CalculateHeuristic(iOpponentColor, board));
*/
  }  

  for (i=0; i<4; i++) {
   for (j=0; j<11; j++) {
      if ((board[i][j]==aryPlayerToColor[iComputerTurn][0])  ||
          (board[i][j]==aryPlayerToColor[iComputerTurn][1])) {
	    if (ValidMove(board,i,j,iComputerTurn)==1) {
		memcpy(boardcpy,board,4*11*sizeof(int));
		MakeMove(boardcpy, i, j);
		iH = MinValue(boardcpy, iComputerTurn, iXloc, iYloc, 
			iDepth+1, iAlpha, iBeta);
		if (iH>iAlpha) { 
			iAlpha=iH; 
			if (iDepth==1) {
				*iXloc = i; *iYloc = j; 
			}
		}
		if (iAlpha >= iBeta) { return iAlpha; }
  	    }
      }
   }
  }
  return(iAlpha);
}

int MinValue(int board[4][11], int iComputerTurn, int *iXloc, int *iYloc,
	     int iDepth, int iAlpha, int iBeta)
{
  int iOpponentColor;
  int i,j, boardcpy[4][11];
  int iH;
  FILE *f;

  if (iComputerTurn==PLAYER1) iOpponentColor=PLAYER2;
  else iOpponentColor=PLAYER1;

  i=EndOfGame(board);
  if (i==iComputerTurn) {
    return 1000;
  }
  if (i==iOpponentColor) {
    return -1000;
  }
  if (i==100) {		/* tie */
    return 0;
  }
  if (!MoveExists(board, iOpponentColor)) {
	iH = MaxValue(boardcpy, iComputerTurn, iXloc, iYloc, 
		iDepth+1, iAlpha, iBeta);
	if (iH<iBeta) { iBeta=iH; }
	return iBeta;
/*
    return (CalculateHeuristic(iComputerTurn, board) - CalculateHeuristic(iOpponentColor, board));
*/
  }  

  for (i=0; i<4; i++) {
   for (j=0; j<11; j++) {
      if ((board[i][j]==aryPlayerToColor[iOpponentColor][0])  ||
          (board[i][j]==aryPlayerToColor[iOpponentColor][1])) {
	    if (ValidMove(board,i,j,iOpponentColor)==1) {
		memcpy(boardcpy,board,4*11*sizeof(int));
		MakeMove(boardcpy, i, j);
		iH = MaxValue(boardcpy, iComputerTurn, iXloc, iYloc, 
			iDepth+1, iAlpha, iBeta);
		if (iH<iBeta) { iBeta=iH; }
		if (iAlpha >= iBeta) { return iBeta; }
  	    }
      }
   }
  }
  return(iBeta);
}

/***************************************************
 * Erase a board
 * This function wipes out a board with all blanks.
 ***************************************************/
void WipeBoard(int board[4][11])
{
 int i,j;

 for (i=0; i<4; i++) {
    for (j=0; j<11; j++) {
        board[i][j]=BLANK;
    }
 }
}

/***************************************************
 * Initialized the initial state of the board
 * This wipes out the board and puts pieces
 * in the starting configuration specified in the
 * rules.
 ***************************************************/
void SetupInitialBoard(int board[4][11])
{
 int i;

 for (i=0; i<4; i++) board[i][i]=YELLOW;
 for (i=0; i<3; i++) board[i+1][i]=GREEN;
 board[0][3]=GREEN;
 board[2][0]=RED; board[3][1]=RED; board[0][2]=RED; board[1][3]=RED;
 board[3][0]=BLUE; board[0][1]=BLUE; board[1][2]=BLUE; board[2][3]=BLUE;
}

/***************************************************
 * Determines whether or not a proposed move is
 * valid.  A move is denoted by the coordinates of
 * the piece that is to be moved.
 *
 * Returns 1 if the piece can be moved, 
 * 0 if you tried to move a piece that is not yours,
 * -1 if piece would cause 2 of the same color to be
 *    in a row,
 * -2 if attempt to move a lone most advanced piece,
 * -3 if invalid destination (occupied or off board)
 ***************************************************/
int ValidMove(int board[4][11], int iX, int iY, int iWhoseTurn)
{
 int i,iCount,j,iCount2;
 int iFoundMoreAdvanced;

 if ((iX<0) || (iX>=4) || (iY<0) || (iY>=11)) return(-3);

 if ((board[iX][iY]==aryPlayerToColor[iWhoseTurn][0]) ||
     (board[iX][iY]==aryPlayerToColor[iWhoseTurn][1])) {
	for (i=0,iCount=0; i<4; i++) {
	   if (board[i][iY]!=BLANK) iCount++;
	}
	if (((iY+iCount)<11) && (board[iX][iY+iCount]==BLANK)) {
  	   /* Looks like it may be valid, spot is empty */

	   /* Check condition for two of the same color if its
              in a non-scoring section of the board */
	   if ((iY+iCount)<6) {
	      for (i=0, iCount2=0; i<4; i++) {
		if (board[i][iY+iCount]==board[iX][iY]) iCount2++;
              }
	      if (iCount2>0) { 
		return(-1);
	      }
           }

	   /* Check condition for this is the most advanced piece
              and its alone in a row, so it can't be moved */
           for (i=0, iCount=0; i<4; i++) {
	      if (board[i][iY]!=BLANK) iCount++;
           }
	   if (iCount==1) {
	      iFoundMoreAdvanced=0;
	      for (j=iY+1; (!iFoundMoreAdvanced) && (j<11); j++) {
		for (i=0; (!iFoundMoreAdvanced) && (i<4); i++) {
		   if (board[i][j]==board[iX][iY]) iFoundMoreAdvanced=1;
		}
	      } 
	      if (!iFoundMoreAdvanced) {
		return(-2);
	      }
	   }

	   /* Passed all our tests, return 1 */
	   return(1);
	}
	else {
	   /* Spot is not empty or its off the board */
	   return(-3);
	}
 }
 else {
    /* A piece belonging to iPlayer is not here */
    return(0);
 }
}


/***************************************************
 * Executes a move.
 * This function assumes the move is valid.
 ***************************************************/
void MakeMove(int board[4][11], int iX, int iY)
{
 int i,j,iCount;

 for (i=0,iCount=0; i<4; i++) {
   if (board[i][iY]!=BLANK) iCount++;
 }
 board[iX][iY+iCount]=board[iX][iY]; 
 board[iX][iY]=BLANK;
}


/***************************************************
 * Initialize some of our data structures
 ***************************************************/
void InitGame(int board[4][11])
{
 int iCount1, iCount2,i;

 iCount2=2; iCount1=0;
 for (i=1; i<5; i++) {
   if (aryColorToPlayer[i]==PLAYER1) {
	aryPlayerToColor[PLAYER1][iCount1++]=i;
   }
   else {
	aryPlayerToColor[PLAYER1][iCount2++]=i;
   }
 }
 WipeBoard(board);
 SetupInitialBoard(board);
}

/***************************************************
 * Returns the current score for iPlayer.
 * This is done by merely scanning through the
 * scoring sections of the board looking for
 * pieces that belong to the player passed in.
 ***************************************************/
int CalculateScore(int iPlayer, int board[4][11])
{
 int i,j;
 int iScore=0;

 for (i=0; i<4; i++) {
	if ((board[i][10]==aryPlayerToColor[iPlayer][0]) ||
            (board[i][10]==aryPlayerToColor[iPlayer][1]))
		iScore+=60;
 }
 for (i=0; i<4; i++) {
	if ((board[i][9]==aryPlayerToColor[iPlayer][0]) ||
            (board[i][9]==aryPlayerToColor[iPlayer][1]))
		iScore+=40;
 }
 for (i=0; i<4; i++) {
	if ((board[i][8]==aryPlayerToColor[iPlayer][0]) ||
            (board[i][8]==aryPlayerToColor[iPlayer][1]))
		iScore+=30;
 }
 for (i=0; i<4; i++) {
	if ((board[i][7]==aryPlayerToColor[iPlayer][0]) ||
            (board[i][7]==aryPlayerToColor[iPlayer][1]))
		iScore+=20;
 }
 for (i=0; i<4; i++) {
	if ((board[i][6]==aryPlayerToColor[iPlayer][0]) ||
            (board[i][6]==aryPlayerToColor[iPlayer][1]))
		iScore+=10;
 }
 return(iScore);
}

/***************************************************
 * Returns the current score for iPlayer.
 * This is done by merely scanning through the
 * scoring sections of the board looking for
 * pieces that belong to the player passed in.
 ***************************************************/
int CalculateHeuristic(int iPlayer, int board[4][11])
{
 int i,j;
 int iScore=0;

 for (i=0; i<4; i++) {
	if ((board[i][10]==aryPlayerToColor[iPlayer][0]) ||
            (board[i][10]==aryPlayerToColor[iPlayer][1]))
		iScore+=60;
 }
 for (i=0; i<4; i++) {
	if ((board[i][9]==aryPlayerToColor[iPlayer][0]) ||
            (board[i][9]==aryPlayerToColor[iPlayer][1]))
		iScore+=40;
 }
 for (i=0; i<4; i++) {
	if ((board[i][8]==aryPlayerToColor[iPlayer][0]) ||
            (board[i][8]==aryPlayerToColor[iPlayer][1]))
		iScore+=30;
 }
 for (i=0; i<4; i++) {
	if ((board[i][7]==aryPlayerToColor[iPlayer][0]) ||
            (board[i][7]==aryPlayerToColor[iPlayer][1]))
		iScore+=20;
 }
 for (i=0; i<4; i++) {
	if ((board[i][6]==aryPlayerToColor[iPlayer][0]) ||
            (board[i][6]==aryPlayerToColor[iPlayer][1]))
		iScore+=10;
 }
/*
 for (j=0; j<6; j++) {
	for (i=0; i<4; i++) {
	  if ((board[i][j]==aryPlayerToColor[iPlayer][0]) ||
              (board[i][j]==aryPlayerToColor[iPlayer][1]))
		iScore+=j;
	}
 }
*/
 return(iScore);
}


/***************************************************
 * MoveExists is used to determine if it is possible
 * for a player to move.
 * Returns 1 if some move exists for the player,
 * 0 otherwise.
 ***************************************************/
int MoveExists(int board[4][11], int iWhoseTurn)
{
 int i,j;

 /* Check all locations and see if any valid move exists */
 for (i=0; i<4; i++) {
   for (j=0; j<11; j++) {
      if ((board[i][j]==aryPlayerToColor[iWhoseTurn][0])  ||
          (board[i][j]==aryPlayerToColor[iWhoseTurn][1])) {
	  if (ValidMove(board,i,j,iWhoseTurn)==1) return(1);
      }
   }
 }
 return(0);
}

/***************************************************
 * Returns -1 if the game is still in play.
 * Returns PLAYER1 if player1 has won, and
 * returns PLAYER2 if player2 has won.
 * returns 100 if a tie.
 ***************************************************/
int EndOfGame(int board[4][11])
{
 int i,j;
 int iScore1=0, iScore2=0;
 int iNumNonScore=0;
 int iReturnVal=-1;

 for (i=0; i<4; i++)
	for (j=0; j<6; j++)
		if (board[i][j]!=BLANK) iNumNonScore++;
 /* Game over if <=2 pieces on the non scoring section */
 if (iNumNonScore<=2) {
	iScore1=CalculateScore(PLAYER1,board);
	iScore2=CalculateScore(PLAYER2,board);
	if (iScore1>iScore2) return(PLAYER1);
	if (iScore2>iScore1) return(PLAYER2);
	return(100);			/* TIE */
 }
 /* If nobody can move, game is over */
 if ((!MoveExists(board,PLAYER1)) && (!MoveExists(board,PLAYER2))) {
	iScore1=CalculateScore(PLAYER1,board);
	iScore2=CalculateScore(PLAYER2,board);
	if (iScore1>iScore2) return(PLAYER1);
	if (iScore2>iScore1) return(PLAYER2);
	return(100);			/* TIE */
 }
 return iReturnVal;
}

