/****************************************************
 * Upthurst Dumb Computer implementation
 *
 * This code is intended only as an example of
 * how to implement an AI game playing client
 * that will interface with the game manager.
 *
 * This particular AI simply selects the
 * first move that it finds is valid.
 *
 * Feel free to use any code from this file.
 *
 * Kenrick Mock 10/17/98
 * kenrick@cs.pdx.edu
 *
 ****************************************************/
#include <stdio.h>
#include <stdlib.h>
#include "globals.h"
#include "client_ai.h"


/***************************************************
 * This function returns the first move
 * possible that is valid.  If no moves are
 * valid, this function returns -1, -1.
 *
 * You should replace this with your own AI routines.
 ***************************************************/

void ComputeMove(int board[4][11], int iWhoseTurn, int *iXloc, int *iYloc)
{
 int i,j;

 /* Check all locations and see if any valid move exists */
 for (i=0; i<4; i++) {
   for (j=0; j<11; j++) {
      if ((board[i][j]==aryPlayerToColor[iWhoseTurn][0])  ||
          (board[i][j]==aryPlayerToColor[iWhoseTurn][1])) {
	  if (ValidMove(board,i,j,iWhoseTurn)==1) {
		*iXloc=i;
		*iYloc=j;
		return;
	  }
      }
   }
 }
 *iXloc=-1;
 *iYloc=-1;
}


/***************************************************
 * Erase a board
 * This function wipes out a board with all blanks.
 ***************************************************/
void WipeBoard(int board[4][11])
{
 int i,j;

 for (i=0; i<4; i++) {
    for (j=0; j<11; j++) {
        board[i][j]=BLANK;
    }
 }
}

/***************************************************
 * Initialized the initial state of the board
 * This wipes out the board and puts pieces
 * in the starting configuration specified in the
 * rules.
 ***************************************************/
void SetupInitialBoard(int board[4][11])
{
 int i;

 for (i=0; i<4; i++) board[i][i]=YELLOW;
 for (i=0; i<3; i++) board[i+1][i]=GREEN;
 board[0][3]=GREEN;
 board[2][0]=RED; board[3][1]=RED; board[0][2]=RED; board[1][3]=RED;
 board[3][0]=BLUE; board[0][1]=BLUE; board[1][2]=BLUE; board[2][3]=BLUE;
}

/***************************************************
 * Determines whether or not a proposed move is
 * valid.  A move is denoted by the coordinates of
 * the piece that is to be moved.
 *
 * Returns 1 if the piece can be moved, 
 * 0 if you tried to move a piece that is not yours,
 * -1 if piece would cause 2 of the same color to be
 *    in a row,
 * -2 if attempt to move a lone most advanced piece,
 * -3 if invalid destination (occupied or off board)
 ***************************************************/
int ValidMove(int board[4][11], int iX, int iY, int iWhoseTurn)
{
 int i,iCount,j,iCount2;
 int iFoundMoreAdvanced;

 if ((iX<0) || (iX>=4) || (iY<0) || (iY>=11)) return(-3);

 if ((board[iX][iY]==aryPlayerToColor[iWhoseTurn][0]) ||
     (board[iX][iY]==aryPlayerToColor[iWhoseTurn][1])) {
	for (i=0,iCount=0; i<4; i++) {
	   if (board[i][iY]!=BLANK) iCount++;
	}
	if (((iY+iCount)<11) && (board[iX][iY+iCount]==BLANK)) {
  	   /* Looks like it may be valid, spot is empty */

	   /* Check condition for two of the same color if its
              in a non-scoring section of the board */
	   if ((iY+iCount)<6) {
	      for (i=0, iCount2=0; i<4; i++) {
		if (board[i][iY+iCount]==board[iX][iY]) iCount2++;
              }
	      if (iCount2>0) { 
		return(-1);
	      }
           }

	   /* Check condition for this is the most advanced piece
              and its alone in a row, so it can't be moved */
           for (i=0, iCount=0; i<4; i++) {
	      if (board[i][iY]!=BLANK) iCount++;
           }
	   if (iCount==1) {
	      iFoundMoreAdvanced=0;
	      for (j=iY+1; (!iFoundMoreAdvanced) && (j<11); j++) {
		for (i=0; (!iFoundMoreAdvanced) && (i<4); i++) {
		   if (board[i][j]==board[iX][iY]) iFoundMoreAdvanced=1;
		}
	      } 
	      if (!iFoundMoreAdvanced) {
		return(-2);
	      }
	   }

	   /* Passed all our tests, return 1 */
	   return(1);
	}
	else {
	   /* Spot is not empty or its off the board */
	   return(-3);
	}
 }
 else {
    /* A piece belonging to iPlayer is not here */
    return(0);
 }
}


/***************************************************
 * Executes a move.
 * This function assumes the move is valid.
 ***************************************************/
void MakeMove(int board[4][11], int iX, int iY)
{
 int i,j,iCount;

 for (i=0,iCount=0; i<4; i++) {
   if (board[i][iY]!=BLANK) iCount++;
 }
 board[iX][iY+iCount]=board[iX][iY]; 
 board[iX][iY]=BLANK;
}


/***************************************************
 * Initialize some of our data structures
 ***************************************************/
void InitGame(int board[4][11])
{
 int iCount1, iCount2,i;

 iCount2=2; iCount1=0;
 for (i=1; i<5; i++) {
   if (aryColorToPlayer[i]==PLAYER1) {
	aryPlayerToColor[PLAYER1][iCount1++]=i;
   }
   else {
	aryPlayerToColor[PLAYER1][iCount2++]=i;
   }
 }
 WipeBoard(board);
 SetupInitialBoard(board);
}
 
