/******************************************************************
 * 10/17/98 KJM
 *
 * Dumb Upthrust player.  This program is intended as an example
 * of how to interface with the game manager.  Feel free to use
 * any code from here as you see fit.
 *******************************************************************/

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include "globals.h"
#include "client_io.h"
#include "client_ai.h"

/*************************************************************
 *
 * The format we are expecting arguments is:
 *
 * argv[0] = program name   (ignore)
 * argv[1] = 4 of {r,g,b,y} 1 of {0,1}   
 *	     the first two colors represent the colors for us
 *           and the second two colors are the opponents.
 *           The last characters is 1 if we move first and
 *           0 if we move second.
 *
 * For example, if argv[1]="rybg 0" then it means that
 * our colors are red and yellow while the opponent is
 * blue and green.  The 0 indicates that we move second.
 * Using this format, we are always player 1 and the
 * opponent is always player 2.
 *
 * If argv[1]="byrg 1" then our colors are blue and yellow
 * while the opponent is red and green and we move first.
 *
 *************************************************************/
void ShowUsage();

main(int argc, char *argv[])
{
 int i;						/* Loop */
 int iWeMoveFirst;				/* We move first? */
 int iCount1, iCount2;				/* Counters for data structs */
 int x,y;					/* The Move */
 
 /* For the following routines, you will have to modify this
    code to initialize whatever structures you are using to
    represent the game board, color assignments, etc.
    First extract what color we are and who moves first.
 */
 if (argc!=2) { 
   ShowUsage();
   exit(0);
 }

 if (argv[1][5]=='0') {
   iWeMoveFirst=0;		/* We move second */
 }
 else {
   iWeMoveFirst=1;		/* We move first */
 }

 for (i=0; i<2; i++) {		/* Get our colors, we're always player 1 */
   if (argv[1][i]=='r') aryColorToPlayer[RED]=PLAYER1;
   if (argv[1][i]=='g') aryColorToPlayer[GREEN]=PLAYER1;
   if (argv[1][i]=='b') aryColorToPlayer[BLUE]=PLAYER1;
   if (argv[1][i]=='y') aryColorToPlayer[YELLOW]=PLAYER1;
 }
 for (i=2; i<4; i++) {		/* Get opponents colors, always player 2 */
   if (argv[1][i]=='r') aryColorToPlayer[RED]=PLAYER2;
   if (argv[1][i]=='g') aryColorToPlayer[GREEN]=PLAYER2;
   if (argv[1][i]=='b') aryColorToPlayer[BLUE]=PLAYER2;
   if (argv[1][i]=='y') aryColorToPlayer[YELLOW]=PLAYER2;
 }

 /* The following initializes some internal structures to 
    play the game.  This program needs it, but yours
    may not if your board data structures are set up differently.
 */
 InitGame(aryBoard);

 
 /*************************** MAIN PROGRAM LOOP *******************/
  
 if (iWeMoveFirst) {       
    ComputeMove(aryBoard, PLAYER1, &x, &y);  /* Replace with your AI routine */
    MakeMove(aryBoard, x, y);
    SendMoveToOpponent(x,y);
 } 

 /* Loop forever, getting a move and then sending our reply move.
    Assumes the server will stop the game when a winner is found */

 while(1) {
    GetMoveFromOpponent(&x,&y);
    if ((x==-1)  || (y==-1)) {
	/* Opponent had to skip their move */
    }
    else {
	MakeMove(aryBoard, x, y);
    }
    ComputeMove(aryBoard, PLAYER1, &x, &y);  /* Replace with your AI routine */
    if ((x==-1)  || (y==-1)) {
	/* We had to skip their move */
    }
    else {
    	MakeMove(aryBoard, x, y);
    }
    SendMoveToOpponent(x,y);
 }
}



void ShowUsage()
{
   printf("Usage: dumbclient \"{rgby} {0,1}\"\n");
   printf("e.g.: dumbclient \"rgby 1\" for this program play red, green, and move first.\n");
   printf("Intended for usage only from the upthrust game manager program.\n");
}

