/****************************************************
 * Upthurst Computer 2-player implementation
 *
 * Kenrick Mock 9/24/98
 * kenrick@cs.pdx.edu
 *
 * I make no guarantee as to the non-existence of bugs
 * or game correctness in this program :)  It has been
 * created as a way for you to experiment with the
 * game and possibly use as a starting base to create
 * your own AI-game playing program.  Of course, you don't
 * have to use this code as the basis for your own
 * program.  In fact, there are many areas where
 * different data structures will decrease the amount
 * of computation necessary.  
 *
 * The code is somewhat documented, but not completely.
 * Contact me if you have any questions.
 *
 ****************************************************/
#include <stdio.h>
#include <stdlib.h>
#include "globals.h"
#include "upthrust.h"

/***************************************************
 * Returns the current score for iPlayer.
 * This is done by merely scanning through the
 * scoring sections of the board looking for
 * pieces that belong to the player passed in.
 ***************************************************/
int CalculateScore(int iPlayer, int board[4][11])
{
 int i;
 int iScore=0;

 for (i=0; i<4; i++) {
	if ((board[i][10]==aryPlayerToColor[iPlayer][0]) ||
            (board[i][10]==aryPlayerToColor[iPlayer][1]))
		iScore+=60;
 }
 for (i=0; i<4; i++) {
	if ((board[i][9]==aryPlayerToColor[iPlayer][0]) ||
            (board[i][9]==aryPlayerToColor[iPlayer][1]))
		iScore+=40;
 }
 for (i=0; i<4; i++) {
	if ((board[i][8]==aryPlayerToColor[iPlayer][0]) ||
            (board[i][8]==aryPlayerToColor[iPlayer][1]))
		iScore+=30;
 }
 for (i=0; i<4; i++) {
	if ((board[i][7]==aryPlayerToColor[iPlayer][0]) ||
            (board[i][7]==aryPlayerToColor[iPlayer][1]))
		iScore+=20;
 }
 for (i=0; i<4; i++) {
	if ((board[i][6]==aryPlayerToColor[iPlayer][0]) ||
            (board[i][6]==aryPlayerToColor[iPlayer][1]))
		iScore+=10;
 }
 return(iScore);
}


/***************************************************
 * Display the board to the screen.
 * This routine could use improvement to make
 * it easier to visualize the game board.
 * If you have a better version please let me know
 * so I can make it available to all!
 * 
 * Player 1's pieces are in uppercase while
 * player 2's pieces are shown in lowercase.
 ***************************************************/
void ShowBoard(int board[4][11])
{
 int i,j;

 printf("\n");
 for (j=10; j>=0; j--) {
   printf("%2d:      ",j);
   for (i=0; i<4; i++) {
	if (board[i][j]==RED) {
	   if (aryColorToPlayer[RED]==PLAYER1) printf("R ");
	   else printf("r ");
        }
	else if (board[i][j]==GREEN) {
	   if (aryColorToPlayer[GREEN]==PLAYER1) printf("G ");
	   else printf("g ");
        }
	else if (board[i][j]==BLUE) {
	   if (aryColorToPlayer[BLUE]==PLAYER1) printf("B ");
	   else printf("b ");
        }
	else if (board[i][j]==YELLOW) {
	   if (aryColorToPlayer[YELLOW]==PLAYER1) printf("Y ");
	   else printf("y ");
        }
        else printf(". ");
   }
   if (j==10) printf("  60");
   else if (j==9) printf("  40");
   else if (j==8) printf("  30");
   else if (j==7) printf("  20");
   else if (j==6) printf("  10\n");
   printf("\n");
 }
 printf("         -------\n");
 printf("         0 1 2 3\n\n");
 if (iWhoseTurn==PLAYER1) printf("Move %d: It is player 1's turn. ",iTurnNum);
 else printf("Move %d: It is player 2's turn. ",iTurnNum);
 printf("Your colors are: ");
 for (i=0; i<2; i++) {
  if (aryPlayerToColor[iWhoseTurn][i]==RED) printf("Red "); 
  else if (aryPlayerToColor[iWhoseTurn][i]==GREEN) printf("Green "); 
  else if (aryPlayerToColor[iWhoseTurn][i]==BLUE) printf("Blue "); 
  else if (aryPlayerToColor[iWhoseTurn][i]==YELLOW) printf("Yellow "); 
 }
 printf("\nPlayer 1's Score: %d    Player 2's Score: %d\n\n",
	CalculateScore(PLAYER1,aryBoard), CalculateScore(PLAYER2,aryBoard));
}

/***************************************************
 * Erase a board
 * This function wipes out a board with all blanks.
 ***************************************************/
void WipeBoard(int board[4][11])
{
 int i,j;

 for (i=0; i<4; i++) {
    for (j=0; j<11; j++) {
        board[i][j]=BLANK;
    }
 }
}

/***************************************************
 * Initialized the initial state of the board
 * This wipes out the board and puts pieces
 * in the starting configuration specified in the
 * rules.
 ***************************************************/
void SetupInitialBoard(int board[4][11])
{
 int i;

 for (i=0; i<4; i++) board[i][i]=YELLOW;
 for (i=0; i<3; i++) board[i+1][i]=GREEN;
 board[0][3]=GREEN;
 board[2][0]=RED; board[3][1]=RED; board[0][2]=RED; board[1][3]=RED;
 board[3][0]=BLUE; board[0][1]=BLUE; board[1][2]=BLUE; board[2][3]=BLUE;
}

/***************************************************
 * Determines whether or not a proposed move is
 * valid.  A move is denoted by the coordinates of
 * the piece that is to be moved.
 *
 * Returns 1 if the piece can be moved, 
 * 0 if you tried to move a piece that is not yours,
 * -1 if piece would cause 2 of the same color to be
 *    in a row,
 * -2 if attempt to move a lone most advanced piece,
 * -3 if invalid destination (occupied or off board)
 ***************************************************/
int ValidMove(int board[4][11], int iX, int iY, int iWhoseTurn)
{
 int i,iCount,j,iCount2;
 int iFoundMoreAdvanced;

 if ((iX<0) || (iX>=4) || (iY<0) || (iY>=11)) return(0);

 if ((board[iX][iY]==aryPlayerToColor[iWhoseTurn][0]) ||
     (board[iX][iY]==aryPlayerToColor[iWhoseTurn][1])) {
	for (i=0,iCount=0; i<4; i++) {
	   if (board[i][iY]!=BLANK) iCount++;
	}
	if (((iY+iCount)<11) && (board[iX][iY+iCount]==BLANK)) {
  	   /* Looks like it may be valid, spot is empty */

	   /* Check condition for two of the same color if its
              in a non-scoring section of the board */
	   if ((iY+iCount)<6) {
	      for (i=0, iCount2=0; i<4; i++) {
		if (board[i][iY+iCount]==board[iX][iY]) iCount2++;
              }
	      if (iCount2>0) { 
		return(-1);
	      }
           }

	   /* Check condition for this is the most advanced piece
              and its alone in a row, so it can't be moved */
           for (i=0, iCount=0; i<4; i++) {
	      if (board[i][iY]!=BLANK) iCount++;
           }
	   if (iCount==1) {
	      iFoundMoreAdvanced=0;
	      for (j=iY+1; (!iFoundMoreAdvanced) && (j<11); j++) {
		for (i=0; (!iFoundMoreAdvanced) && (i<4); i++) {
		   if (board[i][j]==board[iX][iY]) iFoundMoreAdvanced=1;
		}
	      } 
	      if (!iFoundMoreAdvanced) {
		return(-2);
	      }
	   }

	   /* Passed all our tests, return 1 */
	   return(1);
	}
	else {
	   /* Spot is not empty or its off the board */
	   return(-3);
	}
 }
 else {
    /* A piece belonging to iPlayer is not here */
    return(0);
 }
}

/***************************************************
 * MoveExists is used to determine if it is possible
 * for a player to move.
 * Returns 1 if some move exists for the player,
 * 0 otherwise.
 ***************************************************/
int MoveExists(int board[4][11], int iWhoseTurn)
{
 int i,j;

 /* Check all locations and see if any valid move exists */
 for (i=0; i<4; i++) {
   for (j=0; j<11; j++) {
      if ((board[i][j]==aryPlayerToColor[iWhoseTurn][0])  ||
          (board[i][j]==aryPlayerToColor[iWhoseTurn][1])) {
	  if (ValidMove(board,i,j,iWhoseTurn)==1) return(1);
      }
   }
 }
 return(0);
}

/***************************************************
 * Inputs a move from the player.
 * This function assumes some move exists
 * or else we'll not be invoked.
 ***************************************************/
void GetMove(int board[4][11], int iWhoseTurn, int *iXloc, int *iYloc)
{
 char sRow[10], sCol[10],i;
 int iX=-1, iY=-1, iValid=0;

 while (!iValid) {
   printf("Select piece to move.  Enter the coordinates of the piece in the format 'x y'.\n");
   scanf("%s %s", sRow, sCol);
   iX=atoi(sRow);
   iY=atoi(sCol);
   i=ValidMove(board, iX, iY, iWhoseTurn);
   if (i==1) iValid=1;
   else if (i==0) printf("Invalid move.  You don't have a piece at that location.\n");
   else if (i==-1) printf("Invalid move.  You cannot have two pieces of the same color in the same row in the non-scoring section of the board.\n");
   else if (i==-2) printf("Invalid move.  You cannot move your most advanced piece if it is the only piece in the row.\n");
   else printf("Invalid move.  The destination is occupied or off the end of the board.\n");
 }
 *iXloc=iX;
 *iYloc=iY;
}

/***************************************************
 * Executes a move.
 * This function assumes the move is valid.
 ***************************************************/
void MakeMove(int board[4][11], int iX, int iY)
{
 int i,j,iCount;

 for (i=0,iCount=0; i<4; i++) {
   if (board[i][iY]!=BLANK) iCount++;
 }
 board[iX][iY+iCount]=board[iX][iY]; 
 board[iX][iY]=BLANK;
}

/***************************************************
 * Returns -1 if the game is still in play.
 * Returns PLAYER1 if player1 has won, and
 * returns PLAYER2 if player2 has won.
 ***************************************************/
int EndOfGame(int board[4][11])
{
 int i,j;
 int iScore1=0, iScore2=0;
 int iNumNonScore=0;
 int iReturnVal=-1;

 for (i=0; i<4; i++)
	for (j=0; j<6; j++)
		if (board[i][j]!=BLANK) iNumNonScore++;
 /* Game over if <=2 pieces on the non scoring section */
 if (iNumNonScore<=2) {
	iScore1=CalculateScore(PLAYER1,board);
	iScore2=CalculateScore(PLAYER2,board);
	if (iScore1>iScore2) return(PLAYER1);
	else return(PLAYER2);
 }
 /* If nobody can move, game is over */
 if ((!MoveExists(board,PLAYER1)) && (!MoveExists(board,PLAYER2))) {
	iScore1=CalculateScore(PLAYER1,board);
	iScore2=CalculateScore(PLAYER2,board);
	if (iScore1>iScore2) return(PLAYER1);
	else return(PLAYER2);
 }
 return iReturnVal;
}


/***************************************************
 * main routine
 ***************************************************/
main()
{
 int i;
 int iWinner;
 int iRow, iColumn;
 char sColor1[50], sColor2[50];
 int iCount1=0, iCount2=0;

 /* Initialization */
 for (i=1; i<5; i++) aryColorToPlayer[i]=-1;
 strcpy(sColor1,"");
 strcpy(sColor2,"");
 printf("\n\nWelcome to Computer Upthrust v0.1.  This version is for 2 players only.\n");
 printf("For information on how to play, see the rules at \n");
 printf("http://www.cs.pdx.edu/~kenrick/cs441/\n");
 printf("This code is intended for educational purposes only.  Upthrust was\n");
 printf("invented by Sid Sackson (c) THE INVENTORS COLLECTION 1987/1996.\n\n");
 printf("Enter two colors for player 1: (R G B Y)\n");
 scanf("%s %s",sColor1,sColor2);
 /* Kind of ugly way to setup the data structures for the players */
 if ((sColor1[0]=='r') || (sColor1[0]=='R')) aryColorToPlayer[RED]=PLAYER1;
 if ((sColor1[0]=='g') || (sColor1[0]=='G')) aryColorToPlayer[GREEN]=PLAYER1;
 if ((sColor1[0]=='y') || (sColor1[0]=='Y')) aryColorToPlayer[YELLOW]=PLAYER1;
 if ((sColor1[0]=='b') || (sColor1[0]=='B')) aryColorToPlayer[BLUE]=PLAYER1;
 if ((sColor2[0]=='r') || (sColor2[0]=='R')) aryColorToPlayer[RED]=PLAYER1;
 if ((sColor2[0]=='g') || (sColor2[0]=='G')) aryColorToPlayer[GREEN]=PLAYER1;
 if ((sColor2[0]=='y') || (sColor2[0]=='Y')) aryColorToPlayer[YELLOW]=PLAYER1;
 if ((sColor2[0]=='b') || (sColor2[0]=='B')) aryColorToPlayer[BLUE]=PLAYER1;
 iCount1=0; iCount2=0;
 for (i=1; i<5; i++) {
   if (aryColorToPlayer[i]==-1) {
	aryColorToPlayer[i]=PLAYER2; 
        aryPlayerToColor[PLAYER2][iCount2++]=i;
   }
   else {
        aryPlayerToColor[PLAYER1][iCount1++]=i;
   }
 }

 WipeBoard(aryBoard);
 SetupInitialBoard(aryBoard);
 iTurnNum=0;
 iWhoseTurn=PLAYER1;			/* Player 1 always goes first */

 while ((iWinner=EndOfGame(aryBoard))==-1) {
	iTurnNum++;
        ShowBoard(aryBoard);
	if (MoveExists(aryBoard,iWhoseTurn)) {
  	   GetMove(aryBoard, iWhoseTurn, &iRow, &iColumn);
	   MakeMove(aryBoard, iRow, iColumn);
	}
	else {
	   printf("SORRY, no move exists for you, player ");
           if (iWhoseTurn==PLAYER1) printf("one.  You lose your turn!\n");
           else printf("two.  You lose your turn!\n");
	}
	if (iWhoseTurn==PLAYER1) iWhoseTurn=PLAYER2;
	else iWhoseTurn=PLAYER1;
 }
 ShowBoard(aryBoard);
 printf("\nGAME OVER.\n");
 if (iWinner==PLAYER1) printf("Player 1 is the winner!\n");
 else printf("Player 2 is the winner!\n");
}


