using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;

namespace Connect_The_Dots
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.Button slnbutton;
		private System.Windows.Forms.Button ptsbutton;
		private System.Windows.Forms.Button prevbutton;
		private System.Windows.Forms.OpenFileDialog openSlnsDialog;
		private System.Windows.Forms.OpenFileDialog openPtsDialog;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			ptsbutton.Enabled=true;
			slnbutton.Enabled=false;
			prevbutton.Enabled=false;
			//if you want to add more, do it here!
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.ptsbutton = new System.Windows.Forms.Button();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.slnbutton = new System.Windows.Forms.Button();
			this.prevbutton = new System.Windows.Forms.Button();
			this.openPtsDialog = new System.Windows.Forms.OpenFileDialog();
			this.openSlnsDialog = new System.Windows.Forms.OpenFileDialog();
			this.SuspendLayout();
			// 
			// ptsbutton
			// 
			this.ptsbutton.Location = new System.Drawing.Point(8, 8);
			this.ptsbutton.Name = "ptsbutton";
			this.ptsbutton.TabIndex = 0;
			this.ptsbutton.Text = "Show Points";
			this.ptsbutton.Click += new System.EventHandler(this.points_Click);
			// 
			// pictureBox1
			// 
			this.pictureBox1.Location = new System.Drawing.Point(16, 40);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(440, 432);
			this.pictureBox1.TabIndex = 2;
			this.pictureBox1.TabStop = false;
			this.pictureBox1.Paint += new System.Windows.Forms.PaintEventHandler(this.pictureBox1_Paint);
			// 
			// slnbutton
			// 
			this.slnbutton.Location = new System.Drawing.Point(112, 8);
			this.slnbutton.Name = "slnbutton";
			this.slnbutton.Size = new System.Drawing.Size(128, 23);
			this.slnbutton.TabIndex = 0;
			this.slnbutton.Text = "Next Solution";
			this.slnbutton.Click += new System.EventHandler(this.next_Click);
			// 
			// prevbutton
			// 
			this.prevbutton.Location = new System.Drawing.Point(272, 8);
			this.prevbutton.Name = "prevbutton";
			this.prevbutton.Size = new System.Drawing.Size(128, 23);
			this.prevbutton.TabIndex = 0;
			this.prevbutton.Text = "Previous Solution";
			this.prevbutton.Click += new System.EventHandler(this.previous_Click);
			// 
			// openPtsDialog
			// 
			this.openPtsDialog.InitialDirectory = "../../";
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.BackColor = System.Drawing.SystemColors.ActiveBorder;
			this.ClientSize = new System.Drawing.Size(464, 494);
			this.Controls.Add(this.pictureBox1);
			this.Controls.Add(this.ptsbutton);
			this.Controls.Add(this.slnbutton);
			this.Controls.Add(this.prevbutton);
			this.Name = "Form1";
			this.Text = "Display GA Solutions";
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		private double[,] xycoords;
		private int[,] soln;

		private int currsoln;

		private int spacing; //solely dealing with display

		private int numpoints;
		private int numslns;
		//keeps track of how many solutions we've looked at so it can stop at the end

		private bool ispntset= false;
		private bool isslnset= false;

		private StreamReader pntfile;
		private StreamReader slnfile;

		private void pictureBox1_Paint(object sender, System.Windows.Forms.PaintEventArgs e)
		{
			if(ispntset)PaintPoints(sender, e);
			if(isslnset)PaintSolution(sender, e);
		}

		//check if points are set and if solutions are also set, if true call that function
		
		private void PaintPoints(object sender,System.Windows.Forms.PaintEventArgs e)
		{
			System.Drawing.Pen pp = new Pen(System.Drawing.Brushes.BlueViolet,3.0f);
			System.Drawing.Brush bb = Brushes.BurlyWood;

			////the points
			spacing=40;
			for(int i=0; i<numpoints; i++)
			{
				int xx=(int)(xycoords[i,0]*spacing), yy=(int)(xycoords[i,1]*spacing);
				//Console.WriteLine("pts: x={0} y={1}", xx, yy);
				Point p=new Point(xx,yy);
				e.Graphics.DrawEllipse(pp,p.X,p.Y,3,3);
			}	
			e.Graphics.DrawRectangle(Pens.BlueViolet,0,0,spacing*10,spacing*10);		
		}
		//assumes xycoords is allocated and set to valid values and is happy
		//paints points
		
		private void PaintSolution(object sender, System.Windows.Forms.PaintEventArgs e){
			System.Drawing.Pen pp = new Pen(System.Drawing.Brushes.BlueViolet,3.0f);
			System.Drawing.Brush bb = Brushes.DarkGoldenrod;
			System.Drawing.Font ff = new Font("Times New Roman",10);
			int height = this.Size.Height;
			e.Graphics.DrawString("Showing solution "+(currsoln+1)+" out of "+numslns, ff, bb, 10,420);

			Point[] pts= new Point[numpoints];			
			double origx,origy;
			for(int i=0; i<numpoints; i++){
				origx = xycoords[soln[currsoln,i],0];
				origy = xycoords[soln[currsoln,i],1];
				pts[i]=new Point((int)(origx*spacing),(int)(origy*spacing));		
				//Console.WriteLine("sol: x = {0}, y = {1}",(int)(origx*spacing),(int)(origy*spacing));
			}
			e.Graphics.DrawLines(Pens.Chartreuse,pts);		
		}

		//assumes soln is allocated and set to valid values and is happy, and solncnt too
		//paints lines for solutions
		
		private void points_Click(object sender, System.EventArgs e)
		{
			
			if(!ispntset)
			{
				openPtsDialog.ShowDialog();
				pntfile = new StreamReader(openPtsDialog.OpenFile());
				string storagestr;
				string[] xy;
				storagestr = pntfile.ReadLine();
				int size = int.Parse(storagestr);
				numpoints=size;
				xycoords=new double[numpoints,2];
			
				for(int i=0; i<numpoints;i++)
				{
					storagestr=pntfile.ReadLine();
					xy=storagestr.Split();
					if(xy.Length==2)
					{ 
						xycoords[i,0]=double.Parse(xy[0]);
						xycoords[i,1]=double.Parse(xy[1]);
					}
					else
					{ 
						Console.WriteLine("ERROR!!! (line {0}, length is {1})",i+2,xy.Length);
						Console.WriteLine("args:  |{0}|{1}|{2}|{3}|{4}|",xy);
					}
				}
				ispntset=true;
				pictureBox1.Invalidate();		
				ptsbutton.Enabled=false;
				slnbutton.Enabled=true;
			}
		}

		//IF !ispntset it reads and saves numpoints
		//then it allocates space
		//then it reads in numbers and saves them in xycoords
		//then it sets ispntset to true
		//and then it invalidates picture box
		//ELSE it does nada!

		private void previous_Click(object sender, System.EventArgs e)
		{
			currsoln--;
			if(currsoln==0) prevbutton.Enabled=false;
			pictureBox1.Invalidate();
			slnbutton.Enabled=true;
		}

		//
		private void next_Click(object sender, System.EventArgs e)
		{
			if(!isslnset)
			{
				openSlnsDialog.ShowDialog();
				slnfile=new StreamReader(openSlnsDialog.OpenFile());

				numslns=int.Parse(slnfile.ReadLine());
				soln = new int[numslns,numpoints];

				for(int ii=0; ii<numslns; ii++)
				{
					string[] solnstrs = slnfile.ReadLine().Split();
					for(int i=0; i<numpoints; i++)
					{
						soln[ii,i]=int.Parse(solnstrs[i]);	
					}
				}
				isslnset=true;
				currsoln=0;
				pictureBox1.Invalidate();
				
			}

			else
			{
				currsoln++;
				pictureBox1.Invalidate();
				prevbutton.Enabled=true;
				if(currsoln==numslns-1) slnbutton.Enabled=false;
			}
		}

		//IF !ispntset it does nada
		//ELSE IF !isslnset it reads and saves numslns
		//then it allocates space for soln[numslns,numpts] 
		//then it reads the solutions from the file 
		//and copies them to soln
		//then it sets currsoln to 0 and isslnset to true
		//and then it invalidates the picture box
		//ELSE IF isslnset and currsoln<numslns-1
		//increments currsoln by 1
		//and then it invalidates picture box
		//ELSE (slncnt>=numslns) it does nix nada null nuttin


		/*TOADD:
		 Make both show up right off the bat,
		 Allow going foward adn back
		 Allow showing more than one at a time
		 Make a fn to output a solution file*/
	}
}
