using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;

namespace Heat_Bug_Viewer
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private System.ComponentModel.IContainer components;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
			
			Play.Enabled=false;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this.LoadData = new System.Windows.Forms.Button();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.Play = new System.Windows.Forms.Button();
			this.timer1 = new System.Windows.Forms.Timer(this.components);
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.openFileDialog1 = new System.Windows.Forms.OpenFileDialog();
			this.SuspendLayout();
			// 
			// LoadData
			// 
			this.LoadData.Location = new System.Drawing.Point(16, 16);
			this.LoadData.Name = "LoadData";
			this.LoadData.Size = new System.Drawing.Size(128, 24);
			this.LoadData.TabIndex = 0;
			this.LoadData.Text = "Load Data";
			this.LoadData.Click += new System.EventHandler(this.LoadData_Click);
			// 
			// pictureBox1
			// 
			this.pictureBox1.Location = new System.Drawing.Point(16, 56);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(408, 368);
			this.pictureBox1.TabIndex = 1;
			this.pictureBox1.TabStop = false;
			this.pictureBox1.Paint += new System.Windows.Forms.PaintEventHandler(this.pictureBox1_Paint);
			// 
			// Play
			// 
			this.Play.Location = new System.Drawing.Point(168, 16);
			this.Play.Name = "Play";
			this.Play.Size = new System.Drawing.Size(88, 24);
			this.Play.TabIndex = 2;
			this.Play.Text = "Play";
			this.Play.Click += new System.EventHandler(this.Play_Click);
			// 
			// timer1
			// 
			this.timer1.Interval = 200;
			this.timer1.Tick += new System.EventHandler(this.timer1_Tick);
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(312, 24);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(32, 16);
			this.label1.TabIndex = 3;
			this.label1.Text = "Time:";
			this.label1.Click += new System.EventHandler(this.label1_Click);
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(360, 24);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(32, 16);
			this.label2.TabIndex = 4;
			this.label2.Click += new System.EventHandler(this.label2_Click);
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(440, 438);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.Play);
			this.Controls.Add(this.pictureBox1);
			this.Controls.Add(this.LoadData);
			this.Name = "Form1";
			this.Text = "Form1";
			this.ResumeLayout(false);

		}
		#endregion
		
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		
		private System.Windows.Forms.Button LoadData;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.Button Play;

		private int time = 0;
		private System.Windows.Forms.Timer timer1;
		private int gridsize;
		private int howlong;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private double[][,] HeatArray;
		private System.Windows.Forms.OpenFileDialog openFileDialog1;
		private int[][,] BugsArray;


		private void LoadData_Click(object sender, System.EventArgs e)
		{
			openFileDialog1.ShowDialog();
			Stream inputstream = openFileDialog1.OpenFile();

			StreamReader SR = new StreamReader(inputstream);

			string[] splitline9;
			splitline9 = SR.ReadLine().Split();

			check(splitline9.Length==2,"Invalid first line of data file");
			gridsize=int.Parse(splitline9[0]);
			howlong=int.Parse(splitline9[1]);

			HeatArray=new double[howlong][,];
			BugsArray=new int[howlong][,];

			for(int i=0; i<howlong; i++)
			{
				HeatArray[i]=new double[gridsize,gridsize];
				BugsArray[i]=new int[gridsize,gridsize];

				//READ and save heat array
				SR.ReadLine();
				for(int ii=0; ii<gridsize; ii++)
				{
					string[] splitline = SR.ReadLine().Split(); //read empty line
					check(splitline.Length>=gridsize,"Error reading data line");
					for(int iii=0; iii<gridsize; iii++){
						HeatArray[i][ii,iii]=double.Parse(splitline[iii]);
					}
				}

				//READ and save bugs array
				SR.ReadLine();
				for(int n=0; n<gridsize; n++)
				{
					string[] splitline = SR.ReadLine().Split();
					check(splitline.Length>=gridsize,"Error reading data line");
					for(int nn=0; nn<gridsize; nn++)
					{
						BugsArray[i][n,nn]=int.Parse(splitline[nn]);
					}
				}
			}

			Play.Enabled=true;
			LoadData.Enabled=false;
			SR.Close();
		}
		//loads the data from the file and stores it to be played
		//allows the play button to be clicked

		private void Play_Click(object sender, System.EventArgs e)
		{
			if (Play.Text == "Play") 
			{
				timer1.Enabled = true;
				Play.Text = "Stop";
			}
			else 
			{
				timer1.Enabled = false;
				Play.Text = "Play";
			}
		}
		
		//causes animation and timer to start and stop 

		private void pictureBox1_Paint(object sender, System.Windows.Forms.PaintEventArgs e)
		{
			if(Play.Enabled){
				//paint the matrix corresponding to the current time


				int cellPixelWidth = pictureBox1.Width / gridsize;		
				int cellPixelHeight = pictureBox1.Height / gridsize;

				// Loop through the current 2D array out of heatData
				int x,y;
				for (y=0; y<gridsize; y++) 
				{
					for (x=0; x<gridsize; x++) 
					{
						// heatData is an ArrayList, and anything stored in it is
						// referenced of type "Object".  This means we have to typecast
						// each entry back to what the actual type is, in this case,
						// a 2D array of doubles
						double[,] ary = (double[,]) HeatArray[time];
						// Compute a RGB for the value stored in this cell
						int redShade = (int) (ary[x,y]*255);
						if(redShade>255)redShade=255;

						Brush b;
						if(BugsArray[time][x,y]==0) b = new SolidBrush(Color.FromArgb(redShade,0,0));
						else b = new SolidBrush(Color.Chartreuse);
						// Draw a rectangle in the given color
						e.Graphics.FillRectangle(b, x*cellPixelWidth, y*cellPixelHeight, cellPixelWidth, cellPixelHeight);	
					}
				}
			}
		}

		//if play has been validated it paints the screen according to what time it is

		private void timer1_Tick(object sender, System.EventArgs e)
		{
	    	// Update counter to display next 2D array
			if (++time >= howlong)
			{
				time=0;
			}
			label2.Text="  "+time;
			pictureBox1.Invalidate();		// Forces a call to pictureBox1_Paint
		}

		//increments time for animation

		private void check(bool b, string mess){
			if(!b) Console.WriteLine(mess);
		}

		private void label2_Click(object sender, System.EventArgs e)
		{
		
		}

		private void label1_Click(object sender, System.EventArgs e)
		{
		
		}

	}
}
