﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Windows.Forms.DataVisualization.Charting;

namespace BenfordsLaw
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void readFile(string path)
        {
            StreamReader f = new StreamReader(path);
            int[] digitCount = new int[10];     // This array is to count how many of the first digit we read
            int total = 0;

            // Initially we have seen zero 0's, zero 1's, zero 2's, zero 3's, etc. to set each entry to zero
            for (int i = 0; i < 10; i++)
                digitCount[i] = 0;

            // Read every number from the file
            while (!f.EndOfStream)
            {
                string s = f.ReadLine();        // Read the number
                // The line below figures out what the first digit is
                // Ask me how this works if you're interested
                int firstDigit = (s[0] - (char) '0');
                // Increment by one the count of how many times we have seen digit 0, 1, 2, etc.
                digitCount[firstDigit]++;
                total++; // Total how many numbers we've read in
            }
            // Used for drawing the graph
            int[] xValues = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9 };
            double[] yValues = new double[10];

            /*************************************************
             * No need to mess with anything above here
             * 
             * At this point:
             *    digitCount[0] contains the number of 0's that are the first digit
             *    digitCount[1] contains the number of 1's that are the first digit
             *    ...
             *    digitCount[9] contains the number of 9's that are the first digit             
             *    total   contains how many numbers we read in.
             *
             * 
             * TO DO
             * 
             * Write code that sets
             *   yValues[0] to the % of 0's that are the first digit
             *   yValues[1] to the % of 1's that are the first digit
             *   yValues[2] to the % of 2's that are the first digit
             *   ...
             *   yValues[9] to the % of 9's that are the first digit
             *************************************************/





            /****************************************************
             * No need to mess with anything below here
             ****************************************************/
            // Draw the graph using the data in xValues and yValues
            chartHistogram.Series[0].Points.Clear();
            chartHistogram.ChartAreas[0].AxisX.Interval = 1;
            chartHistogram.ChartAreas[0].AxisX.Minimum = 0;
            chartHistogram.ChartAreas[0].AxisX.Maximum = 10;
            chartHistogram.Series[0].Points.DataBindXY(xValues, yValues);
        }

        private void btnUAA_Click(object sender, EventArgs e)
        {
            readFile("enrollments.txt");
        }

        private void btnInternet_Click(object sender, EventArgs e)
        {
            readFile("internethosts.txt");
        }

        private void btnLiveJournal_Click(object sender, EventArgs e)
        {
            readFile("livejournal.txt");
        }
    }
}
