import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.lang.Thread;
import java.util.*;
import java.util.Timer;
import java.util.TimerTask;
/**
 * Description of the Class
 *
 * The purpose of this class is to provide the Plant-Moose-Predator Simulation with a basic application frame at the stage when 
 * the simulation is being run
 *
 *@author    Anastasia Mironova
 *@created   February 15, 2003
 */
public class PMPSimMainFrame extends JFrame{
	private static PMPSimMainFrame mf;
	private LandscapeContainerPanel landscapeContainer;
	private PMPSimMenuBar menubar = null;
	private PMPSim simulation = null;
	private TimeLabel timeLabel = null;
	//the timer of the simulation
	private Timer timer;
	
	//anticipated future additions:
	
	//private static PMPSimToolBar toolbar = null;
	//private static Dimension dimension;
	//private JPanel landscapeHolder;
	//private JPanel segmentHolder;
	//private Landscape landscape = null;
	//private LandscapeSegment currentSegment;
	/**
	 * Constructor for the PMPSimMainFrame frame
	 */
	public PMPSimMainFrame(PMPSim simulationParameters) {
		super("Plant-Moose-Predator Simulation");
		
		mf = this;
		
		timer = new Timer();
		
		//create a simulation object
		simulation = simulationParameters;
		
		getContentPane().setLayout(new BorderLayout());

		//create the panel with a menu bar in the upper prtion of the application frame
		createTopPanel();
		
		//create panel with the time counter
		createTimeCounterPanel();
		
		//create bottom panel with landscape
		createBottomPanel();
		
		//handle window closing events
		this.addWindowListener(new WindowAdapter() {
		public void windowClosing(WindowEvent e) {
			stopTimer();
			dispose();
			System.exit(0);
		}
		});
		pack();
	}
	
	
	//Creates a panel with a menu bar and toolbar in the upper portion of the frame
	private void createTopPanel(){
		JPanel toppanel = new JPanel();
		toppanel.setLayout(new BorderLayout());
		//Create menu bar
		menubar = new PMPSimMenuBar();
		toppanel.add("North", menubar);
		//Create tool bar
		//toolbar = new PMPSimToolBar(parent, vtkpanel);
		//toppanel.add("South", toolbar);
		getContentPane().add(toppanel, BorderLayout.NORTH);
	}
	
	
	//Creates a panel with a time counter
	private void createTimeCounterPanel(){
		JPanel timeCounterPanel = new JPanel();
		
		JLabel TimeCounterLabel = new JLabel();
		timeLabel = new TimeLabel();
		JButton startButton = new JButton();
		JButton restartButton = new JButton();
		JButton stopButton = new JButton();
		
		TimeCounterLabel.setText("Time Counter: ");
		TimeCounterLabel.setToolTipText("null");
		timeCounterPanel.add(TimeCounterLabel);
		
		timeCounterPanel.add(timeLabel);
		
		startButton.setText("Start");
		startButton.addActionListener( new ActionListener(){
			public void actionPerformed(ActionEvent e){
				buttonStartActionPerformed();
			}
		});
		timeCounterPanel.add(startButton);
		
		restartButton.setText("Restart");
		restartButton.addActionListener( new ActionListener(){
			public void actionPerformed(ActionEvent e){
				buttonRestartActionPerformed();
			}
		});
		timeCounterPanel.add(restartButton);
		
		stopButton.setText("Stop");
		stopButton.addActionListener( new ActionListener(){
			public void actionPerformed(ActionEvent e){
				buttonStopActionPerformed();
			}
		});
		timeCounterPanel.add(stopButton);
		getContentPane().add(timeCounterPanel, BorderLayout.SOUTH);
	}
	
	//Creates a panel at the bottom of the screen, allowing the user to see the landscape layout
	private void createBottomPanel(){
		JPanel bottompanel = new JPanel();
		bottompanel.setLayout(new BorderLayout());
		
		landscapeContainer = new LandscapeContainerPanel(simulation.getLandscape());
		bottompanel.add(landscapeContainer);
		getContentPane().add(bottompanel, BorderLayout.CENTER);
	}
	
	
	/*
	This is a thread that updates the timer every second
	*/
	class UpdateTimer extends TimerTask {
		public void run() {
			timeLabel.increment();
			timer.schedule(new UpdateTimer(), 1000);
		}
	}
	
	/*
	Methods to handle the timer
	*/
	//stops the timer of the simulation
	public void stopTimer(){
		timer.cancel();
	}
	
	//updates the timer every second
	public void startTimer(){
		timer.schedule(new UpdateTimer(), 0);
	}
	
	// termintes the simulation
	private void buttonStopActionPerformed(){
		stopTimer();
	}
	
	//starts the timer for the simulation
	private void buttonStartActionPerformed(){
		startTimer();
	}
	
	//restarts the timer of the simulation
	private void buttonRestartActionPerformed(){
		timeLabel.reset();
	}
	
	//returns the instance of this object
	public static JFrame getFrame(){
		return mf;
	}
	
	
	/*
	Close MainFrame 
	*/
	public void closeFrame() {
		dispose();
	}
	
}
