/**
 * Description of class
 * The purpose of this class is to provide the user of the Plant-Moose-Predator System Simulatio
 * with means for viewing the statics of the simulation being run
 * This toolbar resides on top of the main application frame called PMPSimMainFrame.java
 *
 *@author    Anastasia Mironova
 *@created   November 11, 2003
 */
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.Point;
import java.lang.*;
import java.util.*;
import java.io.*;

class PMPSimMenuBar extends JMenuBar{
	private JMenuItem save = null;
	private JMenuItem load = null;
	private JMenuItem restart = null;
	private JMenuItem exit = null;
	private JFileChooser chooser = null;
	private JMenuItem viewAgents = null;
	/**
	 * Constructor for a new PMPSimMenuBar object, this process involves creating two associated components: tools menu
	 * and agents menu, the means for constructing those objects are provided below
	 */
	public PMPSimMenuBar() {
		super();
		createToolsMenu();
		createAgentsMenu();
	}
	
	/**
	 * Create Tools Menu
	 */
	public void createToolsMenu() {
		JPopupMenu.setDefaultLightWeightPopupEnabled(false);
		
		JMenu menu = new JMenu("Tools");
		menu.setMnemonic(KeyEvent.VK_T);
		
		//create new restart menu item
		restart = new JMenuItem("Restart");
		restart.setMnemonic(KeyEvent.VK_R);
		restart.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					
				}
			});
		
		//create new save menu item
		save = new JMenuItem("Save");
		save.setMnemonic(KeyEvent.VK_S);
		save.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					
				}
			});
		
		//create new load menu item
		load = new JMenuItem("Load");
		load.setMnemonic(KeyEvent.VK_L);
		load.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					
				}
			});
		
		//create new exit menu item
		exit = new JMenuItem("Exit");
		exit.setMnemonic(KeyEvent.VK_E);
		exit.addActionListener(
				new ActionListener() {
					public void actionPerformed(ActionEvent e) {
						System.exit(0);
					}
				});
		
		//Add creates items to the menu
		menu.add(restart);
		menu.add(load);
		menu.add(save);
		menu.add(exit);
		add(menu);
	}
	
	
	/**
	 * Create Agents Menu
	 */
	public void createAgentsMenu() {
		JPopupMenu.setDefaultLightWeightPopupEnabled(false);
		
		JMenu menu = new JMenu("Agents");
		menu.setMnemonic(KeyEvent.VK_A);
		
		//create new view agents menu item
		viewAgents = new JMenuItem("View Agents");
		viewAgents.setMnemonic(KeyEvent.VK_R);
		viewAgents.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					//show a frame displaying the lists of all the existing agents in the scene
					(new PMPSimAgentsFrame()).show();
				}
			});
		
		//Add creates items to the menu
		menu.add(viewAgents);
		add(menu);
	}
}
