/**
 * SimulationParametersMainFrame
 * 
 * Description of Class
 * 
 * The purpose of this class is to provide the GUI components for setting the basic parameters of the plant-moose-predator
 * system simulation
 * This is the first frame the user sees when the application is started
 * 
 * This form was constructed using the Sun One Studio 4.1 Community edition IDE
 * Created on 8 March 2004
 *
 * @author  Anastasia V Mironova
 */
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

import java.util.Vector;

public class SimulationParametersMainFrame extends JFrame {
	
	private PMPSim simulation;
	private JLabel sqMeterLabel;
	private JPanel landscapeHeightPanel;
	private JLabel xLabel2;
	private JTextField numberOfPlantsField;
	private JPanel landscapeWidthHeightPanelPanel;
	private JPanel moosePanel;
	private JPanel landscapeAdvancedSpecificaitonsPanel;
	private JLabel landscapeHeightLabel;
	private JLabel sqMeterLabel3;
	private JPanel jPanel10;
	private JButton submitButton;
	private JLabel sqMeterLabel2;
	private JPanel landscapeAdvancedContainerPanel;
	private JLabel dimensionsLabel;
	private JLabel landscapeCellSizeSpecificationLabel;
	private JPanel containerPanel;
	private JButton landscapeAdvancedSpecificationsButton;
	private JButton cancelButton;
	private JPanel jPanel7;
	private JPanel landscapeCellSizeValuesPanel;
	private JLabel xLabel1;
	private JPanel landscapeAdvancedInnerSpecificationsPanel;
	private JLabel landscapeWidthValueLabel;
	private JLabel landscapeAdvancedSpecificationsLabel;
	private JTextField inputHeightField;
	private JSeparator jSeparator3;
	private JLabel numberOfPlantsLabel;
	private JLabel cellSizeLabel2;
	private JPanel plantsPanel;
	private JPanel landscapeWidthPanel;
	private JPanel landscapeParametersPanel;
	private JLabel equalSignLabel;
	private JLabel landscapeCellSizeValueLabel;
	private JPanel parametersPanel;
	private JPanel mainPanel;
	private JTextField inputWidthField;
	private JPanel landscapeCellSizePanel;
	private JPanel jPanel8;
	private JLabel cellSizeLabel1;
	private JPanel predatorsPanel;
	private JSeparator jSeparator1;
	private JPanel landscapeDimensionsPanel;
	private JButton jButton4;
	private JLabel landscapeHeightValueLabel;
	private JLabel landscapeWidthLabel;
	private JButton changeLandscapeCellSizeButton;
	private JPanel jPanel9;
	private JPanel numberOfPlantsPanel;
	private JPanel bottomPanel;
	private JPanel plantsSpecificationsPanel;
	private JComboBox predefinedPlantSpeciesComboBox;
	private JTextField numberOfCustomPlantsField;
	private JButton addCustomPlantsButton;
	
	
	/*Create a new Simulation ParametersMainFrame
	*/
	public SimulationParametersMainFrame() {
		super("Create New Simulation");
		
		//initialize the simulation object
		simulation = new PMPSim();
		
		//initialize all the GUI components
		mainPanel = new JPanel();
		parametersPanel = new JPanel();
		landscapeParametersPanel = new JPanel();
		landscapeDimensionsPanel = new JPanel();
		dimensionsLabel = new JLabel();
		landscapeWidthHeightPanelPanel = new JPanel();
		landscapeWidthPanel = new JPanel();
		landscapeWidthLabel = new JLabel();
		inputWidthField = new JTextField();
		xLabel1 = new JLabel();
		cellSizeLabel1 = new JLabel();
		equalSignLabel = new JLabel();
		landscapeWidthValueLabel = new JLabel();
		sqMeterLabel = new JLabel();
		jSeparator1 = new JSeparator();
		landscapeHeightPanel = new JPanel();
		landscapeHeightLabel = new JLabel();
		inputHeightField = new JTextField();
		xLabel2 = new JLabel();
		cellSizeLabel2 = new JLabel();
		landscapeHeightValueLabel = new JLabel();
		sqMeterLabel2 = new JLabel();
		landscapeCellSizePanel = new JPanel();
		landscapeCellSizeSpecificationLabel = new JLabel();
		landscapeCellSizeValuesPanel = new JPanel();
		landscapeCellSizeValueLabel = new JLabel();
		sqMeterLabel3 = new JLabel();
		changeLandscapeCellSizeButton = new JButton();
		landscapeAdvancedSpecificaitonsPanel = new JPanel();
		landscapeAdvancedInnerSpecificationsPanel = new JPanel();
		jSeparator3 = new JSeparator();
		landscapeAdvancedContainerPanel = new JPanel();
		containerPanel = new JPanel();
		landscapeAdvancedSpecificationsLabel = new JLabel();
		landscapeAdvancedSpecificationsButton = new JButton();
		plantsPanel = new JPanel();
		numberOfPlantsPanel = new JPanel();
		jPanel8 = new JPanel();
		numberOfPlantsLabel = new JLabel();
		numberOfPlantsField = new JTextField();
		jButton4 = new JButton();
		jPanel9 = new JPanel();
		moosePanel = new JPanel();
		jPanel7 = new JPanel();
		predatorsPanel = new JPanel();
		jPanel10 = new JPanel();
		bottomPanel = new JPanel();
		submitButton = new JButton();
		cancelButton = new JButton();
		
		//handle window closing events
		addWindowListener(new WindowAdapter() {
		    public void windowClosing(WindowEvent evt) {
			System.exit(0);
		    }
		});
		
		//outline the characteristics of the main panel of the frame
		mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.Y_AXIS));
		
		parametersPanel.setLayout(new BoxLayout(parametersPanel, BoxLayout.Y_AXIS));
		
		parametersPanel.setBorder(new EtchedBorder());
		
		//outline the panel for characterizing the two-dimensional landscape model
		landscapeParametersPanel.setLayout(new BorderLayout());
		
		landscapeParametersPanel.setBorder(new TitledBorder("Landscape"));
		landscapeDimensionsPanel.setLayout(new BoxLayout(landscapeDimensionsPanel, BoxLayout.X_AXIS));
		
		dimensionsLabel.setText("Dimensions:         ");
		landscapeDimensionsPanel.add(dimensionsLabel);
		
		landscapeWidthHeightPanelPanel.setLayout(new BoxLayout(landscapeWidthHeightPanelPanel, BoxLayout.Y_AXIS));
		
		landscapeWidthLabel.setText("Width ");
		landscapeWidthPanel.add(landscapeWidthLabel);
		
		inputWidthField.setColumns(5);
		inputWidthField.setText("6");
		inputWidthField.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				resetDimensionsLabels();
			}
		});

		landscapeWidthPanel.add(inputWidthField);
		
		xLabel1.setText("X");
		landscapeWidthPanel.add(xLabel1);
		
		cellSizeLabel1.setText("Cell Size*");
		landscapeWidthPanel.add(cellSizeLabel1);
		
		equalSignLabel.setText("=");
		landscapeWidthPanel.add(equalSignLabel);
		
		landscapeWidthValueLabel.setText("30");
		landscapeWidthPanel.add(landscapeWidthValueLabel);
		
		sqMeterLabel.setText("sq m");
		landscapeWidthPanel.add(sqMeterLabel);
		
		landscapeWidthHeightPanelPanel.add(landscapeWidthPanel);
		
		landscapeWidthHeightPanelPanel.add(jSeparator1);
		
		landscapeHeightLabel.setText("Height");
		landscapeHeightPanel.add(landscapeHeightLabel);
		
		inputHeightField.setColumns(5);
		inputHeightField.setText("6");
		inputHeightField.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				resetDimensionsLabels();
			}
		});
		landscapeHeightPanel.add(inputHeightField);
		
		xLabel2.setText("X");
		landscapeHeightPanel.add(xLabel2);
		
		cellSizeLabel2.setText("Cell Size* =");
		landscapeHeightPanel.add(cellSizeLabel2);
		
		landscapeHeightValueLabel.setText("30");
		landscapeHeightPanel.add(landscapeHeightValueLabel);
		
		sqMeterLabel2.setText("sq m");
		landscapeHeightPanel.add(sqMeterLabel2);
		
		landscapeWidthHeightPanelPanel.add(landscapeHeightPanel);
		
		landscapeDimensionsPanel.add(landscapeWidthHeightPanelPanel);
		
		landscapeParametersPanel.add(landscapeDimensionsPanel, BorderLayout.NORTH);
		
		landscapeCellSizePanel.setLayout(new FlowLayout(FlowLayout.RIGHT));
		
		landscapeCellSizeSpecificationLabel.setText("*Cell Size :");
		landscapeCellSizePanel.add(landscapeCellSizeSpecificationLabel);
		
		landscapeCellSizeValuesPanel.setLayout(new FlowLayout(FlowLayout.RIGHT));
		
		landscapeCellSizeValueLabel.setText("5");
		landscapeCellSizeValuesPanel.add(landscapeCellSizeValueLabel);
		
		sqMeterLabel3.setText("sq m");
		landscapeCellSizeValuesPanel.add(sqMeterLabel3);
		
		changeLandscapeCellSizeButton.setText("Change");
		changeLandscapeCellSizeButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				setCellSizeValue();
				resetDimensionsLabels();
			}
		});
		landscapeCellSizeValuesPanel.add(changeLandscapeCellSizeButton);
		
		landscapeCellSizePanel.add(landscapeCellSizeValuesPanel);
		
		landscapeParametersPanel.add(landscapeCellSizePanel, BorderLayout.CENTER);
		
		landscapeAdvancedSpecificaitonsPanel.setLayout(new BorderLayout());
		
		landscapeAdvancedInnerSpecificationsPanel.setLayout(new BoxLayout(landscapeAdvancedInnerSpecificationsPanel, BoxLayout.Y_AXIS));
		
		landscapeAdvancedInnerSpecificationsPanel.add(jSeparator3);
		
		landscapeAdvancedContainerPanel.setLayout(new FlowLayout(FlowLayout.RIGHT));
		
		containerPanel.setLayout(new BorderLayout());
		
		landscapeAdvancedSpecificationsLabel.setText("Define patches, elevation, etc.:                               ");
		containerPanel.add(landscapeAdvancedSpecificationsLabel, BorderLayout.CENTER);
		
		landscapeAdvancedContainerPanel.add(containerPanel);
		
		//add a button that takes the user to the rest of the components for inputting advanced characteristics of the 
		//desired landscape model
		landscapeAdvancedSpecificationsButton.setText("Advanced");
		
		landscapeAdvancedSpecificationsButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				setLandscapeParameters();
				(new AdvancedLandscapeSpecificationsFrame(simulation)).show();
			}
		});
		
		landscapeAdvancedContainerPanel.add(landscapeAdvancedSpecificationsButton);
		
		landscapeAdvancedInnerSpecificationsPanel.add(landscapeAdvancedContainerPanel);
		
		landscapeAdvancedSpecificaitonsPanel.add(landscapeAdvancedInnerSpecificationsPanel, BorderLayout.CENTER);
		
		landscapeParametersPanel.add(landscapeAdvancedSpecificaitonsPanel, BorderLayout.SOUTH);
		
		parametersPanel.add(landscapeParametersPanel);
		
		//create the panel, allowing for adding plants to the landscape
		plantsSpecificationsPanel = new JPanel();
		plantsSpecificationsPanel.setLayout(new BoxLayout(plantsSpecificationsPanel, BoxLayout.Y_AXIS));
		plantsSpecificationsPanel.setBorder(new TitledBorder("Plants"));
		
		plantsPanel.setLayout(new BoxLayout(plantsPanel, BoxLayout.Y_AXIS));
		
		plantsPanel.setBorder(new TitledBorder("Predefined Species"));
		numberOfPlantsPanel.setLayout(new BoxLayout(numberOfPlantsPanel, BoxLayout.Y_AXIS));
		
		Vector predefinedPlants = new Vector();
		
		predefinedPlants.addElement("Salix pulchra");
		predefinedPlants.addElement("Salix alaxensis");
		predefinedPlants.addElement("Populus tremuloides");
		predefinedPlants.addElement("Betula nana");
		
		predefinedPlantSpeciesComboBox = new JComboBox(predefinedPlants);
		jPanel8.add(predefinedPlantSpeciesComboBox);
		
		numberOfPlantsLabel.setText("Number of this type: ");
		jPanel8.add(numberOfPlantsLabel);
		
		numberOfPlantsField.setColumns(5);
		numberOfPlantsField.setText("0");
		jPanel8.add(numberOfPlantsField);
		
		numberOfPlantsPanel.add(jPanel8);
		
		jPanel9.setLayout(new FlowLayout(FlowLayout.RIGHT));
		
		numberOfPlantsPanel.add(jPanel9);
		
		plantsPanel.add(numberOfPlantsPanel);
		
		JPanel panel = new JPanel();
		panel.setLayout(new FlowLayout(FlowLayout.RIGHT));
		JButton jButton5 = new JButton();
		jButton5.setText("View Parameters");
		panel.add(jButton5);
		
		jButton4.setText("Add");
		panel.add(jButton4);
		
		plantsPanel.add(panel);
		
		plantsSpecificationsPanel.add(plantsPanel);
		
		JPanel customPlantsPanel = new JPanel();
		customPlantsPanel.setLayout(new BoxLayout(customPlantsPanel, BoxLayout.Y_AXIS));
		customPlantsPanel.setBorder(new TitledBorder("Custom Species"));
		
		JPanel customPlantsContainerPanel = new JPanel();
		customPlantsContainerPanel.setLayout(new BoxLayout(customPlantsContainerPanel, BoxLayout.X_AXIS));
		
		JPanel customPlantsContainerNumberLabelPanel = new JPanel();
		customPlantsContainerNumberLabelPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
		customPlantsContainerNumberLabelPanel.add(new JLabel("Number of Plants "));
		customPlantsContainerPanel.add(customPlantsContainerNumberLabelPanel);
		
		JPanel customPlantsContainerNumberFieldPanel = new JPanel();
		customPlantsContainerNumberFieldPanel.setLayout(new FlowLayout(FlowLayout.RIGHT));
		numberOfCustomPlantsField = new JTextField(5);
		numberOfCustomPlantsField.setText("0");
		customPlantsContainerNumberFieldPanel.add(numberOfCustomPlantsField);
		customPlantsContainerPanel.add(customPlantsContainerNumberFieldPanel);
		
		customPlantsPanel.add(customPlantsContainerPanel);
		
		addCustomPlantsButton = new JButton("Customize");
		addCustomPlantsButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent evt){
				activateCustomPlantsFrame();
			}
		});
		JPanel customPlantsButtonPanel = new JPanel();
		customPlantsButtonPanel.setLayout(new FlowLayout(FlowLayout.RIGHT));
		customPlantsButtonPanel.add(addCustomPlantsButton);
		customPlantsPanel.add(customPlantsButtonPanel);
		plantsSpecificationsPanel.add(customPlantsPanel);
		
		parametersPanel.add(plantsSpecificationsPanel);
		
		
		//empty panel for allowing the user to add moose to the scene
		moosePanel.setLayout(new BorderLayout());
		
		moosePanel.setBorder(new TitledBorder("Moose"));
		jPanel7.setLayout(new BoxLayout(jPanel7, BoxLayout.Y_AXIS));
		
		moosePanel.add(jPanel7, BorderLayout.CENTER);
		
		parametersPanel.add(moosePanel);
		
		//empty panel for allowing the user to add predators to the scene
		predatorsPanel.setLayout(new BorderLayout());
		
		predatorsPanel.setBorder(new TitledBorder("Predators"));
		jPanel10.setLayout(new BoxLayout(jPanel10, BoxLayout.Y_AXIS));
		
		predatorsPanel.add(jPanel10, BorderLayout.CENTER);
		
		parametersPanel.add(predatorsPanel);
		
		//create generalCharacteristicsPanel
		JPanel generalCharacteristicsPanel = new JPanel();
		generalCharacteristicsPanel.setLayout(new BorderLayout());
		generalCharacteristicsPanel.setBorder(new TitledBorder("General Characteristics"));
		parametersPanel.add(generalCharacteristicsPanel);
		
		mainPanel.add(parametersPanel);
		
		bottomPanel.setLayout(new FlowLayout(FlowLayout.RIGHT));
		
		//submit button locks all the characteristics specified so far for the simulation object
		//and takes the user to the stage when the simulation can actually be run
		submitButton.setText("Submit");
		submitButton.addActionListener( new ActionListener(){
			public void actionPerformed(ActionEvent e){
				setLandscapeParameters();
				activateTheMainApplicationFrame();
				dispose();
			}
		});
		bottomPanel.add(submitButton);
		//exit the application
		cancelButton.setText("Exit");
		cancelButton.addActionListener( new ActionListener(){
			public void actionPerformed(ActionEvent e){
				System.exit(0);
			}
		});
		bottomPanel.add(cancelButton);
		
		mainPanel.add(bottomPanel);
		
		getContentPane().add(mainPanel, BorderLayout.CENTER);
		
		pack();
    	}
	
	//create or redefine the landscape given the values of the appropriate text fields
	public void setLandscapeParameters(){
		//set single cell size
		LandscapeSegment.setLengthIncrement(getCellSizeValue());
		
		//set grid dimensions of the landscape
		simulation.initializeLandscape(new Dimension(Integer.parseInt(inputWidthField.getText()), Integer.parseInt(inputHeightField.getText())));
	}
	
	/*
	Resets the dimensions labels of this frame, this action is triggered by hitting the "Enter" key or the "Submit" button
	*/
	private void resetDimensionsLabels(){
		landscapeWidthValueLabel.setText("" + (getCellSizeValue()*(Integer.parseInt(inputWidthField.getText()))));
		landscapeHeightValueLabel.setText("" + (getCellSizeValue()*(Integer.parseInt(inputHeightField.getText()))));
	}
	
	/*
	Locks all the characteristics specified so far for the simulation object
	and takes the user to the stage when the simulation can actually be run
	*/
	private void activateTheMainApplicationFrame(){
		PMPSimMainFrame a = (new PMPSimMainFrame(simulation));
		a.show();
	}
	
	/*
	Activates the number of plants frame
	*/
	private void activateCustomPlantsFrame(){
		boolean temp = true;
		try{
			//check to see if the number of plants desired to be customized is equal to one, in which case the
			//appropriate GUI component is generated with additional set of customizable characteristics
			if (Integer.parseInt(numberOfCustomPlantsField.getText()) == 1){
				temp = false;
			}
			CustomPlantFrame a = new CustomPlantFrame(temp);
			a.show();
		} catch(NumberFormatException e) {
			System.out.println("Invalid entry!");
		}
	}
	
	
	/*
	Get/set the single cell size
	*/
	private int getCellSizeValue(){
		return (Integer.parseInt(landscapeCellSizeValueLabel.getText()));
	}
	
	/*
	Set the value of the side length for a single cell in the landscape model
	*/
	private void setCellSizeValue(){
		try{
			int temp = Integer.parseInt(new JOptionPane().showInputDialog("Change side length of a single cell to: "));
			landscapeCellSizeValueLabel.setText("" + temp);
		} catch(NumberFormatException e){
			System.out.println("Invalid entry!");
		}
	}
	
	
	/** Start the applicaton GUI of the Plant-Moose-Predator System Simulation
	*/
	public static void main(String[] args){
		SimulationParametersMainFrame a = (new SimulationParametersMainFrame());
		a.show();
	}
	
}

