import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.lang.Thread;
import java.util.*;

/**
 * Description of the Class
 *
 * This is a label for representing time in the PMP simulation system
 *
 *@author    Anastasia Mironova
 *@created   March 8, 2003
 */
public class TimeLabel extends JLabel{
	private int hours = 0;
	private int minutes = 0;
	private int seconds = 0;
	/**
	 * Constructor for the TimeLabel object
	 	Initially all the values on this label are set to 0
	 */
	public TimeLabel() {
		super();
		resetTimerContents();
	}
	
	//this method increments the timer by one time unit
	public void increment(){
		//try to increment seconds
		if ((seconds + 1) == 60){
			seconds = 0;
			//try to increment minutes
			if ((minutes + 1) == 60){
				minutes = 0;
				//try to increment hours
				if ((hours + 1) == 60){
					//"overflow" occurred, set hours to 0
					hours = 0;
				} else {
					hours++;
				}
			} else {
				minutes++;
			}
		} else {
			seconds++;
		}
		resetTimerContents();
	}
	
	//resets the contents of the label
	public void resetTimerContents(){
		String s;
		//making the display "look nice"
		if (("" + hours).length() == 1){
			s = "0" + hours;
		} else {
			s = "" + hours;
		}
		if (("" + minutes).length() == 1){
			s = s + ":0" + minutes;
		} else {
			s = s + ":" + minutes;
		}
		if (("" + seconds).length() == 1){
			s = s + ":0" + seconds;
		} else {
			s = s + ":" + seconds;
		}
		//this.setText("" + hours + ":" + minutes + ":" + seconds);
		this.setText(s);
	}
	
	//resets the contents of the label to all 0's
	public void reset(){
		seconds = 0;
		minutes = 0;
		hours = 0;
		resetTimerContents();
	}
}
