#include "mpi.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

int main(int argc, char ** argv)
{
	int rank, size;

	FILE *inFile;
	FILE *outFile;
	int i, n, nElts;
	int j, k;
	
	double *A, *B;
	double *C;
	double *D;
	

  MPI_Init(&argc, &argv);
  MPI_Comm_size(MPI_COMM_WORLD, &size);
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);

	if(rank == 0)
	{
		if(argc != 3)
		{
			printf("usage: %s InputFile OutputFile\n", argv[0]);
			MPI_Finalize();
			exit(-1);
		}
		inFile = fopen(argv[1], "r");
		if(NULL == inFile)
			{
			printf("Unable to open input file, exiting\n");
			MPI_Finalize();
			exit(-1);
			}
		fscanf(inFile, "%d\n", &n);
		nElts = n*n;
	}
	
	MPI_Bcast(&nElts, 1, MPI_INT, 0, MPI_COMM_WORLD);
	MPI_Bcast(&n, 1, MPI_INT, 0, MPI_COMM_WORLD);
	
	A = (double *) malloc(nElts * sizeof(double));
	if(NULL == A)
	{
		printf("allocation of array A failed, exiting\n");
		MPI_Finalize();
		exit(-1);
	}
	B = (double *) malloc(nElts * sizeof(double));
	if(NULL == B)
	{
		printf("allocation of array B failed, exiting\n");
		MPI_Finalize();
		exit(-1);
	} 
	C = (double *) malloc(nElts * sizeof(double));
	if(NULL == C)
	{
		printf("allocation of array C failed, exiting\n");
		MPI_Finalize();
		exit(-1);
	}
	if (rank==0)
	{
		D = (double *) malloc(nElts * sizeof(double));
		if(NULL == D)
		{
			printf("allocation of array D failed, exiting\n");
			MPI_Finalize();
			exit(-1);
		}
		for(i=0; i<nElts; i++) {
			if (i%n==0) fscanf(inFile, "\n");
			fscanf(inFile, "%lf", &(A[i]));
		}
		for(i=0; i<nElts; i++) {
			if (i%n==0) fscanf(inFile, "\n");
			fscanf(inFile, "%lf", &(B[i]));
		}
		fclose(inFile);
		printf("File read success.\n");
		
		printf("A:\t");
		for (i=0; i<nElts; i++)
			printf("%lf ",A[i]);
		printf("\n");
		printf("B:\t");
		for (i=0; i<nElts; i++)
			printf("%lf ",B[i]);
		printf("\n");
		
	}
	MPI_Bcast(A, nElts, MPI_DOUBLE, 0, MPI_COMM_WORLD);
	MPI_Bcast(B, nElts, MPI_DOUBLE, 0, MPI_COMM_WORLD);
  
	//computation
	for (i = 0; i<n; i++)
		for (j=0; j<n; j++) {
			C[(i*n)+j]=0;
			if (((i*n)+j)%size==rank) {
				for (k = 0; k < n; k++)
					C[(i*n)+j] += (double)A[(i*n)+k] * (double)B[(k*n)+j];
			}
		}

		printf("%d\t",rank);
		for (i=0; i<nElts; i++)
			printf("%lf ",C[i]);
		printf("\n");
				
	//if you're not id 0 then send your array indexes with valued to id 0
	for (i = 0; i<nElts; i++)
		MPI_Reduce(&C[i], &D[i], 1, MPI_DOUBLE, MPI_MAX, 0, MPI_COMM_WORLD);
		
	if(rank == 0) {	
		printf("Final out:\n");
		for (i=0; i<nElts; i++)
			printf("%lf ",D[i]);
		printf("\n");		
		outFile = fopen(argv[2], "w");
		if(NULL == outFile)
			{
			printf("Unable to open output file, exiting\n");
			MPI_Finalize();
			exit(-1);
			}
		
		for(i=0; i<n; i++)
			{
			for(j=0; j<n; j++)
				fprintf(outFile,"%lf ", D[n*i + j]);
			fprintf(outFile,"\n");
			}
		fclose(outFile);
	}
  MPI_Finalize();
  exit(0);
}
