import java.lang.Math;
import java.sql.*;

/**
 *  Calculates statistics from the ratings data.
 *  Calculates accuracy, precision, recall, negative recall and negative precision.
 *
 * @author     Brandon Douthit-Wood
 * @created    March 31, 2004
 */
public class CalculateStats {

	/**
	 *  Calculates statistics for predicted ratings.
	 *
	 * @param  args  The command line arguments
	 */
	public static void main( String[] args ) {
		String query = "";
		int truePos = 0;
		int trueNeg = 0;
		int falsePos = 0;
		int falseNeg = 0;
		int actualRating;
		int predictedRating;
		int numRatings;
		double accuracy;
		double precision;
		double recall;
		double negPrecision;
		double negRecall;

		if ( !Query.connectToDB() ) {
			System.exit( 0 );
		}

		// get all ratings from test set
		System.out.println("Getting predicted ratings...");
		query = "select rating,rating2 from rating where rating2 != 0";
		ResultSet ratingResult = Query.executeQuery( query );

		numRatings = Query.getNumResults( ratingResult );
		System.out.println(numRatings + " ratings found");

		try {
			while ( ratingResult.next() ) {
				actualRating = ( new Integer( ratingResult.getString( "rating" ) ) ).intValue();
				predictedRating = ( new Integer( ratingResult.getString( "rating2" ) ) ).intValue();

				System.out.println( numRatings-- );

				// keep track of true positive, true negative, false positive and false negative
				if ( Math.abs( actualRating - predictedRating ) == 0 ) {
					if ( actualRating <= 2 ) {
						trueNeg++;
					}
					else {
						truePos++;
					}
				}
				else if ( actualRating <= 2 && predictedRating <= 3 ) {
					trueNeg++;
				}
				else if ( actualRating <= 2 && predictedRating > 3 ) {
					falsePos++;
				}
				else if ( actualRating >= 3 && predictedRating >= 3 ) {
					truePos++;
				}
				else if ( actualRating >= 3 && predictedRating < 3 ) {
					falseNeg++;
				}
			}
			ratingResult.close();
		}
		catch ( SQLException e ) {
			System.err.println( "Error calculating prediction statistics..." );
			e.printStackTrace();
			System.exit( 0 );
		}

		// calculate statistics
		accuracy = ( (double) ( truePos + trueNeg ) ) / ( (double) ( trueNeg + truePos + falseNeg + falsePos ) );
		precision = ( (double) ( truePos ) ) / ( (double) ( truePos + falsePos ) );
		recall = ( (double) ( truePos ) ) / ( (double) ( truePos + falseNeg ) );
		negPrecision = ( (double) ( trueNeg ) ) / ( (double) ( trueNeg + falseNeg ) );
		negRecall = ( (double) ( trueNeg ) ) / ( (double) ( trueNeg + falsePos ) );

		// display results
		System.out.println( "\n****************************************\n" );
		System.out.println( "   Accuracy:   			" + accuracy );
		System.out.println( "   Precision:  			" + precision );
		System.out.println( "   Recall:     			" + recall );
		System.out.println( "   Negative Precision:  " + negPrecision );
		System.out.println( "   Negative Recall:     " + negRecall );
		System.out.println( "\n****************************************\n" );
	}
}

