import java.io.*;
import java.sql.*;
import java.util.*;
import java.util.regex.*;

/**
 *  Parses the IMDB actors data file and loads it into the database.
 *
 * @author     Brandon Douthit-Wood
 * @created    March 31, 2004
 */
public class ParseIMDBActors {

	final static String filename = "data/actors.list";

	/**
	 *  Parses the actors data file.
	 *
	 * @param  args  The command line arguments
	 */
	public static void main( String[] args ) {
		String query = "";
		String line = "";
		BufferedReader buffer;
		StringTokenizer tok;
		String actorName;
		String movieTitle;
		String actorID;

		if ( !Query.connectToDB() ) {
			System.exit( 0 );
		}

		try {
			// read in file
			buffer = new BufferedReader( new FileReader( filename ) );
			line = buffer.readLine();
			while ( line != null ) {
				// tokenize each line - fields are tab-delimited
				tok = new StringTokenizer( line, "\t" );
				actorName = tok.nextToken();
				movieTitle = tok.nextToken();

				actorName = Query.cleanActorName( actorName );
				System.out.println( actorName );

				// check if actor already in database
				query = "select id from actor where name=\"" + actorName + "\"";
				ResultSet actorResult = Query.executeQuery( query );
				if ( Query.getNumResults( actorResult ) > 0 ) {
					actorResult.next();
					actorID = actorResult.getString( "id" );
				}
				// if not already in database, add the actor
				else {
					query = "insert into actor (name) values ('" + actorName + "')";
					Query.executeUpdate( query );
					query = "select id from actor where name='" + actorName + "'";
					actorResult = Query.executeQuery( query );

					// just in case - this shouldn't happen, but avoids crazy errors
					if ( Query.getNumResults( actorResult ) <= 0 ) {
						while ( line.trim().length() != 0 ) {
							line = buffer.readLine();
						}
						continue;
					}
					actorResult.first();
					actorID = actorResult.getString( "id" );
				}
				actorResult.close();

				// loop through all movies the actor has been in
				while ( movieTitle.trim().length() != 0 ) {
					movieTitle = Query.cleanMovieTitle( movieTitle );
					if ( movieTitle.length() == 0 ) {
						movieTitle = buffer.readLine();
						continue;
					}

					// get movie id
					query = "select id from movie where title='" + movieTitle + "'";
					ResultSet movieResult = Query.executeQuery( query );
					if ( Query.getNumResults( movieResult ) > 0 ) {
						movieResult.next();
						String movieID = movieResult.getString( "id" );
						query = "insert into movie_actor (actor_id,movie_id) values ('" + actorID + "','" + movieID + "')";
						Query.executeUpdate( query );
						System.out.println( "\t" + movieTitle );
					}
					else {
						System.out.println( "\t*** Movie '" + movieTitle + "' not found in database." );
					}
					movieResult.close();
					movieTitle = buffer.readLine();
				}
				line = buffer.readLine();
			}
		}
		catch ( SQLException e ) {
			System.err.println( "Error executing SQL statement while parsing IMDB actors..." );
			e.printStackTrace();
			System.exit( 0 );
		}
		catch ( FileNotFoundException e ) {
			System.err.println( "Could not find IMDB actor/ data file: " + filename );
			e.printStackTrace();
			System.exit( 0 );
		}
		catch ( IOException e ) {
			System.err.println( "Error reading data file while parsing IMDB actors..." );
			e.printStackTrace();
			System.exit( 0 );
		}
	}
}

