import java.io.*;
import java.sql.*;
import java.util.*;
import java.util.regex.*;

/**
 *  Parses the IMDB actress data file and loads it into the database.
 *
 * @author     Brandon Douthit-Wood
 * @created    March 31, 2004
 */
public class ParseIMDBActress {

	final static String filename = "data/actresses.list";

	/**
	 *  Parses the actress data file.
	 *
	 * @param  args  The command line arguments
	 */
	public static void main( String[] args ) {
		String query = "";
		String line = "";
		BufferedReader buffer;
		StringTokenizer tok;
		String actressName;
		String movieTitle;
		String actressID;

		if ( !Query.connectToDB() ) {
			System.exit( 0 );
		}

		try {
			// read through data file
			buffer = new BufferedReader( new FileReader( filename ) );
			line = buffer.readLine();
			while ( line != null ) {
				// tokenize each line - fields are tab-delimited
				tok = new StringTokenizer( line, "\t" );
				if ( !tok.hasMoreTokens() ) {
					line = buffer.readLine();
					continue;
				}
				actressName = tok.nextToken();
				// just some crazy error checking - this should not happen
				if ( !tok.hasMoreTokens() ) {
					line = buffer.readLine();
					continue;
				}

				movieTitle = tok.nextToken();

				actressName = Query.cleanActorName( actressName );
				System.out.println( actressName );

				// check if actress already in database
				query = "select id from actor where name=\"" + actressName + "\"";
				ResultSet actressResult = Query.executeQuery( query );
				if ( Query.getNumResults( actressResult ) > 0 ) {
					actressResult.next();
					actressID = actressResult.getString( "id" );
				}
				// if not already in database, add it
				else {
					query = "insert into actor (name) values ('" + actressName + "')";
					Query.executeUpdate( query );
					query = "select id from actor where name='" + actressName + "'";
					actressResult = Query.executeQuery( query );

					// just some more crazy error checking - just in case!!!
					if ( Query.getNumResults( actressResult ) <= 0 ) {
						while ( line.trim().length() != 0 ) {
							line = buffer.readLine();
						}
						continue;
					}
					actressResult.first();
					actressID = actressResult.getString( "id" );
				}
				actressResult.close();

				// get all movies the actress has been in
				while ( movieTitle.trim().length() != 0 ) {
					movieTitle = Query.cleanMovieTitle( movieTitle );
					if ( movieTitle.length() == 0 ) {
						movieTitle = buffer.readLine();
						continue;
					}

					// get movie id
					query = "select id from movie where title='" + movieTitle + "'";
					ResultSet movieResult = Query.executeQuery( query );
					if ( Query.getNumResults( movieResult ) > 0 ) {
						movieResult.next();
						String movieID = movieResult.getString( "id" );

						query = "insert into movie_actor (actor_id,movie_id) values ('" + actressID + "','" + movieID + "')";
						Query.executeUpdate( query );
						System.out.println( "\t" + movieTitle );
					}
					else {
						System.out.println( "\t*** Movie '" + movieTitle + "' not found in database." );
					}
					movieResult.close();
					movieTitle = buffer.readLine();
				}
				line = buffer.readLine();
			}
		}
		catch ( SQLException e ) {
			System.err.println( "Error executing SQL statement while parsing IMDB actresses..." );
			e.printStackTrace();
			System.exit( 0 );
		}
		catch ( FileNotFoundException e ) {
			System.err.println( "Could not find IMDB actress data file: " + filename );
			e.printStackTrace();
			System.exit( 0 );
		}
		catch ( IOException e ) {
			System.err.println( "Error reading data file while parsing IMDB actresses..." );
			e.printStackTrace();
			System.exit( 0 );
		}
	}
}

