import java.io.*;
import java.sql.*;
import java.util.*;

/**
 *  Parses the IMDB genre data file and loads it into the database.
 *
 * @author     Brandon Douthit-Wood
 * @created    March 31, 2004
 */
public class ParseIMDBGenre {

	final static String filename = "data/genres.list";

	/**
	 *  Parses the genre data file.
	 *
	 * @param  args  The command line arguments
	 */
	public static void main( String[] args ) {
		String query = "";
		String line = "";
		String movieTitle;
		String genre;
		BufferedReader buffer;
		StringTokenizer tok;

		if ( !Query.connectToDB() ) {
			System.exit( 0 );
		}

		try {
			// read through data file
			buffer = new BufferedReader( new FileReader( filename ) );
			line = buffer.readLine();
			while ( line != null ) {
				// tokenize each line - fields are tab-delimited
				tok = new StringTokenizer( line, "\t" );
				movieTitle = tok.nextToken();
				genre = tok.nextToken();

				movieTitle = Query.cleanMovieTitle( movieTitle );
				// just in case - this should not happen
				if ( movieTitle.trim().length() == 0 ) {
					line = buffer.readLine();
					continue;
				}
				System.out.println( movieTitle + " -> " + genre );

				// check if movie in database
				query = "select id from movie where title = '" + movieTitle + "'";
				ResultSet titleResult = Query.executeQuery( query );
				if ( Query.getNumResults( titleResult ) > 0 ) {
					titleResult.first();
					String movieID = titleResult.getString( "id" );
					String genreID;

					// check if genre already exists
					query = "select id from genre where genre='" + genre + "'";
					ResultSet genreResult = Query.executeQuery( query );
					// if genre not in database, add it
					if ( Query.getNumResults( genreResult ) <= 0 ) {
						query = "insert into genre (genre) values ('" + genre + "')";
						Query.executeUpdate( query );
						query = "select id from genre where genre='" + genre + "'";
						genreResult = Query.executeQuery( query );

						// a little more error checking!!!
						if ( Query.getNumResults( genreResult ) <= 0 ) {
							line = buffer.readLine();
							continue;
						}
						genreResult.first();
						genreID = genreResult.getString( "id" );
					}
					else {
						genreResult.first();
						genreID = genreResult.getString( "id" );
					}
					genreResult.close();

					// create new movie_genre entry
					query = "insert into movie_genre (movie_id, genre_id)";
					query += " values ('" + movieID + "','" + genreID + "')";
					Query.executeUpdate( query );
				}
				else {
					System.out.println( "\t*** Movie '" + movieTitle + "' not found in database" );
				}
				titleResult.close();
				line = buffer.readLine();
			}
		}
		catch ( SQLException e ) {
			System.err.println( "Error executing SQL statement while parsing IMDB directors..." );
			e.printStackTrace();
			System.exit( 0 );
		}
		catch ( FileNotFoundException e ) {
			System.err.println( "Could not find IMDB genre data file: " + filename );
			e.printStackTrace();
			System.exit( 0 );
		}
		catch ( IOException e ) {
			System.err.println( "Error reading data file while parsing IMDB directors..." );
			e.printStackTrace();
			System.exit( 0 );
		}
	}
}

