import java.sql.*;
import java.util.*;

/**
 *  Predicts movie ratings based on the group user has been clustered into.
 *  The nearest neighboords are then calculated from this group to make the
 *  actual predictions.
 *
 * @author     Brandon Douthit-Wood
 * @created    March 31, 2004
 */
public class PredictFromClusterGroup {

	/**
	 *  Predicts movie ratings from clustered group of users.
	 *
	 * @param  args  The command line arguments
	 */
	public static void main( String[] args ) {
		int actualRating;
		int predictedRating;
		String query = "";
		String ratingID;
		String userID;
		String movieID;
		String clusterID;
		String words = "";
		Hashtable wordHash = new Hashtable();
		User user;
		Cluster cluster;
		Vector userList;
		Vector clusterList;
		Vector neighboors;

		if ( !Query.connectToDB() ) {
			System.exit( 0 );
		}

		//need to clear out any old ratings
		System.out.print( "Clearing old ratings..." );
		query = "update rating set rating2=0;";
		Query.executeUpdate( query );
		System.out.println( "done" );

		System.out.println( "Clearing temporary flags..." );
		query = "update rating set training='' where training='t'";
		Query.executeUpdate( query );

		// get all clusters
		System.out.println( "Getting clusters..." );
		query = "select distinct cluster_id from user where cluster_id >= 0";
		ResultSet clusterResult = Query.executeQuery( query );

		try {
			while ( clusterResult.next() ) {
				clusterID = clusterResult.getString( "cluster_id" );

				// get list of users in this cluster
				System.out.println( "Getting users in cluster " + clusterID + "..." );
				userList = Cluster.getUsersFromCluster( clusterID );
				System.out.println( userList.size() + " users found in cluster " + clusterID );
				if ( userList.size() <= 1 ) {
					continue;
				}

				// loop through users
				for ( int i = 0; i < userList.size(); i++ ) {
					user = (User) userList.elementAt( i );

					System.out.println( "\nUser: " + user.id );

					// loop through all user's ratings
					query = "select * from rating where user_id=" + user.id + " and training=''";
					ResultSet ratingResult = Query.executeQuery( query );
					if ( Query.getNumResults( ratingResult ) <= 0 ) {
						continue;
					}

					while ( ratingResult.next() ) {
						ratingID = ratingResult.getString( "id" );
						movieID = ratingResult.getString( "movie_id" );
						actualRating = ( new Integer( ratingResult.getString( "rating" ) ) ).intValue();

						// predict the user's rating from group of closest neighboors
						System.out.println( "Predicting rating for movie " + movieID + "..." );
						predictedRating = user.getNeighboorsRating( userList, movieID, user.id );

						// set predicted rating value
						query = "update rating set rating2=" + predictedRating + " where id=" + ratingID;
						Query.executeUpdate( query );

						// set temporary flag so we know this one is done
						query = "update rating set training='t' where id=" + ratingID;
						Query.executeUpdate( query );

						System.out.println( actualRating + " -> " + predictedRating );
					}
				}

			}
		}
		catch ( SQLException e ) {
			System.err.println( "Error predicting ratings from cluster groups..." );
			e.printStackTrace();
			System.exit( 0 );
		}
	}
}

