import java.sql.*;
import java.util.*;

/**
 *  Predicts movie ratings based on a randomly-selected group of users.  The nearest neighboords are
 *  then calculated from this random group to make the actual predictions.
 *
 * @author     Brandon Douthit-Wood
 * @created    March 31, 2004
 */
public class PredictFromRandomGroup {

	/**
	 *  Predicts movie ratings from a random group of users.
	 *
	 * @param  args  The command line arguments
	 */
	public static void main( String[] args ) {
		int actualRating;
		int predictedRating;
		String query = "";
		String ratingID;
		String userID;
		String movieID;
		String words = "";
		Hashtable wordHash = new Hashtable();
		User user;
		Vector users;

		if ( !Query.connectToDB() ) {
			System.exit( 0 );
		}

		while ( true ) {
			// continually loop through ratings from test set until all have been processed
			query = "select * from rating where training='' limit 1000";
			ResultSet ratingResult = Query.executeQuery( query );
			if ( Query.getNumResults( ratingResult ) <= 0 ) {
				break;
			}

			try {
				while ( ratingResult.next() ) {
					ratingID = ratingResult.getString( "id" );
					userID = ratingResult.getString( "user_id" );
					movieID = ratingResult.getString( "movie_id" );
					words = ratingResult.getString( "words" );
					actualRating = ( new Integer( ratingResult.getString( "rating" ) ) ).intValue();

					System.out.println( "\nUser: " + userID );
					user = new User( userID, words );

					// generate group of random users
					System.out.println( "Generating random group..." );
					users = user.getRandomGroup( movieID );

					// find the user's closest neighboors from random group
					System.out.println( "Finding closest neighboors..." );
					users = user.findClosestNeighboors( users );

					// predict the user's rating from group of closest neighboors
					System.out.println( "Predicting rating for movie " + movieID + "..." );
					predictedRating = user.getNeighboorsRating( users, movieID, userID );

					// set predicted rating value
					query = "update rating set rating2=" + predictedRating + " where id=" + ratingID;
					Query.executeUpdate( query );

					// set temporary flag so we know this one is done
					query = "update rating set training='t' where id=" + ratingID;
					Query.executeUpdate( query );

					System.out.println( actualRating + " -> " + predictedRating );
				}
				ratingResult.close();
			}
			catch (SQLException e) {
				System.err.println("Error predicting ratings from random group...");
				e.printStackTrace();
				System.exit(0);
			}
		}

	}
}

