<?php
/*
Copyright (C) 2004  Brian J. Mullen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
/*
This script utilizes the Spreadsheet::WriteExcel library which
should be in the write_excel folder in your Collections Keeper directory.
See the files in write_excel for copyright and license information
*/
include("functions.inc.php");
include("dbConnect.inc.php");
require_once('./write_excel/Worksheet.php');
require_once('./write_excel/Workbook.php');

//handle if they put in manual sql
if($_POST['SQLtext'] != "") {
	if(get_magic_quotes_gpc()) $sql = stripslashes($_POST['SQLtext']);
	else $sql = $_POST['SQLtext'];
}
else {
	//grab the info from the post we need
	$table_name = $_POST['table_name'];
	if($_POST['table_name_sub'] != "") $table_name = $_POST['table_name_sub'];
	$user_info_id = $_POST['user_info_id'];
	$order_by = $_POST['order_by'];
	$start = $_POST['start'];
	$offset = $_POST['offset'];
	//select
	$sql = "SELECT * FROM $table_name WHERE ";
	//where
	if ($user_info_id && $_POST['table_name_sub'] == "") $sql .= "user_info_id=$user_info_id";
	else $sql .= "1";
	//order by
	if($order_by != "") $sql .= $order_by;
	//limit
	if($start != "" && $offset != "") {
		$sql .= " LIMIT $start,$offset";
		$page = ((int)($start/$offset) + 1);
	}
	else $page = 1;
}

//create the file name
if($table_name != "") $filename = $table_name . "_page" . $page . ".xls";
else $filename = "collections_keeper.xls";

//send headers to download the file
header("Content-type: application/force-download");
//header("Content-type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=$filename" );
//header("Content-Disposition: inline; filename=$filename" );
//header("Expires: 0");
header("Cache-Control: must-revalidate, post-check=0,pre-check=0");
header("Pragma: public");

$result = mysql_query($sql);

//this array is for storing the width of the columns so we
//can set them at the end
$width = array();

$workbook = new Workbook("-");
$worksheet1 =& $workbook->add_worksheet();
//$worksheet1->write(0,0,"testing excel package");
$format =& $workbook->add_format();
$format->set_bold();

//get foreign key info if it is not user created sql
if($table_name != "") {
	$fk_result = mysql_query("SHOW INDEX FROM $table_name");
	$fk_info = array();
	while($index_info = mysql_fetch_array($fk_result)) {
		if($index_info['Key_name'] == "PRIMARY") $pri_key = $index_info['Column_name'];
		//skip user_info_if and file_id since those require some special handling
		elseif($index_info['Key_name'] != "user_info" && $index_info['Key_name'] != "file") {
			$fk_info[$index_info['Column_name']] = $index_info['Key_name'];
		}
	}
}
//be careful here.  Write functions in the worksheet package are (y, x) and not (x, y)	
//set up column headers
//if this is a user created sql then we have it easy
if($_POST['SQLtext'] != "") {
	for($i = 0; $i < mysql_num_fields($result); $i++) {
		$field_name = mysql_field_name($result, $i);
		$worksheet1->write_string(0,$i,$field_name,$format);
		//save width
		$width[$i] = strlen($field_name);
	}
}
//else handle for collections keeper generated sql
else {
	//since we want to skip the primary key we need an extra variable loc to track
	//where we are actually writing to
	for($i = 0, $loc = 0; $i < mysql_num_fields($result); $i++, $loc++) {
		//if it is a foreign key
		$field_name = mysql_field_name($result, $i);
		//skip primary key
		if($field_name == $pri_key) {
			$loc--;
			continue;
		}
		elseif(array_key_exists($field_name, $fk_info)) {
			$worksheet1->write_string(0, $loc, $fk_info[$field_name], $format);
			$width[$loc] = strlen($field_name) + 3;
		}
		elseif($field_name == "file_id") {
			$worksheet1->write_string(0, $loc, "file name", $format);
			$width[$loc] = strlen("file name") + 3;
		}
		elseif($field_name == "user_info_id") {
			$worksheet1->write_string(0, $loc, "user", $format);
			$width[$field_loc] = strlen("user") + 3;
		}
		else{
			$worksheet1->write_string(0, $loc, $field_name, $format);
			$width[$loc] = strlen($field_name) + 3;
		}
	}
}
//and put in the data
//watch $i as row 0 has the header info so we always need to add 1 to the row location
for($i = 0; $row_results = mysql_fetch_array($result); $i++) {
	//$j is our location in $row_results, $loc is our location in the spreadsheet
	for($j = 0, $loc = 0; $j < mysql_num_fields($result); $j++, $loc++) {
		$field_name = mysql_field_name($result, $j);
		$field_data = $row_results[$j];
		if($field_name == $pri_key) {
			//since we're going to skip the primary key decrement loc
			$loc--;
			continue;
		}
		//check to make sure we are looking for a foreign key
		//then if we have a foreign key get the info from that table
		elseif($_POST['SQLtext'] == "" && array_key_exists($field_name, $fk_info)) {
			$fk_field = find_first_nonkey($fk_info[$field_name]);
			$fk_result = @mysql_query("SELECT $fk_field FROM " . $fk_info[$field_name] . " WHERE $field_name=$field_data");
			$fk_data = @mysql_result($fk_result, 0);
			//if we don't get valid data then just use the data in field data and not the fk data
			if(!$fk_field) $fk_data = $field_data;
			$worksheet1->write(($i + 1), $loc, $fk_data);
			//check on the width
			if($width[$loc] < (strlen($fk_data) + 3)) {
				$width[$loc] = (strlen($fk_data) + 3);
			}
		}
		elseif($field_name == "file_id") {
			$fk_result = @mysql_query("SELECT filename FROM file WHERE file_id=$field_data");
			$fk_data = @mysql_result($fk_result, 0);
			$worksheet1->write(($i + 1), $loc, $fk_data);
			if($width[$loc] < (strlen($fk_data) + 3)) {
				$width[$loc] = (strlen($fk_data) + 3);
			}
		}
		elseif($field_name == "user_info_id"){
			$fk_result = @mysql_query("SELECT fname, lname FROM user_info WHERE user_info_id=$field_data");
			$fk_data = @mysql_fetch_array($fk_result);
			$fk_data = $fk_data[0] . " " . $fk_data[1];
			$worksheet1->write(($i + 1), $loc, $fk_data);
			if($width[$loc] < (strlen($fk_data) + 3)) {
				$width[$loc] = (strlen($fk_data) + 3);
			}
		}
		else {
			$worksheet1->write(($i + 1), $loc, $field_data);
			if($width[$loc] < (strlen($field_data) + 3)) {
				$width[$loc] = (strlen($field_data) + 3);
			}
		}
	}
}
//we have all the column widths now so we need to set them
for($i = 0; $i < count($width); $i++) {
	$worksheet1->set_column($i, $i, $width[$i]);
}
		

$workbook->close();

