<?php
/*
Copyright (C) 2004  Brian J. Mullen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
/*
function 	verify_login
purpose:	to verify that a user of a paticular type has logged in and return their privileges
input:		none
return:		-3 on expiration, -2 on time out, -1 on inactive, 0 on none, 1 on privileged, 2 on admin
Notes:		if a valid login updates last visited time in the user_info table
*/
function verify_login() {
  include("collParams.inc.php");
  include("dbConnect.inc.php");
  if($use_sessions) {
    session_start();
  }
	$ip = $_ENV['REMOTE_ADDR'];

	$query_string = "SELECT user_settings.user_info_id, admin, privileged, active, ip, last_access, joindate ";
	$query_string .="FROM user_settings,session_settings,user_info ";
	if($use_sessions && isset($_SESSION['user_info_id'])) {
    	$query_string .= "WHERE user_settings.user_info_id = " . $_SESSION['user_info_id'] . " ";
    	$query_string .= "AND session_settings.user_info_id = " . $_SESSION['user_info_id'] . " ";
    	$query_string .= "AND user_info.user_info_id = " . $_SESSION['user_info_id'] . " ";
  	}
  	elseif($use_sessions && !isset($_SESSION['user_info_id'])) return 0;
  	else $query_string .="WHERE ip='$ip' and user_settings.user_info_id=session_settings.user_info_id and user_settings.user_info_id=user_info.user_info_id";

	$result = mysql_query($query_string);
	if($result) $user_info = mysql_fetch_array($result);
	else return 0;

	$type_login = 0;

	//setup exit conditions
	//verify correct type
	//handle the various non-privileged user possiblities
	//if they're not privileged but expiration isn't being enforced then treat them as privileged
	if($user_info['privileged'] == 0 && $enforce_exp == 0){
	  $user_info['privileged'] = 1;
  }
  //else if it is being enforced
  elseif ($user_info['privileged'] == 0 && $enforce_exp == 1) {
    //number of secs in a day
    $num_secs = 24 * 60 * 60;
    $days_exp_used = (time() - $user_info['joindate'])/$num_secs;
    if($default_exp > $days_exp_used) $user_info['privileged'] = 1;
    else return -3;//echo("Your account has expired.  You are day $days_exp_used into a $default_exp day registration");
  }
  	$timeout = 1;
	if($user_info['privileged'] == 1) {
		$type_login = 1;
		$timeout = $user_timeout;
	}
	if($user_info['admin'] == 1) {
		$type_login = 2;
		$timeout = $admin_timeout;
	}
	if($type_login == 1 || $type_login == 2) {
		//inactive account
		if($user_info['active'] == 0) {
			return -1;
		}
		//timeout
		if($timeout == 0) $timeout = time();
		$current_secs = time() - $user_info['last_access'];
		if($current_secs > $timeout) {
		  return -2;
		}
		//if they have access we need to update their info
		if($use_sessions) $user_info_id = $_SESSION['user_info_id'];
		else $user_info_id = $user_info['user_info_id'];
		//update last_access
		$last_access = time();
		$query_string = "UPDATE session_settings SET last_access=$last_access ";
		$query_string .= "WHERE user_info_id=$user_info_id";
		if(!mysql_query($query_string)) {
			echo("<b>User update for login unsuccessfull.</b><br>MySQL Error: ".mysql_errno()." -> ".mysql_error());
			echo("<br>");
			exit();
		}
	}
	return $type_login;
}

/*
function 	user_login
purpose:	to find the user_info_id in the database of the user who is logged in
input:		none
return:		0 on none, else user_info_id (userid)
Notes:		if using sessions the user_info_id is grabbed from session variables
			else it is grabbed from the database based on ip
*/
function user_login() {
  include("collParams.inc.php");
  include("dbConnect.inc.php");
  if(isset($use_sessions) && $use_sessions == true) {
    session_start();
    return $_SESSION['user_info_id'];
  }

	$ip = $_ENV['REMOTE_ADDR'];

	$query_string = "SELECT session_settings.user_info_id ";
	$query_string .="FROM session_settings ";
	$query_string .="WHERE ip='$ip'";

	$result = mysql_query($query_string);


	if (@mysql_num_rows($result) < 1) return 0;
	else {
		$user_info = mysql_fetch_array($result);
		return $user_info['user_info_id'];
	}
}

/*
function:	gd_version
purpose: 	to determine what version of gd the user has installed
input:		none
return:		gd version if gd is found, else 0
Note:		this function was not written by me, Brian Mullen and therefore does not fall
			under the GPL license and copyright for Collections Keeper.  It was
			found on the www.php.net website and is assumed to be public domain
			as no license information was given.  It was posted by Justin Greer on
			18-Nov-2003.
*/
function gd_version() {
   static $gd_version_number = null;
   if ($gd_version_number === null) {
       // Use output buffering to get results from phpinfo()
       // without disturbing the page we're in.  Output
       // buffering is "stackable" so we don't even have to
       // worry about previous or encompassing buffering.
       ob_start();
       phpinfo(8);
       $module_info = ob_get_contents();
       ob_end_clean();
       if (preg_match("/\bgd\s+version\b[^\d\n\r]+?([\d\.]+)/i",
               $module_info,$matches)) {
           $gd_version_number = $matches[1];
       } else {
           $gd_version_number = 0;
       }
   }
   return $gd_version_number;
}

/*
function:	get_thumb
purpose:	returns the image thumbnail from passed in source
input:		source file, extension
return:		thumbnail data
Notes:		Assumes that the file is of type png or jpeg
			Returns data with slashes added so it can be put into the database
*/
function get_thumb($src, $image_ext) {
	include("collParams.inc.php");
	$src_size = getimagesize($src);

	//width/height ratio
	$src_ratio  = $src_size[0]/$src_size[1];
	if (1 > $src_ratio) {
		$dest_size[1] = $max_thumb_size;
		$dest_size[0] = $max_thumb_size*$src_ratio;
	}
	else {
		$dest_size[0] = $max_thumb_size;
		$dest_size[1] = $max_thumb_size/$src_ratio;
	}
	if(gd_version() >= 2) $dest_image = imageCreateTrueColor($dest_size[0],$dest_size[1]);
	else $dest_image = imageCreate($dest_size[0],$dest_size[1]);
	if($image_ext == "png") $src_image = imageCreateFromPng($src);
	else $src_image = imageCreateFromJpeg($src);

	if(gd_version() >= 2) imageCopyResampled($dest_image, $src_image, 0, 0, 0, 0,$dest_size[0],$dest_size[1],$src_size[0],$src_size[1]);
	else imageCopyResized($dest_image, $src_image, 0, 0, 0, 0,$dest_size[0],$dest_size[1],$src_size[0],$src_size[1]);
	//the imagepng and the imagejpeg will try to just show the image data, which we don't want
	//so we just start a buffer, grab the data and then end and dump the buffer
	ob_start();
	if($image_ext == "png") imagepng($dest_image);
	else imagejpeg($dest_image);
	//make sure we add any slashes so the data gets put into the database correctly
	//don't have to handle get_magic_quotes_runtime because the data isn't a file
	//well, it is a file, just not one we need to worry about for magic_quotes
	$th_data = addslashes(ob_get_contents());
	ob_end_clean();
	return $th_data;
}
/*
* function: find_first_nonkey
* purpose:  finds the first nonkey field in the passed in table
* input:    table name
* return:   returns the name of the first nonkey field found in the table passed in
*           returns primary key if no nonkey fields are found
* NOTES:    Assumes a valid mysql connection
            Assumes a valid table in the database
            Prevents any errors that may result from the above assumptions being invalid
*/
function find_first_nonkey($table_name) {
  $result = mysql_query("DESCRIBE $table_name");
  while($table_info = @mysql_fetch_array($result)) {
    if($table_info['Key'] == "") return $table_info['Field'];
    elseif($table_info['Key'] == "PRI") $pri_key = $table_info['Field'];
  }
  return $pri_key;
}
/*
function 	table_info
purpose:  	return all the field names and data for a table
input:		table name, field name array and field data array
			optional: if a primary key value is passed in only the records with that primary key
			value are returned
return:		total number of fields in table (i.e. if you have a 3X4 table, will return 12.
			field names are returned in the $field_name passed in
			field data are returned in the $field_data passed in
*/
function table_info ($table_name, &$field_name, &$field_data, $pri_key=false) {
	include("dbConnect.inc.php");
	//find out if it is a primary table or sub table
	$table = get_tables(1);

	//handle any order by/sort stuff
	//first we need to know the type of table
	for($i = 0; $i < count($table); $i++) {
		if($table[$i]['name'] == $table_name) {
			$table_type = "pri_tables";
			break;
		}
	}
	if(!isset($table_type)) $table_type = "sub_tables";
	//now that we now the table type grab the "order_by" for the table
	$order_by_info = mysql_fetch_array(mysql_query("SELECT * FROM $table_type WHERE name='$table_name'"));
	$order_by = $order_by_info['order_by'];

	$pri_key_name = primary_key($table_name);
	if($pri_key) $result = mysql_query ("SELECT * FROM $table_name WHERE $pri_key_name=$pri_key $order_by");
	else $result = mysql_query ("SELECT * FROM $table_name $order_by");
	if (!$result) {
		  echo("<P>Error retrieving collections from database!<BR>".
		       "Error: " . mysql_error());
		  exit();
	}

	$num_fields = mysql_num_fields($result);
	for ($i = 0; $i < $num_fields; $i++)
		$field_name[$i] = mysql_field_name($result, $i);

	//because we dont want just the number of rows or just the number of columns
	//I used a $k variable to cycle through the double for loop to track the total
	//number of fields
	$k = 0;
	for ($i = 0; $collection = mysql_fetch_array($result); $i++) {
		for ($j = 0; $j < count ($field_name); $j++) {
			$field_data[$k] = $collection["$field_name[$j]"];
			$k++;
		}
	}

	return $k; //where $k is the (total number of fields = rows * columns)
}



/*
function primary_key
purpose:return the primary key field for a table
input:	table name
return:	primary key name
note:	if no primary key is found returns false;
*/
function primary_key ($table_name) {
	include("dbConnect.inc.php");
	if(!$table_name) return false;
	$result = mysql_query("SHOW FIELDS FROM $table_name");
	while($row = mysql_fetch_array($result)) {
		if($row['Key'] == "PRI") return $row['Field'];
	}
	return false;
}

/*
function primary_key_location
purpose  find where a primary key is located in a table
input    table name
return   location where primary key is
notes	 functions similiar to primary key with a different return
*/
function primary_key_location ($table_name) {
	include("dbConnect.inc.php");
	$result = mysql_query("SHOW FIELDS FROM $table_name");
	for($i = 0; $row = mysql_fetch_array($result); $i++) {
		if($row['Key'] == "PRI") return $i;
	}
	return $i;
}
//function to check valid email
function is_email_valid($email) {
  if(eregi("^[a-z0-9\._-]+@+[a-z0-9\._-]+\.+[a-z]{2,3}$", $email)) return TRUE;
  else return FALSE;
}

/*
function 	get_tables
purpose		create an array containing the information for primary or sub tables in the database
input		1 for primary tables, 2 for sub tables
return		an array in the format $table = array( array(name => "table_name", key => "table_primary_key"))
			returns an empty array if no tables are found
Notes		none
*/
function get_tables($type = 1) {
	include("dbConnect.inc.php");
	$table = array();
	if($type == 1) $table_name = "pri_tables";
	else $table_name = "sub_tables";
	$result = mysql_query("SELECT * FROM $table_name");
	while($table_info = mysql_fetch_array($result)) {
		$table[] = array(name => "{$table_info['name']}", key => "{$table_info['key_name']}", order_by => "{$table_info['order_by']}");
	}
	return $table;
}

/*
function debug_print
purpose		I would use the same statements so much while debugging I made this to make it easy
input		nothing for $_POST, 1 for $_GET, also takes an optional string for an optional name
return 		nothing
Notes		if there is a string it will overide any value for $what to print
*/
function debug_print($what = 0, $string = "", $name="") {
	if($string != "") {
		if($name == "") echo("<BR>String:<BR>");
		else echo("<BR>$name<BR>");
		echo($string);
		return;
	}
	switch($what) {
		case 0:
			echo("<BR>Post:<BR>");
			print_r($_POST);
			echo("<BR>");
			break;
		case 1:
			echo("<BR>Get:<BR>");
			print_r($_GET);
			echo("<BR>");
			break;
	}
}
function debug_arr($array, $name="") {
	echo("<BR>$name<BR>");
	print_r($array);
	echo("<BR>");
}