<?php
/*
Copyright (C) 2004  Brian J. Mullen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
include ("header.inc.php");

if ($type_login == 1) echo ("You are currently logged in as a privileged user<BR>");
elseif ($type_login == 2) echo ("You are currently logged in as an Admin<BR>");
elseif ($type_login == -1) echo ("Your acount has been flagged as inactive<BR>");
elseif ($type_login == -2) echo ("Your login has timed out");
elseif ($type_login == -3) echo ("Your account has expired");
else echo("You are currently not logged in");

?>

<p>Table of Contents:
<ol>
<li><a href="<?echo($_SERVER['PHP_SELF'] . "#what"); ?>">What is Collections Keeper?</a>
<li><a href="<?echo($_SERVER['PHP_SELF'] . "#data"); ?>">Data types and Collections Keeper</a>
<li><a href="<?echo($_SERVER['PHP_SELF'] . "#terms"); ?>">Collections Keeper specific terminology</a>
<li><a href="<?echo($_SERVER['PHP_SELF'] . "#user"); ?>">User Management</a>
<li><a href="<?echo($_SERVER['PHP_SELF'] . "#files"); ?>">Files and Images in Collections Keeper</a>
<li><a href="<?echo($_SERVER['PHP_SELF'] . "#bookmarks"); ?>">SQL bookmarks<a>
<li><a href="<?echo($_SERVER['PHP_SELF'] . "#excel"); ?>">Grabbing spreadsheets</a>
<li><a href="<?echo($_SERVER['PHP_SELF'] . "#install"); ?>">Installing Collections Keeper</a>
<li><a href="<?echo($_SERVER['PHP_SELF'] . "#sessions"); ?>">Security and Collections Keeper Sessions</a>
<li><a href="<?echo($_SERVER['PHP_SELF'] . "#security"); ?>">Security and Files in Collections Keeper</a>
<li><a href="<?echo($_SERVER['PHP_SELF'] . "#integrity"); ?>">Referential Integrity and Collections Keeper</a>
<li><a href="<?echo($_SERVER['PHP_SELF'] . "#tut1"); ?>">Tutorial 1: Setting up a simple collection, the address book</a>
<li><a href="<?echo($_SERVER['PHP_SELF'] . "#tut2"); ?>">Tutorial 2: The daily planner</a>
<li><a href="<?echo($_SERVER['PHP_SELF'] . "#faq"); ?>">FAQ</a>
<li><a href="<?echo($_SERVER['PHP_SELF'] . "#future"); ?>">Future possibilities</a>
</ol>

<a name="what">
<p><b>What is Collections Keeper?</b>

<p>Our lives are made up of collections.  Whether it is the more mundane, such as a phone book or daily planner, or the more classically thought of collections, like comic books and sports cards, collections of data are everywhere in our lives.

<p>Collections Keeper is a way to keep all your collections in order on-line using PHP and MySQL.  If you want only you to see your collections you can do that.  If you want others to see your collections or add their own you can do that.  Add collections, delete collections, modify collections, just about anything you can do with a collection you can do with Collections Keeper.

<p>Now there are a few caveats.  Collections Keeper isnt intended as a full database management system for MySQL.  For that I would recommend phpMyAdmin.  Collections Keeper is focused more on managing data.  Of course to do that you have to be able to have full control over your tables and for the most part Collections Keeper allows you do that.

<p>Collections Keeper is targeted more at the users with little or no PHP and MySQL experience and essentially allows you to maintain multiple collections under a single database.

<a name="data">
<p><b>Data types and Collections Keeper</b>

<p>If you are one of the more experienced users of MySQL you will notice a distinctive lack in control of your data types.  To simplify control of the database Collections Keeper only uses six data types of a set length.  This makes displaying and handling data markedly easier.


<p>Collections Keeper type	MySQL type
<table border=1>
<tr>
	<td>Text</td><td>varchar(255)</td>
</tr>
<tr>
	<td>Memo</td><td>text</td>
</tr>
<tr>
	<td>Integer</td><td>int</td>
</tr>
<tr>
	<td>Decimal</td><td>float</td>
</tr>
<tr>
	<td>Date</td><td>date</td>
</tr>
<tr>
	<td>Year</td><td>year</td>
</tr>
</table>

<a name="terms">
<p><b>Collections Keeper specific terminology</b>

<p>Collections Keeper is focused on presenting data in a specific table.  If you want to see what is in your comics collection, have Collections Keeper show you.  If you want to see what is in your phone book, have Collections Keeper show you.  The problem with this idea is that as databases grow larger and larger focus within the database shifts from any single table within the database to many tables.  While Collections Keeper can handle this situation that is not the primary focus or intended database type for Collections Keeper.

<p>To make a distinction between a primary table, where the focus of the collection is, and other tables Collections Keeper uses the following terminology:
<br>Collection, Primary Table:  The focus of the collection.  An entry into this type of table has a specific owner.  As an example for comics this table would contain things like the name or number.
<br>Sub-collection, sub-table:  Any other table that corresponds to the collection.  An entry into this type of table generally does not have a specific owner.  For comics this would be things like the condition or publisher.
<br>Table:  An actual table, meaning that options that call for a table could be either a primary table or a sub-table.

<p>Because of the focus on a "Collection" when a table is initially created there is not an option to include primary tables as foreign keys, only sub-tables.  However, if this is needed it can be added in by simply modifying the table after creating it.

<p>There are two types of text fields that Collections Keeper uses.  When creating a new table or modifying an existing one you are presented with the field types Text (Any letters, single line) and Memo (Any letters, multiple lines).  The Text field type is limited to 255 characters.  The Memo field type has no limit on the numbers of characters.  When creating or editing an entry into a collection Text is presented on a single line and will be truncated if the line goes over 255 characters.  Memo is presented in a scrollable box allowing as many characters as is needed.

<a name="user">
<p><b>User Management</b>

<p>Collections Keeper has a full user management system.  There are three types of users in Collections Keeper, guest, privileged and admin.  If anonymous registration is enabled then by default when a new user is created they are considered privileged until their account expires.  Only an admin can make a user fully privileged.  You can set the expiration on new accounts or choose to ignore expiration, in which case all registered users who are actually guests will be privileged.

<p>Guest, Anonymous User:  Someone who has not logged in, whose account has expired or whose account is not active.
<br>Privileged:  Someone who has logged in and is not a guest.
<br>Admin:  Administrator.

<p>Collections Keeper provides a wide variety of options when it comes to user management.

<p>Guests:
<br>Admins can allow or disallow guests to view primary tables.
<br>Admins can allow or disallow anonymous registration.

<p>Privileged User:
<br>Admins can allow or disallow privileged users to edit/delete from sub-tables.
<br>Privileged users can create/edit/delete collection table entries under their own login only.
<br>Privileged users can view other users entries in a collection table.

<p>Admin:
<br>Full rights to modify, create, add, and edit everything.

<a name="files">
<p><b>Files and Images in Collections Keeper</b>

<p>Collections Keeper includes a special table called file used for uploading and storing files.  In its current incarnation Collections Keeper stores files uploaded in the file table.  If the GD library is enabled in PHP with "use gd" and "use file" options enabled in the Collections Keeper Settings when a jpeg or png is uploaded a thumbnail is created and it is the thumbnail that is shown when viewing data from a table that will contain a file.

<p><table border=1>
<tr>
	<td><img src="./images/xmenTh.jpg"></td><td><img src="./images/xmenTxt.jpg"></td>
</tr>
<tr>
	<td align=center>With GD enabled</td><td align=center>With GD disabled</td>
</tr>
</table>
<p>See the php website about enabling the GD library.

<p>Under the Collections Keeper settings you can enable and disable file uploads, set a maximum file size, enable and disable the GD library use for Collections Keeper and set a maximum thumbnail size.  If the GD library is not enabled for you in PHP you will not be allowed to enable it in Collections Keeper.

<a name="bookmarks">
<p><b>SQL bookmarks</b>

<p>Collections Keeper provides a means for more advanced users to get more out of Collections Keeper then the simple interface provided.  This is done through SQL bookmarks.  When choosing Manage/View for managing a collection admin users are presented with a text box for manually entering in SQL.  Collections Keeper will take that SQL and run it on the MySQL database.  If data is returned it is presented in a table format.  

<p>Assuming the SQL runs properly you will be presented with an option to bookmark the query.  This will take you to the Edit SQL page where you can name the query and set a permission level for it.  You may let all users run the bookmark, just admin and privileged users or just admin users.  

<p>Additionally under the SQL Bookmarks link in the navigation panel you may add bookmarks or edit the bookmarks you have saved.

<a name="excel">
<p><b>Grabbing spreadsheets</b>
<p>When a query is run, whether by Collections Keeper creating the query or via SQL, you will be presented with the option to grab that page or all pages as an excel spreadsheet.  Due to the cross platform nature of you cannot open the spreadsheet inline with your browser but are forced to download it.
<a name="install">
<p><b>Installing Collections Keeper</b>

<p>Collections Keeper assumes that warnings about notices have been turned off.

<p>Open the collParams.inc.php file with any text editor.  Under the "database info" section at the top enter the database name, location, user and password and save the file.

<p>Location will be "localhost" if MySQL is running locally where the files are run or will be a url if it is not localhost.  Contact your provider for more information on the location of the MySQL database.

<p>Open the create_database.php file with any text editor.  Near the top is where login is verified.  There will be a line that says:   exit();
<br>Put // in front of that to comment it out so PHP ignores it.

<p>Upload all contents of the Collections Keeper directory to where you want it to be.

<p>Navigate your browser to:
<br>http://your host/Collections Keeper directory/create_database.php

<p>This will setup Collections Keeper at the database specified under the collParams.inc.php.

<p>Navigate your browser to:
<br>http://your host/Collections Keeper directory/index.php

<p>Login the default admin user with the name admin and the password admin.

<p>Click on the "Set Collections Keeper Settings" link.

<p>Set any settings as you see fit and save the changes.

<p>At this point it is highly recommended you delete create_database.php as now that the database is set up you should not need it anymore.  If you opt to not do this you at least need to modify create_database.php and remove the // you put in front of exit() and re-upload the file.

<p>It is also recommended you set the permissions on collParams.inc.php to read only.  For windows users right click on the file and make the file read only.  For linux users set the file to 755 using chmod.

<p>You should also go to the "Manage Users" link and change the user name and password for the default admin user.  You can also delete the two default privileged users installed with collections keeper.

<p>That should be everything.

<a name="sessions">
<p><b>Security and Collections Keeper Sessions</b>

<p>Under the Collections Keeper settings you have the option to either use PHP sessions for tracking user login or to not use PHP sessions.  It is highly recommended that you do use PHP sessions.  It is, in general, more secure.  If it is enabled then the session information is used for user login.  If it is disabled then the ip of the user is used for user login.

<p>AOL, though other ISPs will occasionally do this too, tends to change the ip addresses of their users mid-browsing.  If sessions are disabled then Collections Keeper can become a bit of a hassle for AOL users as they will need to re-login each time their ip address changes.  If sessions are being used then this is irrelevant.

<p>Additionally, when using PHP sessions it allows multiple users from behind a proxy or a router.  When just using the ip each user behind the proxy or router generally will have the same ip address as the proxy or router.  If just the ip is used then all users will appear to Collections Keeper as the same user.  Conversely if PHP sessions are used then each user will be recognized by their session id allowing multiple users.

<p>Credit cards, social security numbers and other personal information you do not want viewed by the outside world should never be entered in or be a part of the Collections Keepers collections.  While Collections Keeper is secure within the bounds of a default install of PHP (utilizing nothing else) you are still liable for any information contained within the database.

<p>One of the key things to remember is that with Collections Keeper all information is sent unencrypted.  This means that someone snooping on your network could grab your admin name and password.

<a name="security">
<p><b>Security and Files in Collections Keeper</b>

<p>When setting up Collections Keeper you can add or subtract from the file extensions that are allowed in Collections Keeper for the file table.  It is highly recommended you never allow users to upload files with the following extensions: php, php3, php4, pl, asp or vbs.  These files could be malicious and there is a chance that they will run after being uploaded to the Collections Keeper database.  This list is not intended to all-inclusive.  It is your responsibility to know what uploaded scripts and any extensions they use can do to your server or your hosts server.

<p>It is also recommended you do not allow files with extensions common to Microsoft Office.  Two examples include doc and xls but there are more.  While these may pose no immediate threat to the server like the extensions mentioned above they may pose a threat to users who try and view the files.  This is because, for the most part, Microsoft Office files contain the ability to have macros embedded in them.  If a user were to download and view a document that had a macro embedded in it they open their system up.  This is something that should be done for the concern of your users.

<a name="integrity">
<p><b>Referential Integrity and Collections Keeper</b>

<p>Referential integrity is when a database has data that points to actual data.  For instance if you have a comic table and it has a column for condition that points to the sub-table condition and the sub-table condition exists and there is a valid entry for that condition then you have referential integrity.  Collections Keeper provides many options in an attempt to maintain referential integrity.  These options are on by default and presented throughout Collections Keeper as you make changes.

<p>At any point you can unselect the options that help maintain referential integrity throughout the database though it is not recommended as it will result in missing data within the tables.

<p>Collections Keeper attempts to maintain referential integrity in the following manner:

<p>View/Manage Users:
<br>When removing a user Collections Keeper will go through all tables that contain the removed user and remove all entries for that user.

<p>Modify a table: Rename Table
<br>When renaming a table Collections Keeper will go through all tables that contain the renamed table as a foreign key and update the key to the new name.

<p>Delete a table:
<br>When deleting a table Collections Keeper will go through all tables that contain the removed table and remove the column for that table.

<p>The primary issue with Collections Keeper and referential integrity is that Collections Keeper doesnt provide support for cascading deletes.  What are cascading deletes?  Say you have comics in the comic table that contain the condition "MINT" from the condition table.  If cascading deletes were supported then you would not be able to delete "MINT" while there are entries that point to it.  This is an issue you must be aware of especially when editing and deleting from a sub-table where there may be other entries that point to the sub-table data.

<p>If you are more familiar with MySQL then you know that as of MySQL ver. 4.0 it now supports referential integrity when using InnoDB tables.  So why not just utilize MySQLs referential integrity?  Collections Keeper attempts to generate all sql making it simpler for the user.  If the referential integrity inherent to MySQL were to be used the complexity of the sql that Collections Keeper would have to generate would be outside the scope of the project as it stands.

<a name="tut1">
<p><b>Tutorial 1: Setting up a simple collection, the address book.</b>

<ol>
	<li><p>Navigate to:
	<ul>
		<li>http://your host/Collections Keeper directory/index.php
	</ul>

	<li>Log in as an admin.

	<li>Click on "Create a new table".
	<ol type="A">
		<li>We are at the most going to need 10 fields for this collection so select 10 from the drop down.  If, in the future, you decide to keep this collection you can add and modify the table from what we are doing here.

		<li>In the "Collection Name" box type in: address book

		<li>Ensure that "Collection Table" is selected.

		<li>Under "Which sub-tables would you like to include?" set everything to "No".  If you have allowed files into the database choose "Yes" under "file".  Maybe you want to have a picture of the person.

		<li>In the first text box type in: name
		<ul>
			<li>Set the field type to "Text" if it is not already.
		</ul>

		<li>In the second text box type in: phone number
		<ul>
		<li>Set the field type to "Text" if it is not already.
		</ul>

		<li>In the third text box type in: address 1
		<ul>
		<li>Set the field type to "Text" if it is not already.
		</ul>

		<li>In the fourth text box type in: address 2
		<ul>
		<li>Set the field type to "Text" if it is not already.
		</ul>

		<li>In the fifth text box type in: city
		<ul>
		<li>Set the field type to "Text" if it is not already.
		</ul>

		<li>In the sixth text box type in: state
		<ul>
		<li>Set the field type to "Text" if it is not already.
		</ul>

		<li>In the seventh text box type in: zip
		<ul>
		<li>Set the field type to "Text" if it is not already.
		</ul>

		<li>In the eighth text box type in: birthday
		<ul>
		<li>Set the field type to "Date".
		</ul>

		<li>In the ninth text box type in: comments
		<ul>
		<li>Set the field type to "Memo".
		</ul>

		<li>Click submit at the bottom of the page.

		<li>You should get a note saying "address_book" has been added.

		<li>But why the underscore?  To ensure no problems with the database any spaces are replaced with underscores.
	</ol>

	<li>Navigate back to:
	<ul>
	<li>http://your host/Collections Keeper directory/index.php
	</ul>

	<li>Now we need to put in at least one person into the collection.
	<li>Click on "Create a collection entry".

	<ol type="A">
		<li>Select "address_book" from the drop down.

		<li>Ensure that "Owner" is you.

		<li>Under name put in "Joe Schmoe"

		<li>Under phone put in "555-1212"

		<li>Leave the rest blank.

		<li>Click submit at the bottom of the page.
	</ol>

	<li>Navigate back to:
	<ul>
	<li>http://your host/Collections Keeper directory/index.php
	</ul>

	<li>Click "Manage/View Collections".

	<li>In the "For the following collections" drop down choose "address_book" and click submit.

</ol>
<p>Here you will see the data you put into the collection earlier.  You can edit this data or delete the entry all together.  If you are going on to tutorial 2 I would recommend not deleting the entry as it is used later on.

<p>Go on to Tutorial 2 to see what we will do with this data.

<a name="tut2">
<p><b>Tutorial 2:  The daily planner</b>

<p>Ensure that you have completed tutorial 1 as this tutorial will use the table and data from tutorial 1.

<ol>
<li>Navigate to:
	<ul>
	<li>http://your host/Collections Keeper directory/index.php
	</ul>

<li>Login as an admin if you are not already.

<li>Click on "Create a new table".
	<ol type="A">
	<li>Select 10 from the drop down.

	<li>In the "Collection Name" box put in: daily planner
	<ul>
	<li>Ensure that Collection Table is selected.
	</ul>

	<li>Under "Which sub-tables would you like to include?" click "No" for everything.

	<li>In the first text box type in: time
	<ul>
	<li>Set the field type to "Text" if it is not already.
	</ul>
	<li>In the second text box type in: date
	<ul>
	<li>Set the field type to "Date".
	</ul>
	<li>In the third text box type in: subject
	<ul>
	<li>Set the field type to "Text" if it is not already.
	</ul>
	<li>In the fourth text box type in: comments
	<ul>
	<li>Set the field type to "Memo".
	</ul>
	<li>Click submit at the bottom of the page.
	</ol>

<li>But what about who the appointment is with?  The phone book table would be perfect here but because of the "Collections" focus of Collections Keeper you can not add a primary table as a foreign key at the creation time of the table.  This is just a minor precautionary measure that is easily circumvented.

<li>Navigate back to:
	<ul>
	<li>http://your host/Collections Keeper directory/index.php
	</ul>

<li>Click on "Modify a table".
	<ol type="A">
	<li>Under "Select a table:" select daily_planner.

	<li>Under "Select an action:" select "Add/Edit/Delete columns".

	<li>Click submit.

	<li>In the "Include the following primary tables" click Yes under address_book.

	<li>Let us also change the name of the field time to: appt time

	<li>Click on the button "Change name to ->" in the row with time as the field.  This will cause a new text box to appear.  In the new text box type: appt time

	<li>While we are at it let us remove comments.  In the "Change type to:" drop down choose "Remove this field".

	<li>Click submit at the bottom of the page.
	</ol>
<li>Navigate back to:
	<ul>
	<li>http://your host/Collections Keeper directory/index.php
	</ul>

<li>Click on "Create a collection entry"
	<ol type="A">
	<li>Select "daily_planner" from the drop down.

	<li>In appt_time put in: 1 pm

	<li>In date put in: 2004-04-02

	<li>In subject put in: Dentist appointment

	<li>Now here is where things get interesting.  When Collections Keeper finds a field that is a foreign key or a key in another table it goes to that table and creates a drop down filled with the first field it finds that is not a key.  In our case the first field it finds is name.  Select "Joe Schmoe" from the drop down.

	<li>Click submit.
	</ol>
<li>Navigate back to:
	<ul>
	<li>http://your host/Collections Keeper directory/index.php
	</ul>

<li>Click "Manage/View Collections".
	<ol type="A">
	<li>Under "For the following collections:" select "daily_planner".

	<li>Click submit.
	</ol>

</ol>
<p>In the resulting table you will see the data that you input for "daily_planner".  Under the address_book field you will see the name "Joe Schmoe" is a hyperlink.  If you click that hyperlink a new table will appear with the information for the entry in the address_book.

<p>Here you can also see why it might be dangerous to put in primary tables as sub-tables in a database.  If you have the option "allow privileged users to add/edit/delete from sub-tables" checked in your Collections Keeper settings a privileged user can now edit this data that may not belong to him.  Sure he only can do this through a roundabout way, but he still can.  This is because "address_book" is now a sub-table to "daily_planner".  So while it may be a primary table it is also a sub-table.

<a name="faq">
<p><b>Frequently Asked Questions</b>
<p>Question 1:  When looking at data in an excel spread sometimes there are weird codes or symbols in the middle of text.  

<p>Answer 1:  To ensure that the html generated by Collections Keeper is not corrupted by data from the database all symbols that may be a problem are replaced with their equivalent html code.  For example because a &lt; could cause a problem with your browser understanding the html it is replaced with &amplt; when put into the database.  The browser understands this code and replaces it with the correct code when displaying it.  The excel spreadsheets show the data exactly how it is in the database.  Unfortunately there is currently no way round this.

<a name="future">
<p><b>Future possibilities</b>
<ol>
	<li>Javascript calender for date fields
	<li>Have php build a pdf of what the database looks like
	<li>Have an sql parser so the user can edit when he submits user generated sql rather then just the collections keeper sql.
</ol>
<?
include("footer.inc.php");