<?php
/*
Copyright (C) 2004  Brian J. Mullen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
include_once("header.inc.php");

if ($type_login != 2) {
	echo ("You may not modify collection tables");
	exit();
}

//get the needed values for the tables
$table = get_tables(1);
$subTable = get_tables(2);
?>

<H2>Modify tables</H2>

<?php
$submit = isset($_POST['submit']) ? "submit" : "";
$action = $_POST['action'];
$sub_action = $_POST['sub_action'];

if (!$submit && !$action) {
	?>
	<FORM ACTION="<?php echo($_SERVER['PHP_SELF']); ?>" METHOD=POST>
	<P>Select a table:
	<BR><SELECT NAME="table_name" SIZE=1>
	<?php
	for ($i = 0; $i < count($table); $i++) {
		echo("\n<OPTION VALUE='{$table[$i]['name']}'>{$table[$i]['name']}\n");
	}
	for ($i = 0; $i < count($subTable); $i++) {
		echo("<OPTION VALUE='{$subTable[$i]['name']}'>{$subTable[$i]['name']}\n");
	}
	?>
	</SELECT>
	<P>Select an action:
	<BR><SELECT NAME="action" SIZE=1>
	<OPTION VALUE = 'edit'>Add/Edit/Delete columns
	<OPTION VALUE = 'rename'>Rename a table
	</SELECT>
	<P><INPUT TYPE=SUBMIT NAME="submit">
<?php
}
elseif($submit && $action == "rename") {
  
	$table_name = $_POST['table_name'];

  	echo("\nRenaming a table to a new name will also change the primary key.<BR>");
  	echo("\nIt is highly recommended that you allow Collections Keeper to go through all tables that may " .
        "contain this key and update them to the new key<BR>");
  	echo("\nNot doing so may result in unexpected behavior of the database<BR>");
	echo("Rename $table_name to:");
	echo("\n<FORM ACTION='" . $_SERVER['PHP_SELF'] . "' METHOD=POST>");
	echo("\n<INPUT TYPE=TEXT NAME='new_name'>");
	echo("\n<BR>Would you like Collections Keeper to go through all primary tables and update this name?<BR>");
	echo("\n<INPUT TYPE='radio' NAME='update_pri' value='1' checked> Yes");
	echo("\n<INPUT TYPE='radio' NAME='update_pri' VALUE='0'> No");
	echo("\n<BR>Would you like Collection Keeper to go through all sub tables and update this name?<BR>");
	echo("\n<INPUT TYPE='radio' NAME='update_sub' value='1' checked> Yes");
	echo("\n<INPUT TYPE='radio' NAME='update_sub' VALUE='0'> No");
	echo("\n<INPUT TYPE=HIDDEN NAME='old_name' VALUE='$table_name'>");
	echo("\n<INPUT TYPE=HIDDEN NAME='sub_action' VALUE='rename'>");
	//we need to find out whether it is a sub table or a primary table
	//here if the $table_type == 0 then it is a primary table else it is a sub table
	$table_type = 0;
	for($i = 0; $i < count($subTable); $i++) {
		if($subTable[$i]['name'] == $table_name) {
			$table_type = 1;
			break;
		}
	}
	echo("\n<INPUT TYPE=HIDDEN NAME='table_type' VALUE='$table_type'>");
	echo("\n<P><INPUT TYPE=SUBMIT NAME='submit' VALUE='Submit'>");
}
elseif($submit && $sub_action == "rename") {
  
	$old_name = $_POST['old_name'];
	$new_name = $_POST['new_name'];
	$table_type = $_POST['table_type'];
	$update_pri = $_POST['update_pri'];
	$update_sub = $_POST['update_sub'];

	$new_name = ereg_replace (" ", "_", $new_name);
	$new_pri_key = $new_name . "_id";

	//find old primary key
	$old_pri_key;
	if($table_type == 0) {
    for ($i = 0; $i < count($table); $i++) {
	    if($table[$i]['name'] == $old_name) {
        $old_pri_key = $table[$i]['key'];
        break;
      }
    }
  }
  else {
    for ($i = 0; $i < count($subTable); $i++) {
      if($subTable[$i]['name'] == $old_name) {
        $old_pri_key = $subTable[$i]['key'];
        break;
      }
    }
  }

  //change the primary key
  $query_string = "ALTER TABLE $old_name CHANGE $old_pri_key $new_pri_key int(10) unsigned NOT NULL default '0'";
  if(mysql_query($query_string)) {
    echo("The primary key $old_pri_key has been changed to $new_pri_key<BR>");
  }
  else {
    echo("<P>Error changing primary key name: " .
          mysql_error());
    exit();
  }
	$query_string = "ALTER TABLE $old_name RENAME $new_name";
	if(mysql_query($query_string)) {
		echo("$old_name has been renamed to $new_name<BR>");
	}
	else {
		echo("<P>Error updating table name: " .
         mysql_error() . "</P>");
        exit();
    }
    
    //update the name in the tables table
    if($table_type == 0) $table_name = "pri_tables";
    else $table_name = "sub_tables";

    $query = "UPDATE $table_name SET name='$new_name', key_name='$new_pri_key' WHERE name='$old_name'";
    if(mysql_query($query)) echo("Updated table name in $table_name table<BR>");
    else {
    	echo("There was an error updating table in $table_name");
    	echo(mysql_error());
    	exit();
    }

	//go through any tables and see if this shows up as a key that needs to be changed
  if (!$update_pri) echo("<P>You have choosen to not update any primary tables that contain this table.<BR>\nThis may result in unexpected behavior.");
	else {
    for($i = 0; $i < count($table); $i++) {
      //we do not want to change the main table, only other tables since we changed this table above
      //here we have to use the old name since the $table from tableParams.inc.php does not get updated
      if($table[$i]['name'] != $old_name) {
        $query_string = "SHOW KEYS FROM " . $table[$i]['name'];
        $result = mysql_query($query_string);
        if ($result) {
          while($field_info = mysql_fetch_array($result)) {
            //make sure we have the old key name and old table name here
            if($field_info['Column_name'] == $old_pri_key && $field_info['Key_name'] == $old_name) {
              //if we have gotten this far then we have the table that needs to be changed
              echo("Key found in table " . $table[$i]['name'] . ".  Updating it.<BR>");
              //drop old index, make sure you use the table name the index comes from
              $query_string = "ALTER TABLE " . $table[$i]['name'] . " DROP INDEX " . $old_name;
              if(mysql_query($query_string)) {
                //now rename and set up new index
                $query_string = "ALTER TABLE " . $table[$i]['name'] . " CHANGE $old_pri_key $new_pri_key int(10) unsigned NOT NULL default '0', ADD INDEX $new_name($new_pri_key)";
                if(mysql_query($query_string)) {
                  echo("Key updated in " . $table[$i]['name'] . "<BR>");
                  //break out since column names have to be unique
                  break;
                }
                else {
                  echo("<P>Error0 changing key name: " . mysql_error());
                  exit();
                }
              }
              else {
                echo("<P>Error1 changing key name: " . mysql_error());
                exit();
              }
            }
          }
        }
        else {
          echo("<P>Error2 changing primary key name: " . mysql_error());
          exit();
        }
      }
    }
  }
	
	if (!$update_sub) echo("<P>You have choosen to not update any sub tables that contain this table.<BR>\nThis may result in unexpected behavior.");
	else {
    for($i = 0; $i < count($subTable); $i++) {
      //we do not want to change the main table, only other tables since we changed this table above
      //here we have to use the old name since the $sutTable from subTableParams.inc.php doesn't get updated
      if($subTable[$i]['name'] != $old_name) {
        $query_string = "SHOW KEYS FROM " . $subTable[$i]['name'];
        $result = mysql_query($query_string);
        if ($result) {
          while($field_info = mysql_fetch_array($result)) {
            //make sure we have the old key name and old table name here
            if($field_info['Column_name'] == $old_pri_key && $field_info['Key_name'] == $old_name) {
              //if we have gotten this far then we have the table that needs to be changed
              echo("Key found in table " . $subTable[$i]['name'] . ".  Updating it.<BR>");
              //drop old indes, make sure you use the table name the index comes from
              $query_string = "ALTER TABLE " . $subTable[$i]['name'] . " DROP INDEX " . $old_name;
              if(mysql_query($query_string)) {
                //now rename and set up new index
                $query_string = "ALTER TABLE " . $subTable[$i]['name'] . " CHANGE $old_pri_key $new_pri_key int(10) unsigned NOT NULL default '0', ADD INDEX $new_name($new_pri_key)";
                if(mysql_query($query_string)) {
                  echo("Key updated in " . $subTable[$i]['name'] . "<BR>");
                  //break out since column names have to be unique
                  break;
                }
                else {
                  echo("<P>Error3 changing key name: " . mysql_error());
                  exit();
                }
              }
              else {
                echo("<P>Error4 changing key name: " . mysql_error());
                exit();
              }
            }
          }
        }
        else {
          echo("<P>Error5 changing primary key name: " . mysql_error());
          exit();
        }
      }
    }
  }
}
elseif ($submit && $action == "edit") {
  $table_name = $_POST['table_name'];
  
  $query_string = "DESCRIBE $table_name";
  $num_total_fields;
  $res_describe = mysql_query($query_string);
  if(!$res_describe) {
    echo("<P>Error connecting to database: " . mysql_error());
    exit();
  }
  else $num_total_fields = mysql_num_rows($res_describe);
  
  $query_string = "SHOW KEYS FROM $table_name";
  $res_keys = mysql_query($query_string);
  $num_key_fields = mysql_num_rows($res_keys);
  
  //this gives us the number of state vars we need for the javascript function below
  $num_nonkey_fields = $num_total_fields - $num_key_fields;
  ?>
  <script>
  function changeType( srcId, spanId, stateVar ){
       var src =  document.getElementById( srcId );

       if(stateVar=='text') src.value = '';
       if(stateVar=='text') stateVar = 'hidden';
       else stateVar = 'text';
       //create the new object
       var input ='<input type=' + stateVar + ' name=' + src.name + ' id=' + src.id + ' value=' + src.value + '><br>';

       document.getElementById(spanId).innerHTML = input;
       return stateVar;
  }
  <?php
  for($i = 0; $i < $num_nonkey_fields; $i++) echo("\nvar state$i = 'hidden';");
  ?>
  </script>

  <P><B>Modifying <?php echo($table_name); ?></B>
  <FORM ACTION="<?php echo($_SERVER['PHP_SELF']); ?>" METHOD=POST>
  <?php
  echo("<B>Include the following primary tables:</B><BR>");
  $pri_used = array();
  while($priTables_keys = mysql_fetch_array($res_keys)) {
    //make sure we skip user_info and the primary key
    if($priTables_keys['Key_name'] == "PRIMARY" || $priTables_keys['Key_name'] == "user_info") continue;
    //check to see if the key belongs to a primary table
    for($i = 0; $i < count($table); $i++) {
      if($priTables_keys['Key_name'] == $table[$i]['name'] && $priTables_keys['Column_name'] == $table[$i]['key']) {
        echo("\n" . $priTables_keys['Key_name'] . "<BR>");
        echo("\n<input type='radio' name='" . $priTables_keys['Column_name'] . "' value='1' checked>Yes");
        echo("<input type='radio' name='" . $priTables_keys['Column_name'] . "' value='0'>No<BR>");
        $pri_used[] = $priTables_keys['Key_name'];
        break;
      }
    }
  }
  //now list the tables that aren't already in the table
  //also grab the order by info when the table is found
  //while we're at it grab table type.  0=primary table, 1=sub_table
  $order_by = "";
  $table_type = 1;
  for($i = 0; $i < count($table); $i++) {
    //grab order by info and skip ourselves
    if($table[$i]['name'] == $table_name) {
    	$order_by = $table[$i]['order_by'];
    	$table_type = 0;
    	continue;
    }
    //we have to use the === here because the element it returns could be element 0
    //which in most cases evaluates to false, but we need to make sure that it is exactly false
    if(array_search($table[$i]['name'], $pri_used) === false) {
      echo("\n" . $table[$i]['name'] . "<BR>");
      echo("\n<input type='radio' name='" . $table[$i]['key'] . "' value='1'>Yes");
      echo("<input type='radio' name='" . $table[$i]['key'] . "' value='0' checked>No<BR>");
    }
  }
  //reset res_keys since we used it above
  $res_keys = mysql_query("SHOW KEYS FROM $table_name");
  $sub_used = array();
  //and do the stuff for sub tables;
  echo("<P><B>Include the following subtables:</B><BR>");
  while($subTables_keys = mysql_fetch_array($res_keys)) {
    //make sure we skip user_info and the primary key
    if($subTables_keys['Key_name'] == "PRIMARY" || $subTables_keys['Key_name'] == "user_info") continue;
    //special case for file table
    //skip if files aren't allowed
    if($subTables_keys['Key_name'] == "file" && $subTables_keys['Column_name'] == "file_id") {
      if($allow_files == 0) continue;
      echo("\n" . $subTables_keys['Key_name'] . "<BR>");
      echo("\n<input type='radio' name='" . $subTables_keys['Column_name'] . "' value='1' checked>Yes");
      echo("<input type='radio' name='" . $subTables_keys['Column_name'] . "' value='0'>No<BR>");
      $sub_used[] = $subTables_keys['Key_name'];
      continue;
    }
    //check to see if the key belongs to a primary table
    for($i = 0; $i < count($subTable); $i++) {
      if($subTables_keys['Key_name'] == $subTable[$i]['name'] && $subTables_keys['Column_name'] == $subTable[$i]['key']) {
        echo("\n" . $subTables_keys['Key_name'] . "<BR>");
        echo("\n<input type='radio' name='" . $subTables_keys['Column_name'] . "' value='1' checked>Yes");
        echo("<input type='radio' name='" . $subTables_keys['Column_name'] . "' value='0'>No<BR>");
        $sub_used[] = $subTables_keys['Key_name'];
        break;
      }
    }
  }
  //now list the tables that aren't already in the table
  //also grab the order by info when the table is found
  for($i = 0; $i < count($subTable); $i++) {
    //grab the order by info and skip ourselves
    if($subTable[$i]['name'] == $table_name) {
    	$order_by = $subTable[$i]['order_by'];
    	continue;
    }
    //we have to use the === here because the element it returns could be element 0
    //which in most cases evaluates to false, but we need to make sure that it is exactly false
    if(array_search($subTable[$i]['name'], $sub_used) === false) {
      echo("\n" . $subTable[$i]['name'] . "<BR>");
      echo("\n<input type='radio' name='" . $subTable[$i]['key'] . "' value='1'>Yes");
      echo("<input type='radio' name='" . $subTable[$i]['key'] . "' value='0' checked>No<BR>");
    }
  }
  if($allow_files == 1) {
    //handle the case where file does not show up in the table
    if(array_search("file", $sub_used) === false) {
      echo("\nfile<BR>");
      echo("\n<input type='radio' name='file_id' value='1'>Yes");
      echo("<input type='radio' name='file_id' value='0' checked>No<BR>");
    }
  }
  //we need to do some parsing on the order by info
  //strip of the " ORDER BY " in the string
  if($order_by != "") {
  	$order_by = substr($order_by, 10);
  	$order = explode(",", $order_by);
  	for($i = 0; $i < count($order); $i++) {
  		$order[$i] = trim($order[$i]);
  	}
  	//handle removing user_info_id so the sort order shows correctly
  	if($order[0] == "user_info_id") $order = array_slice($order, 1);
  }

  //now on to building the table
  echo("\n<p><table border='1'>");
  echo("\n<tr>");
  echo("\n<th rowspan='2'>Field</th>");
  echo("\n<th>Change type from:</th>");
  echo("\n<th rowspan='2'>&nbsp;</th>");
  echo("\n<th rowspan='2'>Change name to:</th>");
  echo("\n<th rowspan='2'>Change sort:</th>");
  echo("\n</tr>");
  echo("\n<tr>");
  echo("\n<th>Change type to:</th>");
  echo("\n</tr>");
  //this would probably work bettor as a for loop since current span
  //simply tracks what column we are in.
  $current_span = 0;
  echo("\n<B>Modify existing columns:</B><BR>");
  while($column_info = mysql_fetch_array($res_describe)) {
    //skip anywhere there are keys since this is all handled above
    if($column_info['Key']) continue;
    echo("\n<tr>");
    echo("\n<td rowspan='2'>");
    echo($column_info['Field']);
    echo("<INPUT TYPE=hidden name=field_names[$current_span] VALUE=" . $column_info['Field'] . ">");
    echo("</td>");
    echo("\n<td>");
    $old_type;
    if (eregi("int", $column_info['Type'])) {
      echo("Integer");
      $old_type = "int";
    }
    elseif (eregi("varchar", $column_info['Type'])) {
      echo("Text");
      $old_type = "varchar(255)";
    }
    elseif (eregi("text", $column_info['Type'])) {
      echo("Memo");
      $old_type = "text";
    }
    elseif (eregi("float", $column_info['Type'])) {
      echo("Decimal");
      $old_type = "float";
    }
    elseif (eregi("date", $column_info['Type'])) {
      echo("Date");
      $old_type = "date";
    }
    elseif (eregi("year", $column_info['Type'])) {
      echo("Year");
      $old_type = "year";
    }
    echo("<INPUT TYPE=hidden NAME=old_field_type[$current_span] VALUE=$old_type>");
    echo("</td>");
    echo("\n<td rowspan='2'>");
    echo("<input type='button' value='Change name to -->' onclick=\"state$current_span = changeType( 'new_name$current_span' , '$current_span', state$current_span)\">");
    echo("</td>");
    echo("\n<td rowspan='2'>&nbsp;");
    echo("\n<span id='$current_span'>");
    echo("\n<input type='hidden' name='new_name$current_span' id='new_name$current_span'>");
    echo("\n</span>");
    echo("\n</td>");
    echo("\n<td rowspan='2'>");
    //get sort/order value
    echo("\n<SELECT NAME=order[$current_span]>");
    $sort_loc = array_search($column_info['Field'], $order);
    $sort_loc_desc = array_search("{$column_info['Field']} DESC", $order);
    if($sort_loc === false && $sort_loc_desc === false) {
    	echo("\n<option value=0 selected>Don't sort on this field");
    }
    else echo("\n<option value=0>Don't sort on this field");
    //make sure we take into account that there are also 10 fields that may be added for a sort
    for($i = 0; $i < $num_nonkey_fields + 10; $i++) {
    	//get the number suffix
		$num_suf = "";
		switch($i + 1) {
			case 1:
				$num_suf = "st";
				break;
			case 2:
				$num_suf = "nd";
				break;
			case 3:
				$num_suf = "rd";
				break;
			default:
				$num_suf = "th";
		}
		//if we have a sort
		if($sort_loc == $i && $sort_loc !== false) echo ("\n<OPTION VALUE=" . ($i + 1) . " selected>Sort on this " . ($i + 1) . "$num_suf");
		//if we have a sort descending
		elseif($sort_loc_desc == $i && $sort_loc_desc !== false) echo ("\n<OPTION VALUE=" . ($i + 1) . " selected>Sort on this " . ($i + 1) . "$num_suf");
		else echo ("\n<OPTION VALUE=" . ($i + 1) . ">Sort on this " . ($i + 1) . "$num_suf");
    }
    echo("</SELECT>");
    if($sort_loc_desc !== false) echo("<BR><INPUT TYPE=checkbox NAME=order_desc[$current_span] checked>Descending");
    else echo("<BR><INPUT TYPE=checkbox NAME=order_desc[$current_span]>Descending");
    echo("</td>");
    echo("\n</tr>");
    echo("\n<tr>");
    echo("\n<td>");
    echo ("<SELECT NAME=new_field_type[$current_span] SIZE=1>");
    echo ("<option value=none selected>No change\n");
    echo ("<OPTION VALUE=varchar(255)>Text (Any letters, single line)\n");
    echo ("<OPTION VALUE=text>Memo (Any letters, multiple lines)\n");
    echo ("<OPTION VALUE=int>Integer (Any whole numbers: 3, 49)\n");
    echo ("<OPTION VALUE=float>Decimal (Any decimal numbers: 2.3)\n");
    echo ("<OPTION VALUE=date>Date (YYYY-MM-DD format)\n");
    echo ("<OPTION VALUE=year>Year (YYYY format)\n");
    echo ("<OPTION VALUE=remove>Remove this field\n");
    echo ("</SELECT>");
    echo("</td>");
    echo("\n</tr>");
    $current_span++;
  }
  echo("\n</table>");
  echo("\n<BR><B>Add columns:</B><BR>");
  echo("<TABLE BORDER=1>");
  echo("<TR>");
  echo("<TH>Field Name</TH>");
  echo("<TH>Field Type</TH>");
  echo("<TH>Sort order:</TH>");
  echo("</TR>");
  //throw on the stuff we need for new columns
  for ($i = 0; $i < 10; $i++) {
	echo ("\n<TR><TD><INPUT TYPE=TEXT NAME=field[$i]></TD>\n");
	echo ("\n<TD><SELECT NAME=field_type[$i] SIZE=1>");
	echo ("\n<OPTION VALUE=varchar(255)>Text (Any letters, single line)\n");
	echo ("\n<OPTION VALUE=text>Memo (Any letters, multiple lines)\n");
	echo ("\n<OPTION VALUE=int>Integer (Any whole numbers: 3, 49)\n");
	echo ("\n<OPTION VALUE=float>Decimal (Any decimal numbers: 2.3)\n");
	echo ("\n<OPTION VALUE=date>Date (YYYY-MM-DD format)\n");
	echo ("\n<OPTION VALUE=year>Year (YYYY format)\n");
	echo ("\n</SELECT></TD>");
	echo ("\n<TD><SELECT NAME=order[" . ($num_nonkey_fields + $i) . "]>");
	echo ("\n<OPTION VALUE=0>Don't sort on this field");
	for($j = 0; $j < $num_nonkey_fields + 10; $j++) {
		//get the number suffix
		$num_suf = "";
		switch($j + 1) {
			case 1:
				$num_suf = "st";
				break;
			case 2:
				$num_suf = "nd";
				break;
			case 3:
				$num_suf = "rd";
				break;
			default:
				$num_suf = "th";
		}					
		echo ("\n<OPTION VALUE=" . ($j + 1) . ">Sort on this " . ($j + 1) . "$num_suf");
	}
	echo("\n<INPUT TYPE=checkbox NAME=order_desc[" . ($num_nonkey_fields + $i) . "]>Descending");
	echo ("\n</TD>");
	echo ("\n</TR>\n");
  }
  echo("</TABLE>");
  echo("<INPUT TYPE=hidden NAME=table VALUE=$table_name>");
  echo("<INPUT TYPE=hidden NAME=table_type VALUE=$table_type>");
  echo("<INPUT TYPE=hidden NAME=num_nonkey_fields VALUE=$num_nonkey_fields>");
  echo("<INPUT TYPE=hidden NAME=sub_action VALUE='edit'>");
  echo("<INPUT TYPE=SUBMIT NAME=submit VALUE=Submit>");
  echo("</FORM>");
}
elseif ($submit && $sub_action=="edit") {
  //grab the arrays passed in the post
  //these are used for adding columns
  $field = $_POST['field'];
  $field_type = $_POST['field_type'];
  //these are used for modifying columns
  $old_field_name = $_POST['field_names'];
  $new_field_type = $_POST['new_field_type'];
  $old_field_type = $_POST['old_field_type'];
  //assorted hidden fields needed
  $table_name = $_POST['table'];
  $table_type = $_POST['table_type'];
  $num_nonkey_fields = $_POST['num_nonkey_fields'];
  $order = $_POST['order'];
  $order_desc = $_POST['order_desc'];
  
  //for the order by/sort we need to know the field names and where they are.
  //this array is for grabbing and tracking that
  $order_name = array();
  
  //print_r($_POST);
  //handle primary tables adds and removes
  for($i = 0; $i < count($table); $i++) {
    //make sure we don't try and add this table itself
    if($table[$i]['name'] == $table_name) continue;
    //we include all tables so we just have to look up the value in the post array
    $key = $table[$i]['key'];
    //grab the keys info from the table
    $result = mysql_query("SHOW KEYS FROM $table_name");
    if($result) {
      //if we find a key that should be in the table
      if($_POST[$key] == 1) {
        //check to see if the found key is already in the table
        $match = 0;
        //here a match found means that it is already in the table
        while($table_keys = mysql_fetch_array($result)) {
          if($table_keys['Key_name'] == $table[$i]['name'] && $table_keys['Column_name'] == $table[$i]['key']) {
            $match = 1;
            break;
          }
        }
        //if no match was found then we have to add the key to the table
        if($match == 0) {
          //find the table that corresponds to the key
          $query_string = "ALTER TABLE $table_name ADD $key int(10) UNSIGNED NOT NULL default '0', ADD INDEX " . $table[$i]['name'] . "($key)";
          if(mysql_query($query_string)) echo ("<BR>Added to the table " . $table[$i]['name'] . " with key $key");
          else {
            echo("<P>Error adding the key $key to this table: " . mysql_error());
            exit();
          }
        }
      }
      //else if we find a key that shouldn't be in the table we need to make sure it isn't
      elseif($_POST[$key] == 0) {
        $match = 0;
        //here a match found means that it is already in the table
        while($table_keys = mysql_fetch_array($result)) {
          if($table_keys['Key_name'] == $table[$i]['name'] && $table_keys['Column_name'] == $table[$i]['key']) {
            $match = 1;
            break;
          }
        }
        //if a match was found then we have to remove the key and index from the table
        if($match == 1) {
          //this is nice because when you drop the key you also automatically drop the index
          $query_string = "ALTER TABLE $table_name DROP $key";
          if(mysql_query($query_string)) echo ("<BR>Dropped from the table " . $table[$i]['name'] . " with the key $key");
          else {
            echo("<P>Error dropping $key from this table: " . mysql_error());
            exit();
          }
        }
      }
    }
    else {
      echo("<P>Error grabbing key information from $table_name: " . mysql_error());
      exit();
    }
  }
  //handle sub tables adds and removes
  for($i = 0; $i < count($subTable); $i++) {
    //make sure we don't try and add this table itself
    if($subTable[$i]['name'] == $table_name) continue;
    //we include all tables so we just have to look up the value in the post array
    $key = $subTable[$i]['key'];
    //grab the keys info from the table
    $result = mysql_query("SHOW KEYS FROM $table_name");
    if($result) {
      //if we find a key that should be in the table
      if($_POST[$key] == 1) {
        //check to see if the found key is already in the table
        $match = 0;
        //here a match found means that it is already in the table
        while($subTable_keys = mysql_fetch_array($result)) {
          if($subTable_keys['Key_name'] == $subTable[$i]['name'] && $subTable_keys['Column_name'] == $subTable[$i]['key']) {
            $match = 1;
            break;
          }
        }
        //if no match was found then we have to add the key to the table
        if($match == 0) {
          //find the table that corresponds to the key
          $query_string = "ALTER TABLE $table_name ADD $key int(10) UNSIGNED NOT NULL default '0', ADD INDEX " . $subTable[$i]['name'] . "($key)";
          if(mysql_query($query_string)) echo ("<BR>Added to the table " . $subTable[$i]['name'] . " with key $key");
          else {
            echo("<P>Error adding the key $key to this table: " . mysql_error());
            exit();
          }
        }
      }
      //else if we find a key that shouldn't be in the table we need to make sure it isn't
      elseif($_POST[$key] == 0) {
        $match = 0;
        //here a match found means that it is already in the table
        while($subTable_keys = mysql_fetch_array($result)) {
          if($subTable_keys['Key_name'] == $subTable[$i]['name'] && $subTable_keys['Column_name'] == $subTable[$i]['key']) {
            $match = 1;
            break;
          }
        }
        //if a match was found then we have to remove the key and index from the table
        if($match == 1) {
          //this is nice because when you drop the key you also automatically drop the index
          $query_string = "ALTER TABLE $table_name DROP $key";
          if(mysql_query($query_string)) echo ("<BR>Dropped from the table " . $subTable[$i]['name'] . " with the key $key");
          else {
            echo("<P>Error dropping $key from this table: " . mysql_error());
            exit();
          }
        }
      }
    }
    else {
      echo("<P>Error grabbing key information from $table_name: " . mysql_error());
      exit();
    }
  }
  //handle the special case of the file table
  //see if the current table even has file_id in it
  if($allow_files == 1) {
    $query_string = "SHOW KEYS FROM $table_name";
    $result = mysql_query($query_string);
    $have_file = 0;
    if($result) {
      while($key_info = mysql_fetch_array($result)) {
        if($key_info['Key_name'] == "file" && $key_info['Column_name'] == "file_id") {
          $have_file = 1;
          break;
        }
      }
    }
    else {
      echo("<P>Error updating file from this table: " . mysql_error());
      exit();
    }
    //if we need to add file
    if($have_file == 0 && $_POST['file_id'] == 1) {
      $query_string = "ALTER TABLE $table_name ADD file_id int(10) unsigned NOT NULL, ADD INDEX file(file_id)";
      if(mysql_query($query_string)) echo ("<BR>Added to the table file with key file_id<BR>");
      else {
        echo("<P>Error adding the key file_id to this table: " . mysql_error());
        exit();
      }
    }
    //else if we need to remove file
    elseif ($have_file == 1 && $_POST['file_id'] == 0) {
      $query_string = "ALTER TABLE $table_name DROP file_id";
      if(mysql_query($query_string)) echo ("<BR>Dropped from the table file with the key file_id<BR>");
      else {
        echo("<P>Error dropping pictrue_id from this table: " . mysql_error());
        exit();
      }
    }
  }
  //handle modifying the existing info
  $field_info = array();
  for($i = 0; $i < $num_nonkey_fields; $i++) {
    $new_name_assoc = "new_name" . $i;
    //if we don't have any changes then just skip all this
    if($_POST[$new_name_assoc] == "" && $new_field_type[$i] == "none") {
    	//grab the field name in case they want to order by/sort on it
    	$order_name[$i] = $old_field_name[$i];
    	continue;
    }
    //if we have to remove a field
    elseif($new_field_type[$i] == "remove") {
      $query_string = "ALTER TABLE $table_name DROP " . $old_field_name[$i];
      if(mysql_query($query_string)) echo ("<BR>The field " . $old_field_name[$i] . " has been removed from this table<BR>");
      else {
        echo("<P>There was an error removing " . $old_field_name[$i] . " from this table: " . mysql_error());
        exit();
      }
    }
    //if we have to change the name of a field and/or the type
    else {
      $actions = "\n<BR>Modified the field " . $old_field_name[$i] . " in the following manner:<BR>";
      //if we have to change the name
      if($_POST[$new_name_assoc] != "") {
        $name_to_use = ereg_replace (" ", "_", $_POST[$new_name_assoc]);
        $actions .= "\nChanged the name from " . $old_field_name[$i] . " to " . $name_to_use . "<BR>";
        //grab the new field name to set up the order by/sort if they want it
        $order_name[$i] = $name_to_use;
      }
      else $name_to_use = $old_field_name[$i];
      $query_string = "ALTER TABLE $table_name CHANGE " . $old_field_name[$i] . " " . $name_to_use . " ";
      //if we have to change the type
      if($new_field_type[$i] != "none") {
        $type_to_use = $new_field_type[$i];
        $actions .= "\nChanged the type from " . $old_field_type[$i] . " to " . $new_field_type[$i] . "<BR>";
      }
      else $type_to_use = $old_field_type[$i];
      //and finish the query string
      if ($type_to_use == "int" || $type_to_use == "float") $query_string .= $type_to_use . " NOT NULL default '0'";
      elseif ($type_to_use == "date") $query_string .= "date NOT NULL default '0000-00-00'";
      elseif ($type_to_use == "year") $query_string .= "year NOT NULL default '0000'";
      else $query_string .= $type_to_use . " NOT NULL default ''";
      if(mysql_query($query_string)) echo($actions);
      else {
        echo("<P>There was an error trying to modify a field" . mysql_error());
        exit();
      }
    }
  }
  //add any new fields
  for($i = 0; $i < count($field); $i++) {
    if($field[$i] != "") {
      $field_name = ereg_replace(" ", "_", $field[$i]);
      $query_string = "ALTER TABLE $table_name ADD $field_name ";
      if ($field_type[$i] == "int" || $field_type[$i] == "float") $query_string .= $field_type[$i] . " NOT NULL default '0'";
      elseif ($field_type[$i] == "date") $query_string .= "date NOT NULL default '0000-00-00'";
      elseif ($field_type[$i] == "year") $query_string .= "year NOT NULL default '0000'";
      else $query_string .= $field_type[$i] . " NOT NULL default ''";
      if(mysql_query($query_string)) echo("<BR>Added field " . $field[$i] . " with type " . $field_type[$i]);
      else {
        echo("<P>There was an error trying to add a field" . mysql_error());
        exit();
      }
      //we're going to need the field name for the order by.  In the existing fields this was passed in the
      //order_name array.  Here we have to add it to that array since we didn't have the name before
      $order_name[$num_nonkey_fields + $i] = $field_name;
    }
  }
  //parse all the order info so we can build the array to build the string
  $order_by = array();
  for($i = 0; $i < count($order); $i++) {
  	//in case they went willy nilly with choosing order we need to make sure there is actually
  	//a field there.
  	if($order_name[$i] == "") continue;
  	if($order[$i] == 0) continue;
  	//set up the order by info into the array
	$order_by[$order[$i]] = "$order_name[$i]";
	if(isset($order_desc[$i])) $order_by[$order[$i]] .= " DESC";
  }
  /*
  echo("<BR>order: ");
  print_r($order);
  echo("<BR>order_name: ");
  print_r($order_name);
  echo("<BR>order_desc: ");
  print_r($order_desc);
  echo("<BR>order_by: ");
  print_r($order_by);
  */
  //now sort the indexes since they get jumbled up
  ksort($order_by);
  if($table_type == 0) $order_str = " ORDER BY user_info_id";
  else $order_str = "";
  //since the 0 index means don't sort on, skip it;
  for($i = 1; $i <= count($order) + 1; $i++) {
	if($order_str != "" && isset($order_by[$i])) {
		$order_str .= ", " . $order_by[$i];
	}
	elseif($order_str == "" && isset($order_by[$i])) {
		$order_str = " ORDER BY " . $order_by[$i];
	}
  }

  if($table_type == 0) $table_type = "pri_tables";
  else $table_type = "sub_tables";
  $query = "UPDATE $table_type SET order_by='$order_str' WHERE name='$table_name'"; 
  $result = mysql_query($query);
  if(!$result) {
  	echo "There was an error updating the sort information: " . mysql_error();
  	exit();
  }
  else {
  	if($order_str != "") echo ("<BR>Set up $order_str");
  	else echo("Removed any sort information if there was any");
  }
}
?>
