VERSION 5.00
Begin VB.Form frmInventory 
   Caption         =   "Inventory"
   ClientHeight    =   7200
   ClientLeft      =   165
   ClientTop       =   735
   ClientWidth     =   6405
   LinkTopic       =   "Form2"
   ScaleHeight     =   7200
   ScaleWidth      =   6405
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton cmdApplyChanges 
      Caption         =   "A&pply Changes"
      Height          =   435
      Left            =   3420
      TabIndex        =   25
      Top             =   5640
      Visible         =   0   'False
      Width           =   2205
   End
   Begin VB.TextBox txtItemInfo 
      Height          =   300
      Index           =   5
      Left            =   2625
      TabIndex        =   23
      Top             =   2100
      Width           =   1005
   End
   Begin VB.TextBox txtItemInfo 
      Height          =   300
      Index           =   4
      Left            =   2625
      TabIndex        =   22
      Top             =   1740
      Width           =   690
   End
   Begin VB.TextBox txtItemInfo 
      Height          =   300
      Index           =   3
      Left            =   2640
      TabIndex        =   21
      Top             =   1395
      Width           =   870
   End
   Begin VB.TextBox txtItemInfo 
      Height          =   300
      Index           =   2
      Left            =   2640
      TabIndex        =   20
      Top             =   1005
      Width           =   375
   End
   Begin VB.TextBox txtItemInfo 
      Height          =   300
      Index           =   1
      Left            =   2640
      TabIndex        =   19
      Top             =   675
      Width           =   3645
   End
   Begin VB.TextBox txtItemInfo 
      Height          =   300
      Index           =   0
      Left            =   2640
      TabIndex        =   18
      Top             =   315
      Width           =   1935
   End
   Begin VB.ListBox lstItems 
      DataSource      =   "datItem"
      Height          =   3960
      Left            =   6540
      TabIndex        =   17
      Top             =   1800
      Visible         =   0   'False
      Width           =   2760
   End
   Begin VB.Data datItem 
      Caption         =   "datItem"
      Connect         =   "Access"
      DatabaseName    =   "billiards.mdb"
      DefaultCursorType=   0  'DefaultCursor
      DefaultType     =   2  'UseODBC
      Exclusive       =   0   'False
      Height          =   345
      Left            =   480
      Options         =   0
      ReadOnly        =   0   'False
      RecordsetType   =   1  'Dynaset
      RecordSource    =   ""
      Top             =   5655
      Visible         =   0   'False
      Width           =   5520
   End
   Begin VB.CommandButton cmdSearch 
      Caption         =   "Search &For Item"
      Height          =   495
      Left            =   4080
      TabIndex        =   16
      Top             =   1800
      Width           =   1935
   End
   Begin VB.CommandButton cmdAdd 
      Caption         =   "&Add"
      Height          =   510
      Left            =   4620
      TabIndex        =   11
      Top             =   6420
      Width           =   1395
   End
   Begin VB.CommandButton cmdEdit 
      Caption         =   "&Edit"
      Height          =   510
      Left            =   3210
      TabIndex        =   10
      Top             =   6435
      Width           =   1275
   End
   Begin VB.CommandButton cmdRemove 
      Caption         =   "&Remove Item From Inventory"
      Height          =   435
      Left            =   600
      TabIndex        =   9
      Top             =   5640
      Visible         =   0   'False
      Width           =   2205
   End
   Begin VB.CommandButton cmdClose 
      Caption         =   "&Close"
      Height          =   480
      Left            =   225
      TabIndex        =   8
      Top             =   6450
      Width           =   1275
   End
   Begin VB.Frame Frame1 
      Caption         =   "Inventory"
      Height          =   2955
      Left            =   1185
      TabIndex        =   0
      Top             =   2610
      Width           =   3675
      Begin VB.TextBox txtItemInfo 
         Height          =   300
         Index           =   6
         Left            =   330
         TabIndex        =   24
         Top             =   330
         Width           =   765
      End
      Begin VB.Frame Frame2 
         Caption         =   "Adjust Inventory"
         Height          =   1530
         Left            =   225
         TabIndex        =   2
         Top             =   1290
         Width           =   3150
         Begin VB.CommandButton cmdInvSub 
            Caption         =   "&Subtract from inventory"
            Height          =   450
            Left            =   330
            TabIndex        =   4
            Top             =   885
            Width           =   2355
         End
         Begin VB.CommandButton cmdInvAdd 
            Caption         =   "Ad&d to inventory"
            Height          =   435
            Left            =   330
            TabIndex        =   3
            Top             =   315
            Width           =   2355
         End
      End
      Begin VB.Label Label8 
         Caption         =   "(Put a negative number here if you don't want to track the inventory)"
         Height          =   420
         Left            =   390
         TabIndex        =   15
         Top             =   735
         Width           =   2835
      End
      Begin VB.Label Label1 
         Caption         =   "In Stock"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   360
         Left            =   1185
         TabIndex        =   1
         Top             =   360
         Width           =   930
      End
   End
   Begin VB.Label Label7 
      Alignment       =   1  'Right Justify
      Caption         =   "Price (for the customer)"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   300
      Left            =   300
      TabIndex        =   14
      Top             =   2115
      Width           =   2250
   End
   Begin VB.Label Label6 
      Alignment       =   1  'Right Justify
      Caption         =   "Items per unit"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   345
      Left            =   1140
      TabIndex        =   13
      Top             =   1695
      Width           =   1410
   End
   Begin VB.Label Label5 
      Alignment       =   1  'Right Justify
      Caption         =   "Unit Cost"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   1245
      TabIndex        =   12
      Top             =   1410
      Width           =   1305
   End
   Begin VB.Label Label4 
      Alignment       =   1  'Right Justify
      Caption         =   "Item Group"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   390
      Left            =   1245
      TabIndex        =   7
      Top             =   975
      Width           =   1305
   End
   Begin VB.Label Label3 
      Alignment       =   1  'Right Justify
      Caption         =   "Item Description"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   345
      Left            =   735
      TabIndex        =   6
      Top             =   660
      Width           =   1815
   End
   Begin VB.Label Label2 
      Alignment       =   1  'Right Justify
      Caption         =   "Item Code"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   330
      Left            =   855
      TabIndex        =   5
      Top             =   315
      Width           =   1695
   End
   Begin VB.Menu mnuFile 
      Caption         =   "File"
      Begin VB.Menu mnuQuit 
         Caption         =   "Quit"
         Shortcut        =   ^Q
      End
   End
   Begin VB.Menu mnuEdit 
      Caption         =   "Edit"
      Begin VB.Menu mnuAdd 
         Caption         =   "Add"
         Shortcut        =   ^A
      End
      Begin VB.Menu mnuEditItem 
         Caption         =   "Edit Item"
         Shortcut        =   ^E
      End
   End
   Begin VB.Menu mnuInventory 
      Caption         =   "Inventory"
      Begin VB.Menu mnuAddTo 
         Caption         =   "Add to"
         Shortcut        =   ^D
      End
      Begin VB.Menu mnuSubtractFrom 
         Caption         =   "Subtract from"
         Shortcut        =   ^S
      End
   End
End
Attribute VB_Name = "frmInventory"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit


Private arrayMin As Integer
Private arrayMax As Integer

Private inEdit As Boolean


Private Sub cmdAdd_Click()

    Dim i As Integer

    cmdEdit.Enabled = False
    cmdAdd.Enabled = False
    
    cmdInvAdd.Enabled = False
    cmdInvSub.Enabled = False
    
    For i = 0 To 6
    
        txtItemInfo(i).Text = ""
        txtItemInfo(i).Enabled = True
        
    Next i
    
    txtItemInfo(0).SetFocus

End Sub

Private Sub addItem()

On Error GoTo addError

    Dim i As Integer

    With datItem.Recordset
    
        .AddNew
            For i = 0 To txtItemInfo.UBound
                .Fields(i).Value = txtItemInfo(i).Text
            Next i
        .Update
    
    End With
    
    datItem.Refresh
    
    Call resetForm
    
    Exit Sub
    
addError:

    MsgBox "Error adding item.", vbOKOnly + vbExclamation, "Add Error"

End Sub


Private Sub cmdApplyChanges_Click()

On Error GoTo applyError

    Dim i As Integer

    With datItem.Recordset
    
        .FindFirst "itemID = '" & txtItemInfo(0).Text & "'"
        
        If .NoMatch Then
        
            MsgBox "Item code " & txtItemInfo(0).Text & " not on file.", _
                    vbOKOnly + vbExclamation, "No Match"
                    
            Call resetForm
            
            Exit Sub
            
        End If
    
        .Edit
            For i = 1 To txtItemInfo.UBound
                .Fields(i).Value = txtItemInfo(i).Text
            Next i
        .Update
    
    End With
    
    datItem.Refresh
    
    Call resetForm
    
    Exit Sub
    
applyError:

    MsgBox "Error editing item.", vbOKOnly + vbExclamation, "Edit Error"

    Call resetForm

End Sub

Private Sub cmdClose_Click()

    Unload Me

End Sub

Private Sub cmdEdit_Click()

    Dim i As Integer

    txtItemInfo(0).Enabled = True
    
    txtItemInfo(0).SetFocus
    
    inEdit = True

End Sub

Private Sub cmdInvAdd_Click()

On Error GoTo invAddError

    Dim toAdd As Integer
    
    toAdd = InputBox("Enter the amount to add to inventory:", "Add To Inventory", 0)
    
    With datItem.Recordset
    
        .FindFirst "itemID = '" & txtItemInfo(0).Text & "'"
        
        If .NoMatch Then
        
            MsgBox "Item code " & txtItemInfo(0).Text & " not on file.", _
                    vbOKOnly + vbExclamation, "No Match"
                    
            Call resetForm
            
            Exit Sub
            
        End If
        
        .Edit
            !quantityInStock = !quantityInStock + toAdd
            txtItemInfo(6).Text = Str(!quantityInStock)
        .Update
        
    End With
    
    datItem.Refresh
    
    Exit Sub

invAddError:

    MsgBox "An error has occurred. Please try again.", _
            vbOKOnly + vbExclamation, "Add To Inventory Error"

End Sub

Private Sub cmdInvSub_Click()

On Error GoTo invSubError

    Dim toSub As Integer
    
    toSub = InputBox("Enter the amount to subtract from inventory:", "Subtract From Inventory", 0)
    
    With datItem.Recordset
    
        .FindFirst "itemID = '" & txtItemInfo(0).Text & "'"
        
        If .NoMatch Then
        
            MsgBox "Item code " & txtItemInfo(0).Text & " not on file.", _
                    vbOKOnly + vbExclamation, "No Match"
                    
            Call resetForm
            
            Exit Sub
            
        End If
        
        .Edit
            !quantityInStock = !quantityInStock - toSub
            txtItemInfo(6).Text = Str(!quantityInStock)
        .Update
        
    End With
    
    datItem.Refresh
    
    Exit Sub

invSubError:

    MsgBox "An error has occurred. Please try again.", _
            vbOKOnly + vbExclamation, "Add To Inventory Error"

End Sub

Private Sub cmdRemove_Click()

On Error GoTo applyError

    Dim buttonPressed As Integer
    

    With datItem.Recordset
    
        .FindFirst "itemID = '" & txtItemInfo(0).Text & "'"
        
        If .NoMatch Then
        
            MsgBox "Item code " & txtItemInfo(0).Text & " not on file.", _
                    vbOKOnly + vbExclamation, "No Match"
                    
            Call resetForm
            
            Exit Sub
            
        End If
        
        buttonPressed = MsgBox("Are you sure you want to" & vbCrLf & _
                               "remove " & !itemDescription & " from the menu.", _
                               vbYesNo + vbQuestion, "Remove Item")
                               
        If buttonPressed = vbNo Then Exit Sub
    
        .Delete
    
    End With
    
    datItem.Refresh
    
    Call resetForm
    
    Exit Sub
    
applyError:

    MsgBox "Error editing item.", vbOKOnly + vbExclamation, "Edit Error"

    Call resetForm

End Sub

Private Sub cmdSearch_Click()

    If lstItems.Visible Then
    
        Call populateList
        
    Else

        Me.Width = Me.Width + 4000
    
        lstItems.Visible = True
        
        Call populateList
        
    End If

End Sub



Private Sub Form_Deactivate()

    Unload Me

End Sub

Private Sub Form_Load()
    
    arrayMin = txtItemInfo.LBound
    arrayMax = txtItemInfo.UBound

    Me.Top = 500
    Me.Left = 1000
    
    datItem.RecordSource = "SELECT * FROM tblItem " & _
                           "ORDER BY itemDescription"
                           
    Call resetForm

End Sub

Private Sub populateList()

    lstItems.Clear

    datItem.Refresh
    
    With datItem.Recordset
    
        If .BOF Then
        
            lstItems.addItem ("No items in table")
            
        Else
        
            Do While Not .EOF
                
                lstItems.addItem (!itemDescription)
                
                .MoveNext
                
            Loop
            
        End If
        
    End With

End Sub


Private Sub mnuAdd_Click()

    Call cmdAdd_Click

End Sub

Private Sub mnuAddTo_Click()

    If cmdInvAdd.Enabled Then
        Call cmdInvAdd_Click
    End If

End Sub

Private Sub mnuEditItem_Click()

    Call cmdEdit_Click

End Sub

Private Sub mnuQuit_Click()

    Call cmdClose_Click

End Sub



Private Sub mnuSubtractFrom_Click()

    If cmdInvSub.Enabled Then
        Call cmdInvSub_Click
    End If

End Sub

Private Sub txtItemInfo_GotFocus(Index As Integer)

    txtItemInfo(Index).BackColor = &HC0FFC0
    
    txtItemInfo(Index).SelStart = 0
    txtItemInfo(Index).SelLength = 100

End Sub

Private Sub txtItemInfo_KeyDown(Index As Integer, KeyCode As Integer, Shift As Integer)

    If Index = 0 And KeyCode = vbKeyReturn And inEdit Then
    
        Call populateInfo(txtItemInfo(0).Text)
        
        Exit Sub
    
    End If

    Select Case KeyCode
    
        Case vbKeyUp
            If Index > arrayMin Then txtItemInfo(Index - 1).SetFocus
        
        Case vbKeyDown, vbKeyReturn
            If inEdit Then
                If Index < arrayMax - 1 Then
                    txtItemInfo(Index + 1).SetFocus
                Else
                    Call cmdApplyChanges_Click
                End If
            Else
                If Index < arrayMax Then
                    txtItemInfo(Index + 1).SetFocus
                Else
                    Call addItem
                End If
            End If
            
        Case vbKeyEscape
            Call resetForm
            
        Case Else
            Exit Sub
            
    End Select

End Sub

Private Sub txtItemInfo_LostFocus(Index As Integer)

    txtItemInfo(Index).BackColor = vbWhite

End Sub


Private Sub populateInfo(item As String)

On Error GoTo loadError

    Dim i As Integer

    With datItem.Recordset
    
        .FindFirst "itemID = '" & item & "'"
        
        If .NoMatch Then
        
            MsgBox "Item code " & item & " not on file.", _
                    vbOKOnly + vbExclamation, "No Match"
                    
            txtItemInfo(0).SetFocus
            
            txtItemInfo(0).SelStart = 0
            
            txtItemInfo(0).SelLength = 25
            
            Exit Sub
            
        End If
    
        For i = 1 To 6
    
            txtItemInfo(i).Text = .Fields(i).Value
            
        Next i
    
    End With
    
    txtItemInfo(0).Enabled = False
    
    For i = 1 To 5
    
        txtItemInfo(i).Enabled = True
        
    Next i
    
    cmdInvAdd.Enabled = True
    cmdInvSub.Enabled = True
    
    cmdApplyChanges.Visible = True
    cmdRemove.Visible = True
    cmdEdit.Enabled = False
    cmdAdd.Enabled = False
    
    cmdInvAdd.Visible = True
    cmdInvSub.Visible = True
    
    txtItemInfo(1).SetFocus
    
    Exit Sub
    
loadError:

    txtItemInfo(0).Enabled = True
    
    MsgBox "Error loading information.", _
            vbOKOnly + vbExclamation, "Load Error"
            
    txtItemInfo(0).SetFocus
    
    txtItemInfo(0).SelStart = 0
    
    txtItemInfo(0).SelLength = 25

End Sub


Private Sub resetForm()

    Dim i As Integer

    cmdApplyChanges.Visible = False
    cmdRemove.Visible = False
    cmdEdit.Enabled = True
    cmdAdd.Enabled = True
    
    cmdInvAdd.Enabled = False
    cmdInvSub.Enabled = False
    
    For i = 0 To 6
    
        txtItemInfo(i).BackColor = vbWhite
        txtItemInfo(i).Text = ""
        txtItemInfo(i).Enabled = False
        
    Next i
    
    inEdit = False
    
    'cmdClose.SetFocus

End Sub
