// FileOpen.cpp : implementation file
//

#include "stdafx.h"
#include "GAwavelet.h"
#include "FileOpen.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define OPEN_FILE	0
#define	SAVE_FILE	1

#define	MAX_DISPLAY_WIDTH	1024
#define	MAX_DISPLAY_HEIGHT	768

OPENFILENAME    QKofN;
HANDLE h;
WIN32_FIND_DATA fData;

/////////////////////////////////////////////////////////////////////////////
// CFileOpen

CFileOpen::CFileOpen()
{
}

CFileOpen::~CFileOpen()
{
}

BOOL CFileOpen::GetFileName(int openORsave, char *file_type, char*FrameTitle, char*FileName, char*FileExt)
{
	char szDirName[MAX_PATH];	// directory string         
    char szFile[260];			// filename string                 
	char szFileTitle[100];		// file title string               
	char szFilter[260];			// filter string                   
	char chReplace;				// string separator for szFilter   
	int i, cbString;			// integer count variables   
	
	char *tempfile;

	tempfile = new char[256];
	
	// Obtain the current directory name and store it in szDirName. 
	GetCurrentDirectory(sizeof(szDirName), szDirName); 
 
	// Place the terminating null character in szFile.  
	szFile[0] = '\0'; 
 
	// Load the filter string 
	sprintf(szFilter,file_type);
	cbString = 12; 
 
	// Add a terminating null character to the filter string. 
	chReplace = szFilter[cbString - 1]; 
	for (i = 0; szFilter[i] != '\0'; i++)
		if (szFilter[i] == chReplace) szFilter[i] = '\0'; 

	// Set the members of the OPENFILENAME structure.
	QKofN.lStructSize = sizeof(OPENFILENAME); 
	QKofN.hwndOwner = NULL; 
	QKofN.lpstrFilter = szFilter; 
	QKofN.nFilterIndex = 1; 
	QKofN.lpstrFile = szFile; //file name + path
	QKofN.nMaxFile = sizeof(szFile); 
	QKofN.lpstrFileTitle = szFileTitle; // file name only
	QKofN.nMaxFileTitle = sizeof(szFileTitle); 
	QKofN.lpstrInitialDir = szDirName; 
	switch(openORsave)
	{
	case OPEN_FILE:
		QKofN.Flags = OFN_SHOWHELP | OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;
		if(!GetOpenFileName((LPOPENFILENAME)&QKofN))
			return(FALSE); 
 		break;

	case SAVE_FILE:
		QKofN.Flags = OFN_PATHMUSTEXIST | OFN_OVERWRITEPROMPT;
		if (!GetSaveFileName((LPOPENFILENAME)&QKofN)) 
			return(FALSE); 
		break;
	}
	

	strcpy(FrameTitle,szFile);
	strcpy(FileName,szFileTitle);

	strcpy(tempfile,FrameTitle);
	i = strlen(tempfile);
	tempfile = tempfile + i - 4;
	strcpy(FileExt,tempfile);
	tempfile = tempfile - i + 4;

	delete[] tempfile;

	return TRUE;
}

BEGIN_MESSAGE_MAP(CFileOpen, CWnd)
	//{{AFX_MSG_MAP(CFileOpen)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CFileOpen message handlers
