//
//	dib.h
//
#include <windows.h>		// required for all Windows applications
#include <windowsx.h>		// some nice macros, etc.

#include <assert.h>			// for asertion testing
#include <stdlib.h>			// for atoi() prototype
#include <memory.h>			// for _fmemset()
#include <stdio.h>          // for sprintf()
#include <ctype.h>			// for ascii test macros
#include <string.h>
#include <commdlg.h>

// Macro to determine to round off the given value to the closest BYTE
#define WIDTHBYTES(i)	((i+31)/32*4)
#define	PALVERSION		0x300
#define	MAXPALETTE		256				// max # supported palette entries

// 2 color mode we support
#define	BITONAL			0
#define	GRAY_SCALE		1
#define	RGB_COLOR24		2
 
// This structure is used for the Cleanup function that is called
// if there is a memory allocation problem when creating a DIB.
  
typedef struct tagPointerList
       {
	 HGLOBAL hPal;
	 HPALETTE hGrayscalePal; 
	 LPLOGPALETTE lpPal;
	 HGLOBAL hDIBdata;
	 unsigned char * hpDIBdata;
	 HGLOBAL hDIBheader;
	 BITMAPINFO * lpDIBheader;
        } POINTERLIST, FAR *LPPOINTERLIST; 
        
// functions
void FillDIBheader(BITMAPINFO *, unsigned long, unsigned long, unsigned long, unsigned long);
void FillLogicalPalette(LPLOGPALETTE);

int CreateDIBDisplay(HWND, unsigned char *, unsigned long, unsigned long, unsigned long, unsigned long, double);
void PASCAL CleanupDIBPointers(LPPOINTERLIST lpPointerList);

// not implemented yet.
//		currently, BMP files can be converted into TIF file
//		using LView tools.
HGLOBAL BmpRead(HWND, HINSTANCE, HWND, LPCSTR, char *, int *, int *, int *);
int parseBitMapFileHeader(unsigned char *, BITMAPFILEHEADER *);
int parseBitMapInfo(unsigned char *, BITMAPINFO *);
