/*
 * DiamondSquare.java
 *
 * Created on April 27, 2005, 4:54 PM
 */

package terrain;

/**
 *
 * @author Cliff
 */
public class DiamondSquare {
    public static int[][] DS(int max_variation, int min_height, int max_height, int xSize, int ySize) {
        
        //Check to make sure x and y sizes are equal
        if(xSize != ySize) {
            System.out.println("xSize, the size of the heightmap in the x direction, and ySize, the size of the heightmap in the y direction must be identical.  They also must be a power of 2 + 1");
            System.exit(1);
        }
        
        //check to make sure the dimensions are a power of 2 + 1.  IE  3, 5, 9, 17, 33, 65, 129, 257, 513
        int temp = xSize;
        temp = temp - 1;
        
        while( temp != 1) {
            if(temp % 2 == 0) {
                temp = temp / 2;
            } else break;
        }
        if(temp != 1) {
            System.out.println("The dimensions of the array must a power of 2 + 1");
            System.exit(1);
        }
        
        int[][] array = new int[xSize][ySize];
        
        int maximumDifference = max_variation;
        
        //set the four corner points to random values
        array[array.length-1][array[0].length-1] = (int) ((Math.random())*256);
        array[0][0] = (int) ((Math.random())*256);
        array[0][array[0].length-1] = (int) ((Math.random())*256);
        array[array.length-1][0] = (int) ((Math.random())*256);
        
        //
        for(int i=1;i<= (int) (Math.log( (double)(array.length-1)) /Math.log(2));i++) {
            int iterationNumber = i;
            
            int widthOfSubsquare = ( xSize - 1 ) / ( (int) Math.pow(2, iterationNumber -1));
            int halfSubsquare = widthOfSubsquare/2;
            
            //set the top/left corner of the working square to the origin.
            int startX = 0;
            int startY = 0;
            //Make sure that you aren't looking at an area smaller than 3x3
            if(Math.pow(2, iterationNumber) > xSize) {
                System.out.println("Can't do "+iterationNumber+" steps with a square size "+xSize);
            }
            //Since it's a valid size, you need to look at every possible square of the requested size
            else {
                while(startY < ySize-1) {
                    while(startX < xSize-1) {
                        //set the middle of the square to an average amount of the four corners
                        //System.out.println("Midpoint of the diamond step is "+ (startX + halfSubsquare) + "," + (startY + halfSubsquare));
                        array[startX + halfSubsquare][startY+halfSubsquare] =
                                (	array[startX][startY]
                                +	array[startX+widthOfSubsquare][startY]
                                +	array[startX][startY+widthOfSubsquare]
                                +	array[startX+widthOfSubsquare][startY+widthOfSubsquare]	)
                                /	4;
                        
                        //fudge the middle value by a random amount
                        array[startX + halfSubsquare][startY+halfSubsquare] += (Math.random() * maximumDifference * 2 - maximumDifference) / Math.pow(2,iterationNumber);
                        //set the midpoints of the edges of the square to the average of the points it lies between
                        //mid1
                        array[startX + halfSubsquare][startY] =
                                (	array[startX][startY]
                                +	array[startX + widthOfSubsquare][startY] )
                                /	2;
                        //mid2
                        array[startX][startY + halfSubsquare] =
                                (	array[startX][startY]
                                +	array[startX][startY + widthOfSubsquare] )
                                /	2;
                        //mid3
                        array[startX + widthOfSubsquare][startY + halfSubsquare] =
                                (	array[startX + widthOfSubsquare][startY]
                                +	array[startX + widthOfSubsquare][startY + widthOfSubsquare]	)
                                /	2;
                        //mid4
                        array[startX + halfSubsquare][startY+widthOfSubsquare] =
                                (	array[startX][startY + widthOfSubsquare]
                                +	array[startX  + widthOfSubsquare][startY + widthOfSubsquare]	)
                                /	2;
                        
                        //fudge the 4 diamond points by a random amount
                        //mid1
                        array[startX + halfSubsquare][startY] += (Math.random() * maximumDifference * 2 - maximumDifference) / Math.pow(2,iterationNumber);
                        //mid2
                        array[startX][startY + halfSubsquare] += (Math.random() * maximumDifference * 2 - maximumDifference) / Math.pow(2,iterationNumber);
                        //mid3
                        array[startX + widthOfSubsquare][startY + halfSubsquare] += (Math.random() * maximumDifference * 2 - maximumDifference) / Math.pow(2,iterationNumber);
                        //mid4
                        array[startX + halfSubsquare][startY+widthOfSubsquare] += (Math.random() * maximumDifference * 2 - maximumDifference) / Math.pow(2,iterationNumber);
                        //move the working square to the right
                        startX += widthOfSubsquare;
                    }
                    //return the working square to the leftmost side
                    startX = 0;
                    //move the working square down
                    startY += widthOfSubsquare;
                }
            }
        }
        
        array = HeightMap.fit(array, min_height, max_height);
        return array;
    }
    
    public static void main(String[] args) {
        HeightMap.writeJPG(DS(2000, 0, 255, 513, 513), "DiamondSquare"+513);
    }
}
