/*
 * HeightMap.java
 *
 * Created on April 27, 2005, 4:53 PM
 */

package terrain;

/**
 *
 * @author Cliff
 */
import java.io.File;
import java.awt.image.BufferedImage;

public class HeightMap {
    
    
    public static int[][] fit(int[][] array, int minDesiredHeight, int maxDesiredHeight) {
        int xSize = array.length;
        int ySize = array[0].length;
        
        int max = Integer.MIN_VALUE;
        int min = Integer.MAX_VALUE;
        int num = 0;
        
        for(int i=0;i<ySize;i++) {
            for(int j=0;j< xSize;j++) {
                num = array[i][j];
                if(num < min) min = num;
                if(num > max) max = num;
            }
        }
        
        double scale = (double)(maxDesiredHeight - minDesiredHeight) / (double) (max - min);
        
        //System.out.println("Min: "+min+" Max: "+max+" Scale: "+scale); //For debugging
        
        for(int i=0;i<ySize;i++) {
            for(int j=0;j< xSize;j++) {
                array[i][j] = (int)(((double) (array[i][j]-min+minDesiredHeight))* scale);
            }
        }
        
        return array;
    }
    
    //Array should be a heightmap with values up to 255
    public static void writeJPG(int[][] array, String fileName) {
        int xSize = array.length;
        int ySize = array[0].length;
        
        BufferedImage image = new BufferedImage(xSize,ySize,java.awt.image.BufferedImage.TYPE_INT_RGB);
        
        int temp = 0;
        int temp2;
        
        
        for(int j = 0; j < ySize; j++) {
            for(int i = 0; i < xSize; i++) {
                temp = array[i][j];
                
                temp2 =  (temp << 24) | (temp << 16) | (temp << 8) | temp;
                image.setRGB(i, j, temp2);
            }
        }
        
        try {
            javax.imageio.ImageIO.write(image, "jpg", new File(fileName+".jpg"));
        }
        
        catch(java.io.IOException e) {
            e.printStackTrace();
        }
    }
    
    public static void writeJPG(BufferedImage image, String fileName) {
        try {
            javax.imageio.ImageIO.write(image, "jpg", new File(fileName+".jpg"));
        }
        
        catch(java.io.IOException e) {
            e.printStackTrace();
        }
    }
    
    public static BufferedImage makeBufferedImage(int[][] array) {
        int xSize = array.length;
        int ySize = array[0].length;
        
        BufferedImage image = new BufferedImage(xSize,ySize,java.awt.image.BufferedImage.TYPE_INT_RGB);
        
        int temp = 0;
        int temp2;
        
        
        for(int j = 0; j < ySize; j++) {
            for(int i = 0; i < xSize; i++) {
                temp = array[i][j];
                
                temp2 =  (temp << 24) | (temp << 16) | (temp << 8) | temp;
                image.setRGB(i, j, temp2);
            }
        }
        return image;
    }
}