class ForumController < ApplicationController
	layout "editor-layout"	
	scaffold :forum

	# Default action is to list.
	#
	def index
		list
		render_action 'list'
	end

	# Redefine list method, retrieve all table entries, use list.rhtml.
	#
	def list
		@forums = Forum.find_all
		@families = Family.find_all
		@softwares = Software.find_all
	end
	
	def edit
		@forum = Forum.find(@params[:id])
		@families = Family.find_all
		@softwares = Software.find_all
	end

	# On update, give some feedback and return to list.
	#
	def update
		@forum = Forum.find(@params[:id])
		if @forum.update_attributes(@params[:forum])
			flash['notice'] = 'Forum was successfully updated.'
			redirect_to :action => 'list'
		else
			render_action 'edit'
		end
	end
	
	def new
		@families = Family.find_all
		@softwares = Software.find_all
	end
	
	# On creation, give some feedback and return to list.
	#
	def create
		@forum = Forum.new(@params[:forum])
		@families = Family.find_all
		@softwares = Software.find_all
		if @forum.save
			flash['notice'] = 'Forum was successfully created.'
			redirect_to :action => 'list'
		else
			render_action 'new'
		end
	end
end
