class SearchController < ApplicationController
	layout "search-layout"
	scaffold :search
	# Class Variables
	@@some_query = ""
	@@new_search = nil
	@@new_id = nil
	# Display front page
	#
	def index
		@@search_query = ""
		@flagged = Forum.find_search_flagged
		@unflagged = Forum.find_search_unflagged
		@forums = Forum.find_all
	end

	def list
		@search = Search.find_all
	end
	# For each selected forum, place an entry in the search table
	# and perform the query.
	#
	def query_forums
		@@new_search = Search.new
		@@some_query = @params[:query] # @Params = cgi parameters.
		@flagged = Forum.find_search_flagged
		@unflagged = Forum.find_search_unflagged
		@forums = Forum.find_all
		@@new_search.query = @@some_query
		@@new_search.name = @@some_query + " @ " + DateTime.now.to_s
		@@new_search.save
		@@new_id = @@new_search.id
		search_results = Search.retrieve_results(@flagged, @@new_search)
		redirect_to(:action => "render_results")
	end

	# Render the results of the search
	# @@new_search.id seems to be returning a bad number,
	# So I circumvented the problem by displaying the most recent search.
	def render_results
		#@results = Result.find_by_sql ["SELECT * FROM result WHERE search_id = ?", ]
		@results = Result.find_by_sql ["SELECT * FROM result WHERE search_id in (SELECT MAX(id) FROM search)"]
	end

	# Render the selected previous search results.
	def render_old
		id = @params[:id]
		@results = Result.find_by_sql ["SELECT * FROM result WHERE search_id in (SELECT id FROM search where id = ?)", id ]
	end
	
	def toggle_search
		forum = Forum.find(@params[:id])
		# Change the search flag.
		# ActiveRecord will automatically do the boolean/int conversion.  
		forum.search_flag = !forum.search_flag?
	
		if forum.save
			redirect_to(:action => "index")
		else
			render_text "Couldn't update item"
		end
	end
end
