<?php

/*

Copyright (C) 2004  Donald L. Tinsley



This program is free software; you can redistribute it and/or

modify it under the terms of the GNU General Public License

as published by the Free Software Foundation; either version 2

of the License, or (at your option) any later version.



This program is distributed in the hope that it will be useful,

but WITHOUT ANY WARRANTY; without even the implied warranty of

MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the

GNU General Public License for more details.



You should have received a copy of the GNU General Public License

along with this program; if not, write to the Free Software

Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

include("sys_include.inc.php");



//create entries

$createDatabase_sql = "CREATE DATABASE IF NOT EXISTS $database_name;";



$selectDatabase_sql = "USE $database_name;";



//Collections Keeper required tables

$user_sql = "CREATE TABLE user_data (

  user_id int(10) unsigned NOT NULL auto_increment,

  user_type varchar(255) NOT NULL,

  is_admin bool default 'false',

  lname varchar(255) default '',

  fname varchar(255) default '',

  department varchar(30) default '',

  phone varchar(255) default '',

  phone_availability varchar(255) default 'none',

  email varchar(255) default '',

  email_availability varchar(255) default 'none',

  username varchar(255) NOT NULL default '',

  pass varchar(255) default '',

  salt varchar(255) default '',

  PRIMARY KEY (user_id),

  INDEX (username, pass, salt),

  UNIQUE KEY (username)

) ENGINE = INNODB;";



$session_settings_sql = "CREATE TABLE session_settings (

  user_id int(10) unsigned NOT NULL default '0',

  last_action int(20) unsigned NOT NULL default '0',

  selected_semester int(6) NOT NULL default '0',

  KEY user_info (user_info_id)

) ENGINE = INNODB;";





$assignment_sql = "CREATE TABLE assignment (

  assignment_id int(10) unsigned NOT NULL auto_increment,

  course_id int(10) unsigned NOT NULL,

  assignment_type int(10) unsigned NOT NULL,

  title varchar(255) NOT NULL default '',

  date_added date NOT NULL,

  date_due date NOT NULL,

  points_possible SMALLINT NOT NULL default '0',

  PRIMARY KEY (assignment_id),

  INDEX (course_id),

  INDEX (assignment_type),

  FOREIGN KEY (course_id) REFERENCES course(course_id) ON DELETE CASCADE,

  FOREIGN KEY (assignment_type) REFERENCES assignment_type(assignment_type_id)

) ENGINE = INNODB;";



$grading_scheme_sql = "CREATE TABLE grading_scheme (

  course_id int(10) unsigned NOT NULL,

  type_id int(10) unsigned NOT NULL,

  PRIMARY KEY (course_id, type_id),

  INDEX (course_id),

  INDEX (type_id),

  FOREIGN KEY (course_id) REFERENCES course(course_id) ON DELETE CASCADE,

  FOREIGN KEY (type_id) REFERENCES assignment_type(assignment_type_id)

) ENGINE = INNODB;";

  

$default1_scheme_sql = "INSERT INTO assignment_type SET

  type='Homework', weight=.40;";



$default2_scheme_sql = "INSERT INTO assignment_type SET

  type='Test', weight=.4;";



$default3_scheme_sql = "INSERT INTO assignment_type SET

  type='Quiz', weight=.2;";

  

$assignment_type_sql = "CREATE TABLE assignment_type (

  assignment_type_id int(10) unsigned NOT NULL auto_increment,

  type varchar(50) NOT NULL default '',

  weight decimal(4, 2) unsigned NOT NULL default '1',

  PRIMARY KEY (assignment_type_id)

) ENGINE = INNODB;";



$course_sql = "CREATE TABLE course (

  course_id INT(10) unsigned NOT NULL AUTO_INCREMENT,

  crn varchar(8) default '',

  semester INT(6) unsigned NOT NULL DEFAULT '0',

  course_prefix VARCHAR(8) NOT NULL DEFAULT '',

  course_number VARCHAR(8) NOT NULL DEFAULT '',

  section VARCHAR(8) NOT NULL DEFAULT '',

  title TINYTEXT NOT NULL DEFAULT '',

  faculty_id int(10) unsigned NOT NULL,  

  PRIMARY KEY (course_id),

  INDEX (faculty_id),

  FOREIGN KEY (faculty_id) REFERENCES user_data(user_id) ON DELETE CASCADE

) ENGINE = INNODB;";



$course_student_sql = "CREATE TABLE course_student (

  course_id INT(10) unsigned NOT NULL,

  student_id INT(10) unsigned NOT NULL,

  PRIMARY KEY (course_id, student_id),

  INDEX (student_id),

  INDEX (course_id),

  FOREIGN KEY (student_id) REFERENCES user_data(user_id) ON DELETE CASCADE,

  FOREIGN KEY (course_id) REFERENCES course(course_id) ON DELETE CASCADE

) ENGINE = INNODB;";



$grade_sql = "CREATE TABLE grade (

  student_id int(10) unsigned NOT NULL,

  assignment_id INT(10) unsigned NOT NULL,

  points int(4) unsigned NOT NULL DEFAULT '0',

  PRIMARY KEY (student_id, assignment_id),

  INDEX (student_id),

  INDEX (assignment_id),

  FOREIGN KEY (student_id) REFERENCES user_data (user_id) ON DELETE CASCADE,

  FOREIGN KEY (assignment_id) REFERENCES assignment (assignment_id) ON DELETE CASCADE

) ENGINE = INNODB;";



//start creating database and tables



echo"<br>Making the virtuaGrades database...";

if (!mysql_query($createDatabase_sql)) {

	echo ("<b>Database not created.</b><br>MySQL Error: ".mysql_errno()." -> ".mysql_error());

	echo ("<br>");

} else {

	echo ("<b>Database successfully created</b><br>");

	mysql_query($selectDatabase_sql);

}

//drop all existing tables

$query = "SHOW TABLES";

$result = mysql_query($query);

while($table_info = mysql_fetch_array($result)) mysql_query("DELETE FROM " . $table_info[0] . ";");

while($table_info = mysql_fetch_array($result)) mysql_query("DROP TABLE " . $table_info[0] . ";");



echo"Creating User table...";

if (!mysql_query($user_sql)) {

	echo"<b>Table not created.</b><br>MySQL Error: ".mysql_errno()." -> ".mysql_error();

	echo"<br>";

}

else {

	echo"<b>Table successfully created</b><br>";

}



echo"Creating course table...";

if (!mysql_query($course_sql)) {

	echo"<b>Table not created.</b><br>MySQL Error: ".mysql_errno()." -> ".mysql_error();

	echo"<br>";

}

else {

	echo"<b>Table successfully created</b><br>";

}



echo"Creating assignment_type table...";

if (!mysql_query($assignment_type_sql)) {

	echo"<b>Table not created.</b><br>MySQL Error: ".mysql_errno()." -> ".mysql_error();

	echo"<br>";

}

else {

	echo"<b>Table successfully created</b><br>";

}



echo"Creating course_student table...";

if (!mysql_query($course_student_sql)) {

	echo"<b>Table not created.</b><br>MySQL Error: ".mysql_errno()." -> ".mysql_error();

	echo"<br>";

}

else {

	echo"<b>Table successfully created</b><br>";

}



echo"Creating assignment table...";

if (!mysql_query($assignment_sql)) {

	echo"<b>Table not created.</b><br>MySQL Error: ".mysql_errno()." -> ".mysql_error();

	echo"<br>";

}

else {

	echo"<b>Table successfully created</b><br>";

}



echo"Creating grade table...";

if (!mysql_query($grade_sql)) {

	echo"<b>Table not created.</b><br>MySQL Error: ".mysql_errno()." -> ".mysql_error();

	echo"<br>";

}

else {

	echo"<b>Table successfully created</b><br>";

}



echo"Creating grading_scheme table...";

if (!mysql_query($grading_scheme_sql)) {

	echo"<b>Table not created.</b><br>MySQL Error: ".mysql_errno()." -> ".mysql_error();

	echo"<br>";

}



else {

	echo"<b>Table successfully created</b><br>";

}



echo"Inserting default grading scheme...";

if(!mysql_query($default1_scheme_sql) || !mysql_query($default2_scheme_sql) || !mysql_query($default3_scheme_sql))

{

	echo"<b>Default grading scheme not created.</b><br>MySQL Error:  " . mysql_errno() . " -> " . mysql_error();

	echo"<br>";

}

else echo"<b>Default grading scheme created.</b><br>";



echo"<p><b>Install complete!.</b>";

$salt = get_salt("virtuaSedarg");

$admin_sql = "INSERT INTO user_data SET username='" . base64_encode("administrator") .

			 "', password='" . md5("virtuaSedarg" . $salt) .

			 "', fname='" . base64_encode("Administrator") .

			 "', isAdmin=1, type='" ; 



?>

