<?PHP

include("dbConnection.inc.php");



################################# Account and LOGIN functions #####################################################

//login user through ldap--load new users if lookup is on

//will allow database verification of username & password if bypass parameters are on

function login_ldap($username, $password, $ldap)

{

	if($ldap_connection = ldap_connect($ldap['server']))

	{

		$base = $ldap['base'];

		//ignore error--try to bind username & pw to user in faculty group

		if(@ldap_bind($ldap_connection, "uid=$username, ou=Admin, o=$base", $password))

		{

			$type = "Admin"; //NOTE:  Admin in ldap is the same as Faculty in the database

		}

		//ignore error--try to bind username & pw to user in student group

		elseif(@ldap_bind($ldap_connection, "uid=$username, ou=Student, o=$base", $password))

		{

			$type = "Student";

		}

		if($type)

		{   

			//see if user is in the database

			if($result = mysql_query("SELECT user_id, is_admin, user_type FROM user_data WHERE username='" .

									   base64_encode($username) . "';"))

			{ 

				if($row = mysql_fetch_assoc($result))

				{//login good--user is in database

					$user['userID'] = $row['user_id'];

					$user['type'] = base64_decode($row['user_type']);

					$user['admin'] = $row['is_admin'];

					if($user['type'] == "Pending") //this user has been loaded as a student for a course

					{   

						if($ldap['lookup'])

						{	//if pending && Faculty--Dual status

							if($type == "Admin") $user = load_new_user_from_ldap($username, $password, "Dual", $ldap);

							//else just Faculty

							else $user = load_new_user_from_ldap($username, $password, $type, $ldap);

						}

						else

						{

							$user['new'] = true; //flag so this new user will have to enter missing data

							//Pending & Faculty--Dual status

							if($type == "Admin") $user['type'] = "Dual";

						}

					}

					//check for status change to dual since last login--a faculty loaded into another faculty's course

					if($user['type'] == "Admin" && check_for_dual($user['userID'])) $user['type'] = "Dual";

					validate_password($password, $user['userID']);

				}

				//ldap bind was successful && user not in db, load new user's data from ldap

				elseif($ldap['lookup']) $user = load_new_user_from_ldap($username, $password, $type, $ldap);

				//or insert known data into db

				else $user = init_insert_user($username, $password, $type);

			}

			else $user = "Error connecting to database.  Ask an administrator for assistance";

		}//invalid username/password from ldap server

		//this is unnecessary because an invalid bind throws an error

		else

		{

			if($ldap['bypassOnInvalid']) $user = login_db($username, $password);

			else $user = "Invalid username/password";		

		}

	}

	else 

	{	//this allows for users who may be in database from a non-ldap account creation

		//in which case, their password was not validated through ldap

		if($ldap['bypassOnError']) $user = login_db($username, $password);

		else $user = "LDAP server is down.  Please try again later.";

	}

	ldap_close($ldap_connection);

	return $user;	

}

//login through database verification

function login_db($username, $password)

{	//get salt from database for this user

	$salt_query = "SELECT salt FROM user_data WHERE username = '" . base64_encode($username) . "';";

	if($result = mysql_query($salt_query))

	{

		if($row = mysql_fetch_assoc($result))

		{	//decode salt

			$salt = base64_decode($row['salt']);

			//verify password and get data	

			$sql_query = "SELECT user_id, user_type, is_admin FROM user_data WHERE username = '" . base64_encode($username) .

			 "' AND pass = '" . md5((trim($password) . $salt)) . "';";

			if($result = mysql_query($sql_query))

			{

				if($row = mysql_fetch_assoc($result)) 

				{	//user is verified--load necessary data into array to return to the login page

					$user['userID'] = $row['user_id'];

					$user['type'] = base64_decode($row['user_type']);

					$user['admin'] = $row['is_admin'];

				}

				else $user = "Invalid username/password";

			}

			else $user = "Error connecting to database.  Ask an administrator for assistance";

		}

		else $user = "Invalid username/password";

	}

	else $user = "Error connecting to database.  Ask an administrator for assistance";	

	return $user;

}		 

//searches for user data through ldap--may not be supported/allowed in all cases

function load_new_user_from_ldap($username, $password, $type, $ldap)

{	

	if($ldap_connection = ldap_connect($ldap['server']))

	{		

	    $base = $ldap['base'];

	    if($type == "Dual")

	    {

	    	$Dual = true;

	    	$type = "Admin"; //Dual=student & Faculty--not supported in ldap

	    }

	    $user_search = ldap_search($ldap_connection, "ou=$type, o=$base", "uid=" . $username );

		

		if(ldap_count_entries($ldap_connection, $user_search))

		{

			if($Dual) $type = "Dual"; // change back to Dual for load into database

			elseif($type == "Admin") $type = "Faculty";

		    $array['type'] = $type;

			$resource = ldap_first_entry($ldap_connection, $user_search);

		}

		

		if($values = ldap_get_attributes($ldap_connection, $resource))

		{   //store data from ldap in an array to load into db

			$array['lname'] = strtoupper(substr($values['sn'][0], 0, 1)) . strtolower(substr($values['sn'][0], 1));

			$array['fname'] = strtoupper(substr($values['givenname'][0], 0, 1)) . strtolower(substr($values['givenname'][0], 1));

			$array['email'] = $values['mail'][0];

			$array['phone'] = $values['telephonenumber'][0];

			$array['username'] = $username;

			$array['password'] = $password;

			$user = store_data($array);

			$user['new'] = true; //flag user so login will direct them to user data form

		}						 //gives the user an opportunity to fill in missing/incorrect data

		ldap_close($ldap_connection);

	}

	else $user = "ldap error";

	return $user;

}

//actually puts the data into the database

function store_data($array)

{	//generate salt

	$salt = get_salt($array['password']);

	//see if user is already in database

	$search_sql = "SELECT user_id FROM user_data WHERE username='" . base64_encode($array['username']) .

				  "' AND user_type='" . base64_encode("Pending") . "';";

	if($result = mysql_query($search_sql))

	{	//user already in database, UPDATE

		if($row = mysql_fetch_assoc($result))

		{

			$sql = "UPDATE user_data SET username='" . base64_encode($array['username']) .

				"', pass='" . md5($array['password'] . $salt) .

				"', salt='" . base64_encode($salt) .

				"', fname='" . base64_encode($array['fname']) .

				"', lname='" . base64_encode($array['lname']) .

				"', email='" . base64_encode($array['email']) .			

				"', user_type='" . base64_encode($array['type']) .

		        "', phone='" . base64_encode($array['phone']) . "' WHERE user_id=" . $row['user_id'] . ";";

		    mysql_query($sql);

			$array['userID'] = $row['user_id'];

		}

	

		else

		{

			//new user--insert

			$sql = "INSERT INTO user_data SET username='" . base64_encode($array['username']) .

					"', pass='" . md5($array['password'] . $salt) .

					"', salt='" . base64_encode($salt) .

					"', fname='" . base64_encode($array['fname']) .

					"', lname='" . base64_encode($array['lname']) .

					"', email='" . base64_encode($array['email']) .			

					"', user_type='" . base64_encode($array['type']) .

			        "', phone='" . base64_encode($array['phone']) . "';";

			mysql_query($sql);

			$array['userID'] = mysql_insert_id();

		}

	}

	return $array;

}

//generates random string to append to password--make length 16--better encoding

function get_salt($password)

{

	$passLen = strlen($password);

	$salt = "";

	for($i = 0; $i < 16 - $passLen; $i++) $salt .= chr(rand(40, 126));

	return $salt;

}

//this function just inserts the three known parameters--used when ldap lookup fails or is disabled

//after insertion, user is given opportunity to fill in the missing information

function init_insert_user($username, $password, $type)

{

	if($type == "Admin") $type = "Faculty";

    $salt = get_salt($password);

	$salted_pass = $password . $salt;

	$sql = "INSERT INTO user_data SET username='" . base64_encode($username) .

	       "', pass='" . md5($salted_pass) . "', salt='" . base64_encode($salt) . "', " .

	       "user_type='" . base64_encode($type) . "';";

	if(mysql_query($sql))

	{

	    $array['userID'] = mysql_insert_id();

	    $array['type'] = $type;

	    $array['new'] = true; //flag so user is sent to user data form

	    return $array;

	}

	else return "Username already in use";	

}

//adds new user when ldap is off

function add_new_user($form)

{

	//generate salt

	$salt = get_salt($form['pass1']);

	//append to password

	$salted_pass = $form['pass1'] . $salt;

	//setup names with first letter capitalized and the rest lowercase

	$form['lname'] = strtoupper(substr($form['lname'], 0, 1)) . strtolower(substr($form['lname'], 1));

	$form['fname'] = strtoupper(substr($form['fname'], 0, 1)) . strtolower(substr($form['fname'], 1));

	$query_sql = "SELECT user_id, user_type FROM user_data WHERE username='" . base64_encode(trim($form['username'])) . ";";

	if($query_result = mysql_query($query_sql))

	{	//user is already in database

		if($row = mysql_fetch_array($query_result))

		{

			if($user_id = $row['user_id'])

			{	//user has been added to a course before logging in for the first time--Update with user's info

				if(base64_decode($row['user_type']) == "Pending")

				{

					$sql = "UPDATE user_data SET " .

						    		"fname='" . base64_encode($form['fname']) . "', " .

									"lname='" . base64_encode($form['lname']) . "', " .

									"user_type='" .  base64_encode($form['account_type']) . "'," .

									"email='" . base64_encode($form['email']) . "', " .

									"email_availability='" . base64_encode($form['email_availability']) . "', " .

									"phone='" . base64_encode($form['phone']) . "', " .

									"phone_availability='" . base64_encode($form['phone_availability']) . "', " .

									"department='" . base64_encode($form['dept']) . "', " .

									"username='" . base64_encode($form['username']) . "', " .

									"pass='" . md5($salted_pass) . "', " .

									"salt='" . base64_encode($salt) . "' " .

									"WHERE user_id=" . $user_id . ";";

				}

				//user is trying to use a username already in use

				else return "<P><H3>The user name you are trying to use is already in use.  Please use your back button and choose another user name.</H3></P>";		

			}

		}

		//brand new user

		else

		{

			$sql = "INSERT INTO user_data SET " .

				    		"fname='" . base64_encode($form['fname']) . "', " .

							"lname='" . base64_encode($form['lname']) . "', " .

							"user_type='" .  base64_encode($form['account_type']) . "'," .

							"email='" . base64_encode($form['email']) . "', " .

							"email_availability='" . base64_encode($form['email_availability']) . "', " .

							"phone='" . base64_encode($form['phone']) . "', " .

							"phone_availability='" . base64_encode($form['phone_availability']) . "', " .

							"department='" . base64_encode($form['dept']) . "', " .

							"username='" . base64_encode($form['username']) . "', " .

							"pass='" . md5($salted_pass) . "', " .

							"salt='" . base64_encode($salt) . "';";

		}

		//provide feedback

		if($result = mysql_query($sql))

		{

		    //let the user know and tell them what was put in

		    $return_string = "<P><H2>" . $form['fname'] . " " . $form['lname'] . " has been registered for virtuaGrades.</H2></P>" .

		    				 "<P>The following information was posted as a result of the registration for virtuaGrades:</P>" .

			"First name:      " . $form['fname'] .

			"<BR>Last name:       " . $form['lname'] .

			"<BR>Email:           " . $form['email'] .

			"<BR>Account Type=    " . $form['account_type'] .

			"<BR>Department:      " . $form['dept'] .

			"<BR>Username:        " . $form['username'] .

			"<BR>Password:         " . $form['pass1'] .

			"<BR><P>You may now login to virtuaGrades.</P></BR>";

  		}

  		//this should not happen since it was checked above, but as a backup

  		else

  		{

		  	if(mysql_errno() == 1062) {

	  			$return_string = "<P>The user name you are trying to use is already in use.  Please use your back button and choose another user name";

	  		}

	  		else

	  		{

	  	  		$return_string = "<P>Error adding new user: " . mysql_error() . "</P>";

	  		}

  		}  		

	}

	else

	{

		$return_string = "<P>Error adding new user: " . mysql_error() . "</P>";

	}

	return $return_string;

	

}

function update_user($form, $ldap_use)

{

    extract($form); //from user data form

    if($result = mysql_query("SELECT username FROM user_data WHERE user_id=" . $userID . ";"))

    {

        if($row = mysql_fetch_assoc($result)) $old_username = base64_decode($row['username']);

    }

    $form['lname'] = strtoupper(substr($form['lname'], 0, 1)) . strtolower(substr($form['lname'], 1));

	$form['fname'] = strtoupper(substr($form['fname'], 0, 1)) . strtolower(substr($form['fname'], 1));

    $sql = "UPDATE user_data SET " .

		   "fname='" . base64_encode($fname) . "', " .

		   "lname='" . base64_encode($lname) . "', " .

		   "user_type='" . base64_encode($account_type) . "', " .									

		   "email='" . base64_encode($email) . "', " .

		   "email_availability='" . base64_encode($email_availability) . "', " .

		   "phone='" . base64_encode($phone) . "', " .

		   "phone_availability='" . base64_encode($phone_availability) . "', " .

		   "department='" . base64_encode($dept) . "' ";

	//do not update usernames when ldap is on

	if(!$ldap_use && $username <> $old_username) $sql .= ", username='" . base64_encode($username) . "' ";							

	$sql .=	"WHERE user_id=" . $userID . ";";

	

	if($result = mysql_query($sql))

	{

	    return "<H2>Update Successful!</H2>";

	}

	

	else return "<H2>Update Unsuccessful</H2>!";

}

//updates user password

function update_password($userID, $oldPass, $newPass)

{

    $sql = "SELECT salt, pass FROM user_data WHERE user_id=" . $userID . ";";

    if($result = mysql_query($sql))

    {

        if($row = mysql_fetch_assoc($result))

        {

            if(md5($oldPass . base64_decode($row['salt'])) == $row['pass'])

            {                 

                $salt = get_salt($newPass);

                $sql = "UPDATE user_data SET pass='" . md5($newPass . $salt) . "', " .

                       "salt='" . base64_encode($salt) . "' WHERE user_id=" . $userID . ";";

                if($result = mysql_query($sql))

            	{

            	    return "<H2>Password Update Successful!</H2>";

            	}

            	else return "<H2>Password Update Unsuccessful</H2>!" . $sql;

            }

            else return "<H2>The OLD password you entered is INCORRECT!</H2>";

        }

        else return "<H2>Password Update Unsuccessful</H2>!" . $sql;

    }	

	else return "<H2>Password Update Unsuccessful</H2>!" . $sql;

}

//separate function to validate a password in database

function validate_password($password, $userID)

{

	$sql = "SELECT salt, pass FROM user_data WHERE user_id=" . $userID . ";";

	if($result = mysql_query($sql))

	{

		if($row = mysql_fetch_assoc($result))

		{

			if(md5($password . base64_decode($row['salt'])) <> $row['pass'])

			{

				$salt = get_salt($password);

				mysql_query("UPDATE user_data SET pass='" . md5($password . $salt) .

							"', salt='" . base64_encode($salt) . "' WHERE user_id=$userID;" );

			}

		}

	}

}

//everytime a faculty user logs in, see if that user_id is loaded against a course

//which makes it a dual account--precludes letting users specify their account type

//when ldap is on

function check_for_dual($username)

{

	$sql = "SELECT student_id FROM course_student WHERE student_id=" . $userID . ";";

	if($result = mysql_query($sql))

	{

		if($row = mysql_fetch_assoc($result))

		{

			$sql = "UPDATE user_data SET user_type='" . base64_encode("Dual") . "' WHERE user_id=" . $userID . ";";

			mysql_query($sql);

			$dual = true;

		}

		else $dual = false;

	}

	return $dual;

}

############################## Semester Functions #######################################################

//returns the string representation of the numerical semester_id

function get_semester($semesterID, $semester_parameters)

{

	$year = substr($semesterID, 0, 4);

	$semester = substr($semesterID, 5, 1);

	//see sys_params_inc.php

	return $semester_parameters[$semester]['name'] . " " . $year;	

}

//returns all semesters for which a course is loaded

function get_available_semesters($semester_parameters)

{

	$query_sql = "SELECT DISTINCT semester FROM course ORDER BY semester DESC;";

	$result = mysql_query($query_sql);

	if($result)

	{

		while($row = mysql_fetch_assoc($result))

		{

			$array[$row['semester']] = get_semester($row['semester'], $semester_parameters);

		}

	}

	return $array;

}

//returns semester_id of current semester in relation to now

function get_current_semester($semester_parameters)

{

    $last_semester = count($semester_parameters);

	$Year = Date("Y", time());

	$Month = Date("m", time());

	$Day = Date("d", time());

	if($Day < 10) $Day = "0" . $Day;	

	$Date = $Month . $Day;

	if($Date >= $semester_parameters[$last_semester]['start_date']) return $Year . "0" . $last_semester;

	else

	{

    	for ($semester = 1; $semester < count($semester_parameters); $semester++)

    	{

    	    if ($Date >= $semester_parameters[$semester]['start_date'])

    	    {  

    	        if($Date <= $semester_parameters[$semester + 1]['start_date']) return $Year . "0" . $semester;

    	        else return $Year . "0" . $semester + 1;

    	    }    	    

    	}

	}

}



############################ Course data Functions ###############################################################

//returns an array with details of a course

function get_course_details($courseID)

{

	if($courseID)

	{

		$sql = "SELECT * FROM course WHERE course_id = " . $courseID;

		$result = mysql_query($sql);

		return mysql_fetch_assoc($result);

	}

	else return 0;

}

//updates details in database

function update_course_details($courseID, $form)

{

	$course_update_sql = "UPDATE course SET course_prefix='" . strtoupper($form['prefix']) .

		   "', course_number ='" . strtoupper($form['number']) .

		   "', section='" . strtoupper($form['section']) .

		   "', title='" . $form['title'] .

		   "', crn='" . strtoupper($form['crn']) .

		   "' WHERE course_id = " . $courseID . ";";

	$result = mysql_query($course_update_sql);

}

//inserts new course in database

function add_course($semesterID, $facultyID, $form)

{

	$sql = "INSERT into course SET course_prefix='" . strtoupper($form['prefix']) .

		   "', course_number ='" . strtoupper($form['number']) .

		   "', semester=" . $semesterID .

		   ", section='" . strtoupper($form['section']) .

		   "', title='" . $form['title'] .

		   "', crn='" . strtoupper($form['crn']) .

		   "', faculty_id=" . $facultyID . ";";

	$result = mysql_query($sql);

	if($courseID = mysql_insert_id())

	{

		for($id = 1; $id < 4; $id++)

		{   //insert the default grading scheme references for this course

			$default_scheme_sql = "INSERT INTO grading_scheme SET course_id=" . $courseID .

							  ", type_id=" . $id . ";";

			mysql_query($default_scheme_sql);

		}

		return $courseID;

	}

	else return 0;

}

//deletes course from database

function remove_course($courseID)

{

	$remove_course_sql = "DELETE from course WHERE course_id=" . $courseID;

	mysql_query($remove_course_sql);

}



###################################### Assignment Data Functions #################################################

//inserts a new assignment

function add_assignment($courseID, $array)

{

	$sql = "INSERT INTO assignment SET " .

			"course_id =" . $courseID . ", " .

			"assignment_type=" . $array['type'] . ", " .

			"date_added=CURDATE(), " .

			"date_due='" . $array['date'] . "', " .

			"title='" . $array['title'] . "', " .

			"points_possible=" . $array['points'] . ";";

	mysql_query($sql);

}

//deletes an assignment from database

function remove_assignment($assignmentID)

{

	$sql = "DELETE FROM assignment WHERE assignment_id=" . $assignmentID . ";";

	mysql_query($sql);

}



function get_assignment_details($assignmentID)

{

	$sql = "SELECT * FROM assignment, assignment_type WHERE " .

		   "assignment_type.assignment_type_id=assignment.assignment_type " .

		   "AND assignment_id=" . $assignmentID;

	

	if($result = mysql_query($sql))

	{

		$array = mysql_fetch_assoc($result);

		$array['date_added'] = substr($array['date_added'], 5, 2) . " / " .

							   substr($array['date_added'], 8, 2) . " / " .

							   substr($array['date_added'], 0, 4);

		$array['year_due'] = substr($array['date_due'], 0, 4);

		$array['month_due'] = substr($array['date_due'], 5, 2);

		$array['day_due'] = substr($array['date_due'], 8, 2);

		$array['date_due'] = $array['month_due'] . " / " . $array['day_due'] . " / " . $array['year_due'];

	}

	return $array;

}



function update_assignment_details($assignmentID, $array)

{

	$sql = "UPDATE assignment SET assignment_type=" . $array['type'] .

		   ", date_due='" . $array['date'] .

		   "', title='" . $array['title'] .

		   "', points_possible=" . $array['points'] . 

		   " WHERE assignment_id=" . $assignmentID . ";";

	mysql_query($sql);

}

//returns an array with details of an assignment

function get_assignment_data($assignmentID)

{

	$sql = "SELECT points from grade WHERE assignment_id=" . $assignmentID . " ORDER BY points ASC;";

	if($result = mysql_query($sql))

	{

		while($row = mysql_fetch_assoc($result))

		{

			$array[$row['points']] += 1;

		}

	}

	return $array;

}

//Returns an array with the types and numbers of each assignment for a course

function get_weight_matrix($courseID)

{

	$sql = "SELECT assignment_type FROM assignment WHERE course_id=" . $courseID . ";";

	if($result = mysql_query($sql))

	{

		while($row = mysql_fetch_assoc($result))

		{

			$type[$row['assignment_type']] += 1;

		}

	}

	$sql = "SELECT assignment_id, assignment_type, weight FROM assignment, assignment_type " .

		   "WHERE assignment.assignment_type = assignment_type.assignment_type_id AND " .

		   "course_id=" . $courseID . ";";

	if($result = mysql_query($sql))

	{

		while($row = mysql_fetch_array($result))

		{

			$weight_matrix[$row['assignment_id']] = number_format($row['weight'] / $type[$row['assignment_type']], 1);

		}

	}

	return $weight_matrix;

}

//returns an array of assignments for the specified course

function get_assignment_list($courseID)

{

	$sql = "SELECT * FROM assignment, assignment_type WHERE " .

		   "assignment_type.assignment_type_id=assignment.assignment_type " .

		   "AND course_id=" . $courseID;

	$result = mysql_query($sql);

	if($result)

	{

		while($row = mysql_fetch_assoc($result))

		{

			$array[$row['assignment_id']] = $row;

			$array[$row['assignment_id']]['date_added'] = substr($row['date_added'], 5, 2) . "/" .

							   							  substr($row['date_added'], 8, 2) . "/" .

							   							  substr($row['date_added'], 0, 4);

			$array[$row['assignment_id']]['date_due'] = substr($row['date_due'], 5, 2) . "/" .

							   							substr($row['date_due'], 8, 2) . "/" .

							   							substr($row['date_due'], 0, 4);

		}

	}

	return $array;

}



############################# Grade Scheme Functions #########################################################

//returns an array with the grading scheme for a course

function get_scheme($courseID)

{

	if($courseID)

	{

		$sql = "SELECT assignment_type_id, type, weight FROM assignment_type, grading_scheme " .

		       "WHERE assignment_type.assignment_type_id = grading_scheme.type_id AND course_id=" . $courseID .

		       " ORDER BY weight DESC";		

		if($result = mysql_query($sql))

		{

			while($row = mysql_fetch_assoc($result))

			{

				$array[$row['assignment_type_id']]['type'] = $row['type'];

				$array[$row['assignment_type_id']]['weight'] = $row['weight'];				

			}

			

		}

	}

	return $array;

}

//stores grading scheme currently in form in an array and returns it

//used during changing of a grading scheme

function capture_scheme($form, $err)

{

	$new_index = $_GET['num'] * -1;

	foreach ($form as $key => $value)

	{

		if(substr($key, 0, 4) == "type")

		{

			$index = substr($key, 4);

			$array[$index]['type'] = $form['type'.$index];

		}

		elseif(substr($key, 0, 6) == "weight")

		{

			$index = substr($key, 6);

			$array[$index]['weight'] = $form['weight'.$index]/100;

		}

		if(!$err)

		{

			if(substr($key, 0, 7) == "newType")

			{

				$array[$new_index]['type'] = $form['newType'];

			}

			if(substr($key, 0, 9) == "newWeight")

			{

				$array[$new_index]['weight'] = $form['newWeight']/100;

			}		

		}

	}

	return $array;

}

//updates a grading scheme

function update_grade_scheme($courseID, $newScheme)

{

	$original_scheme = get_scheme($courseID);

	$assignments_sql = "SELECT DISTINCT assignment_type FROM assignment WHERE course_id=" . $courseID . ";";

	$result = mysql_query($assignments_sql);

	if($result)

	{

		while($row = mysql_fetch_assoc($result))

		{   //set a flag for each assignment type used from the original scheme

			$assignment_array[$row['assignment_type']] = 1;

		}

	}

	//check to see if any existing assignments will be affected by a deletion

	//or modification of an existing type in the original 

	foreach ($original_scheme as $index => $type_array)

	{

		if($newScheme[$index]['type'] <> $type_array['type'] && $assignment_array[$index] == 1) return $type_array['type'];

	}

	foreach($newScheme as $index => $type_array)

	{  //see if this particular type-weight combination exists

		$find_type_sql = "SELECT assignment_type_id FROM assignment_type " .

						     "WHERE type='" . $type_array['type'] . "' " . 

						     "AND weight=" . $type_array['weight']/100 . ";";

		//or insert a new combination

		$new_type_sql = "INSERT INTO assignment_type SET type='" . $type_array['type'] .

								  "', weight=" . $type_array['weight']/100 . ";";

								  

		if($result = mysql_query($find_type_sql))

		{

			if($row = mysql_fetch_assoc($result))

			{

				$type_id = $row['assignment_type_id'];

			}

			else

			{

				if($result = mysql_query($new_type_sql))

				{

					$type_id = mysql_insert_id();

				}

			}

		}

		//types from the old scheme

		if($index > 0)

		{

			//check if the type has changed

			if($type_array['type'] <> $original_scheme[$index]['type'] || $type_array['weight'] <> $original_scheme['weight'])

			{

				$update_sql = "UPDATE grading_scheme SET type_id=" . $type_id .

							  " WHERE course_id=" . $courseID . " AND type_id=" . $index . ";";

				mysql_query($update_sql);

				//update existing assignments with new weight

				$update_assignment_sql = "UPDATE assignment SET assignment_type=" . $type_id .

									 " WHERE course_id=" . $courseID . " AND assignment_type=" . $index . ";";

				mysql_query($update_assignment_sql);

				$original_scheme[$index] = null;

			}

		}

		else

		{//insert new types

			$insert_sql = "INSERT INTO grading_scheme SET course_id=" . $courseID .

						  ", type_id=" . $type_id . ";";

			$result = mysql_query($insert_sql);

		}

	}

	//delete any remaining types from original scheme

	foreach ($original_scheme as $index => $type_array)

	{

		if($type_array)

		{

			$remove_sql = "DELETE FROM grading_scheme WHERE course_id=" . $courseID .

					  " AND type_id=" . $index . ";";

			mysql_query($remove_sql);

		}

	}

	//no errors updating grade scheme

	return null;

}



######################################## Miscelaneous Functions #############################################

//returns the concatenated first name and last name of the specified user

function get_name($userID)

{

	$sql = "SELECT fname, lname from user_data WHERE user_id = " . $userID;

	$result = mysql_query($sql);

	if($result)

	{

		if($row = mysql_fetch_assoc($result)) $name = base64_decode($row['fname']) . " " . base64_decode($row['lname']);

	}

	return $name;

}

//returns a string constructed from the course prefix and number

function get_course_string($courseID)

{

	$sql = "SELECT course_prefix, course_number FROM course WHERE course_id=" . $courseID . ";";

	if($result = mysql_query($sql))

	{

		if($row = mysql_fetch_assoc($result))

		{

			$string = $row['course_prefix'] . "  " . $row['course_number'];

		}

	}

	return $string;

}

//returns an array of all courses being taught by the specified faculty for the specified semester

function get_current_courses($userID, $semesterID)

{

	$sql = "SELECT * from course WHERE faculty_id = " . $userID .

		   " AND semester = " . $semesterID . " ORDER BY course_prefix, course_number;";

	$result = mysql_query($sql);

	if($result) 

	{

		while($row = mysql_fetch_assoc($result))

		{

			$array[$row['course_id']] = $row;

		}

	}

	return $array;

}

//returns an array of all the courses the specified student is loaded into for the specified semester

function get_student_courses($userID, $semesterID)

{

	$sql = "SELECT * from course, course_student WHERE course.course_id = course_student.course_id " .

			"AND student_id = " . $userID .

		   " AND semester = " . $semesterID . " ORDER BY course_prefix, course_number;";

	$result = mysql_query($sql);

	if($result) 

	{

		while($row = mysql_fetch_assoc($result))

		{

			$array[$row['course_id']] = $row;

		}

	}

	return $array;

}

//returns maximum possible total points for a course

function get_course_max_points($courseID)

{

	$sql = "SELECT points_possible FROM assignment WHERE course_id=" . $courseID . ";";

	if($result = mysql_query($sql))

	{

		while($row = mysql_fetch_assoc($result))

		{

			$max_points += $row['points_possible'];

		}

	}

	return $max_points;	

}

//returns maximum possible total points for a course at their individual weighted values

function get_course_max_weighted_points($courseID, $weightMatrix)

{

	$sql = "SELECT assignment_id, points_possible FROM assignment WHERE course_id=" . $courseID . ";";

	if($result = mysql_query($sql))

	{

		while($row = mysql_fetch_assoc($result))

		{

			$max_points += $row['points_possible'] * $weightMatrix[$row['assignment_id']];

		}

	}

	return $max_points;	

}

//returns an array of overall scores for a course by student_id

function get_course_grades($courseID)

{

	$weight_matrix = get_weight_matrix($courseID);

	$max_weighted_points = get_course_max_weighted_points($courseID, $weight_matrix);

	

	$sql = "SELECT student_id, assignment.assignment_id, points FROM grade, assignment WHERE " .

			"grade.assignment_id = assignment.assignment_id AND " .

			"assignment.course_id=" . $courseID . ";";

	if($result = mysql_query($sql))

	{

		while($row = mysql_fetch_assoc($result))

		{

			$array[$row['student_id']] += number_format( (($row['points'] * $weight_matrix[$row['assignment_id']]) / $max_weighted_points) * 100, 1);

		}

	}

	return $array;	

}



//returns all assignment-grade pairs for the specified student and specified course

function get_student_grades($courseID, $studentID)

{

	$sql = "SELECT grade.assignment_id, grade.points FROM grade, assignment, assignment_type WHERE " .

		   "assignment_type.assignment_type_id=assignment.assignment_type " .

		   "AND grade.assignment_id = assignment.assignment_id " . 

		   "AND assignment.course_id=" . $courseID .

		   " AND student_id=" . $studentID . ";";

	$result = mysql_query($sql);

	if($result)

	{

		while($row = mysql_fetch_assoc($result))

		{

			$array[$row['assignment_id']] = $row;

		}

	}

	return $array;

}

//formats a date from the database into MM/DD/YYYY

function format_date($date)

{

	$month = substr($date, 5, 2);

	$day = substr($date, 8, 2);

	$year = substr($date, 0, 4);

	return $month . "/" . $day . "/" . $year;

}

//associates a student with a course

function add_student($courseID, $username, $ldap)

{

		$query_sql = "SELECT user_id FROM user_data WHERE username='" . base64_encode($username) . "';";

		if($query_result = mysql_query($query_sql))

		{

			if($row = mysql_fetch_assoc($query_result))

			{

				if($student_id = $row['user_id'])

				{

					$insert_sql = "INSERT into course_student SET course_id =" . $courseID .

						   ", student_id=" . $student_id . ";";

					$insert_result = mysql_query($insert_sql);

				}

			}		

			else

			{

				$insert_pending = "INSERT into user_data SET username='" . base64_encode($username) .

								  "', user_type='" . base64_encode("Pending") . "';";

				if(mysql_query($insert_pending)) 

				{

					$student_id = mysql_insert_id();

					$insert_sql = "INSERT into course_student SET course_id =" . $courseID .

					        	   ", student_id=" . $student_id . ";";

					$insert_result = mysql_query($insert_sql);

				}				

			}			

		}

}

//disassociates a student with a course

function remove_student($studentID, $courseID)

{

	if($studentID)

	{

		$sql = "DELETE FROM course_student WHERE student_id=" . $studentID . 

			   " AND course_id=" . $courseID . ";";

			   

		mysql_query($sql);

		$sql = "DELETE FROM grade WHERE student_id=" . $studentID . " AND course_id=" . $courseID . ";";

		mysql_query($sql);

	}	

}

//returns array containing a users data

function get_user_details($studentID)

{

	$sql = "SELECT * FROM user_data WHERE user_id=" . $studentID . ";";

	

	if($result = mysql_query($sql))

	{

		if($row = mysql_fetch_assoc($result))

		{

			$array['username'] = base64_decode($row['username']);

			$array['fname'] = base64_decode($row['fname']);

			$array['lname'] = base64_decode($row['lname']);

			$array['email'] = base64_decode($row['email']);

			$array['email_avail'] = base64_decode($row['email_availability']);

			$array['phone'] = base64_decode($row['phone']);

			$array['phone_avail'] = base64_decode($row['phone_availability']);

			$array['department'] = base64_decode($row['department']);			

		}

	}

	return $array;

}

//same as get_user except for the format

function get_faculty_details($courseID)

{

	$sql = "SELECT fname, lname, email, email_availability, phone, phone_availability " .

			"FROM user_data, course WHERE user_data.user_id = course.faculty_id AND " .

			"course.course_id=" . $courseID . ";";

	if($result = mysql_query($sql))

	{

		if($row = mysql_fetch_assoc($result))

		{

			$array['name'] = base64_decode($row['fname']) . " " . base64_decode($row['lname']);

			$array['email'] = base64_decode($row['email']);

			$array['email_avail'] = base64_decode($row['email_availability']);

			$array['phone'] = base64_decode($row['phone']);

			$array['phone_avail'] = base64_decode($row['phone_availability']);			

		}

	}

	return $array;

}

//returns an array of students loaded in the specified course

//used for faculty reference for grading

function get_students($courseID)

{

	$sql = "SELECT user_id, username, user_type, email, fname, lname FROM user_data, course_student WHERE " .

		   "user_data.user_id = course_student.student_id AND course_student.course_id=" . $courseID .

		   " ORDER BY lname, fname;";

	$result = mysql_query($sql);

	if($result)

	{

		while($row = mysql_fetch_assoc($result))

		{

			if(base64_decode($row['user_type']) == "Pending") $array[$row['user_id']] = base64_decode($row['username']);

			else $array[$row['user_id']] = base64_decode($row['lname']) . ", " . base64_decode($row['fname']);

		}

	}

	if($array) asort($array);

	return $array;

}

//same principle as get_students--this is student's view of student list

function get_student_list($courseID)

{

	$sql = "SELECT * FROM user_data, course_student WHERE " .

		   "user_data.user_id = course_student.student_id AND course_student.course_id=" . $courseID .

		   " ORDER BY lname, fname;";

	$result = mysql_query($sql);

	if($result)

	{

	    $index = 0;

		while($row = mysql_fetch_assoc($result))

		{

			if(base64_decode($row['user_type']) == "Pending") $array[$index]['lname'] = "ZZZZ";

			else

			{

			    $array[$index]['lname'] = base64_decode($row['lname']);

			    $array[$index]['fname'] = base64_decode($row['fname']);

			    $array[$index]['major'] = base64_decode($row['department']);

			    if(base64_decode($row['email_availability']) == "students" || base64_decode($row['email_availability']) == "both")

			    {

			        $array[$index]['email'] = base64_decode($row['email']);

			    }

			    if(base64_decode($row['phone_availability']) == "students" || base64_decode($row['phone_availability']) == "both")

			    {

			        $array[$index]['phone'] = base64_decode($row['phone']);

			    }

			}

			$lnames[$index] = $array[$index]['lname'];

			$index++;		    

		}

	}

	usort($array, "compare");

	return $array;

}

//comparison function used for usort on student list

function compare($a, $b) 

{   

   return strcmp($a['lname'], $b['lname']);

}



//returns an array of all grades for all students for the specified assignment

function get_assignment_grades($assignmentID)

{

	$sql = "SELECT * FROM grade WHERE assignment_id=" . $assignmentID . ";";

	if($result = mysql_query($sql))

	{

		while($row = mysql_fetch_assoc($result))

		{

			$array[$row['student_id']] = $row['points'];

		}

	}

	return $array;

}

//change a grade

function update_grade($assignmentID, $studentID, $points)

{

	

	$remove_sql = "DELETE FROM grade WHERE assignment_id=" . $assignmentID . 

				  " AND student_id=" . $studentID . ";";

	mysql_query($remove_sql);

	

	if($points <> null)

	{		

		$insert_sql = "INSERT INTO grade SET points='" . $points .

					  "', assignment_id=". $assignmentID . ", student_id=" . $studentID . ";";

		mysql_query($insert_sql);		

	}

}



############################# Administration Functions ####################################################



//get all user's currently assigned as admins

function get_admins()

{

    if($result = mysql_query("SELECT * FROM user_data WHERE is_admin=1"))

    {

        while($row = mysql_fetch_array($result))

        {

            $array[$row['user_id']]['username'] = base64_decode($row['username']);

            $array[$row['user_id']]['fname'] = base64_decode($row['fname']);

			$array[$row['user_id']]['lname'] = base64_decode($row['lname']);

			$array[$row['user_id']]['department'] = base64_decode($row['department']);

			$array[$row['user_id']]['type'] = base64_decode($row['user_type']);

        }

    }

    return $array;

}



function add_admin($userID)

{

    mysql_query("UPDATE user_data SET is_admin=1 WHERE user_id=" . $userID . ";");

}



function revoke_admin($userID)

{

    mysql_query("UPDATE user_data SET is_admin=0 WHERE user_id=" . $userID . ";");

}

//resets a user's password to the default specified in sys_params

//usually not used when ldap is enabled

function reset_account($userID, $reset_password)

{

    $salt = get_salt($reset_password);

    $sql = "UPDATE user_data SET pass='" . md5($reset_password . $salt) . "', " .

            "salt='" . base64_encode($salt) . "' WHERE user_id=" . $userID . ";";

    if($result = mysql_query($sql)) return 1;

    else return 0;

}

//removes a user from the database

//if faculty--will delete all courses, assignments, and grading schemes

//if student--will delete all course_student records

function delete_account($userID)

{

    $sql = "DELETE FROM user_data WHERE user_id=" . $userID . ";";

    if(mysql_query($sql)) return 1;

    else return 0;

}

//searches by either user id, username, or last name

function search_users($id, $field)

{

	switch ($field)

	{

		case "user_id":   $sql = "SELECT user_id, fname, lname, department, username FROM user_data WHERE " .

               					"user_id=" . $id . ";";

             			  break;

        case "username":  $sql = "SELECT user_id, fname, lname, department, username FROM user_data WHERE " .

                				 "username='" . base64_encode(strtolower($id)) . "';";

                		  break;

        case "lname":	  $lname = strtoupper(substr($id, 0, 1)) . strtolower(substr($id, 1));

        				  $sql = "SELECT user_id, fname, lname, department, username FROM user_data WHERE " .

                				 "lname='" . base64_encode($lname) . "';";

	}

    if($result = mysql_query($sql))

    {

        while($row = mysql_fetch_assoc($result))

        {

            $array[$row['user_id']]['lname'] = base64_decode($row['lname']);

            $array[$row['user_id']]['fname'] = base64_decode($row['fname']);

            $array[$row['user_id']]['username'] = base64_decode($row['username']);

            $array[$row['user_id']]['department'] = base64_decode($row['department']);

        }

    }

    return $array;          

}

//gets a number of different statistics on the database--called from admin_home

function get_db_stats($semester_parameters)

{

    

    $size_sql = "SHOW TABLE STATUS;";

    if($result = mysql_query($size_sql))

    {

        $size = 0;

        while ($data = mysql_fetch_array($result))

        {

              $size += $data['Data_length'] + $data['Index_length'];

        }

        $size /= 1024;

    }

    $stats['size'] = $size;

    

    $admin_sql = "SELECT COUNT(*) AS users FROM user_data WHERE is_admin=1;";

    if($result = mysql_query($admin_sql))

    {

        if ($data = mysql_fetch_array($result))

        {

              $user_count = $data['users'];

        }

    }

    $stats['admins'] = $user_count;

    

    $faculty_sql = "SELECT COUNT(*) AS users FROM user_data WHERE user_type='" . base64_encode("Faculty") .

                   "' OR user_type='" . base64_encode("Dual") . "';";

    if($result = mysql_query($faculty_sql))

    {

        if ($data = mysql_fetch_array($result))

        {

              $user_count = $data['users'];

        }

    }

    $stats['faculty'] = $user_count;

    

    $student_sql = "SELECT COUNT(*) AS users FROM user_data WHERE user_type='" . base64_encode("Student") .

                   "' OR user_type='" . base64_encode("Dual") . "';";

    if($result = mysql_query($student_sql))

    {

        if ($data = mysql_fetch_array($result))

        {

              $user_count = $data['users'];

        }

    }

    $stats['students'] = $user_count;

    

    $user_sql = "SELECT COUNT(*) AS users FROM user_data;";

    if($result = mysql_query($user_sql))

    {

        if ($data = mysql_fetch_array($result))

        {

              $user_count = $data['users'];

        }

    }

    $stats['users'] = $user_count;

    

    $course_sql = "SELECT COUNT(*) AS courses FROM course;";

    if($result = mysql_query($course_sql))

    {

        if ($data = mysql_fetch_array($result))

        {

              $course_count = $data['courses'];

        }

    }

    $stats['courses'] = $course_count;

    

    $semester_sql = "SELECT DISTINCT semester FROM course ORDER BY semester;";

    if($result = mysql_query($semester_sql))

    {

        while($data = mysql_fetch_array($result))

        {

              $semesters[] += $data['semester'];

        }

        if($semesters) sort($semesters);

    }

    $stats['semester'] = get_semester($semesters[0], $semester_parameters);

    

   return $stats;    

}

//gets all course prefixes for courses loaded--called from course_admin

function get_course_prefixes()

{

	if($result = mysql_query("SELECT DISTINCT course_prefix from course ORDER BY course_prefix;"))

	{

		while($row = mysql_fetch_assoc($result))

		{

			$array[] .= $row['course_prefix'];

		}

	}

	return $array;

}

//gets all course numbers for courses loaded--called from course_admin

function get_course_numbers()

{

	if($result = mysql_query("SELECT DISTINCT course_number from course ORDER BY course_number;"))

	{

		while($row = mysql_fetch_assoc($result))

		{

			$array[] .= $row['course_number'];

		}

	}

	return $array;

}

//gets all faculty data for faculty with courses loaded--called from course_admin

function get_course_faculty()

{

	$sql = "SELECT DISTINCT faculty_id, fname, lname from course, user_data WHERE course.faculty_id = user_data.user_id ORDER BY lname, fname;";

	if($result = mysql_query($sql))

	{

		while($row = mysql_fetch_assoc($result))

		{

			$array[$row['faculty_id']] = base64_decode($row['lname']) . ", " . base64_decode($row['fname']);

		}

	}

	return $array;

}

//searches for courses based on one or more specified fields--called from course_admin

function search_courses($array)

{

	$sql = "SELECT course_id, course_prefix, course_number, crn, title, semester, section, " .

			"lname FROM course, user_data WHERE course.faculty_id = user_data.user_id";

	if($array['semester'] <> "ANY") $sql .= " AND semester=" . $array['semester'];

	if($array['prefix'] <> "ANY") $sql .= " AND course_prefix='" . $array['prefix'] . "'";

	if($array['number'] <> "ANY") $sql .= " AND course_number='" . $array['number'] . "'";

	if($array['faculty'] <> "ANY") $sql .= " AND faculty_id=" . $array['faculty'];

	$sql .= " ORDER BY semester, course_prefix, course_number, title;";

	if($result = mysql_query($sql))

	{

		while($row = mysql_fetch_assoc($result))

		{

			$course[$row['course_id']] = $row;

			$course[$row['course_id']]['lname'] = base64_decode($row['lname']);

		}

	}

	return $course;

}

//deletes one or more courses--called from course_admin

function delete_courses($array)

{

	$sql = "DELETE FROM course WHERE course_id=";

	for ($index = 0; $index < count($array) - 1; $index++)

	{

		$sql .= $array[$index] . " OR course_id=";

	}

	$sql .= $array[count($array) - 1] . ";";

	mysql_query($sql);

}

?>