<?php

include_once("sys_include.inc.php");

include_once("jpGraph/jpgraph.php");

include_once("jpGraph/jpgraph_bar.php");



if(isset($_GET['assignmentID'])) //this is an assignment histogram

{

	$data=get_assignment_data($_GET['assignmentID']);

	$graph_title = "Assignment Histogram";

}

elseif(isset($_GET['courseID']))  //this is a course histogram

{

	$grades=get_course_grades($_GET['courseID']);

	array_multisort($grades);  //sort scores ascending

	//put grades in histogram format in the array

	//the index is the score, the value is the number of that score

	foreach ($grades as $value)

	{

		$data[ceil($value)] += 1;

	}

	$graph_title = "Course Histogram";

}

	

if($data)

{

	foreach ($data as $key => $value)

	{

		$datay[] += $value;

		$datax[] += $key;

	}

	// Create the graph--automatically create cache names

	if(isset($_GET['large'])) $graph = new Graph(600,400,"auto");

	else $graph = new Graph(400,300,"auto");    

	$graph->SetScale("textint");

	// Add a drop shadow

	$graph->SetShadow();

	$graph->SetMarginColor("lightblue");

	// Adjust the margin a bit to make more room for titles

	$graph->img->SetMargin(30,20,20,40);

	$graph->xaxis->SetTickLabels($datax);	

	// Create a bar pot

	$bplot = new BarPlot($datay);	

	// Setup color for gradient fill style 

	$bplot->SetFillGradient("navy","lightsteelblue",GRAD_VER);	

	// Set color for the frame of each bar

	$bplot->SetColor("navy");

	$graph->Add($bplot);	

	// Setup the titles

	$graph->title->Set($graph_title);

	$graph->xaxis->title->Set("Points Scored");

	$graph->yaxis->title->Set("Frequency");

	$graph->yaxis->SetTitleMargin(15);

	//set fonts for titles

	$graph->title->SetFont(FF_FONT1,FS_BOLD);

	$graph->yaxis->title->SetFont(FF_FONT1,FS_BOLD);

	$graph->xaxis->title->SetFont(FF_FONT1,FS_BOLD);

	

	// Display the graph

	$graph->Stroke();

}

?>

