<!-- building_detail.cfm v1.0 -->
<!--- 
	Name: building_detail.cfm
	Version: 1.0
	Purpose: Using data created in building_detail_data, I format the output
	   Departmants
		Services
		Points of Interest
		Schools
		Maps

Input parameters:
<-> thisBuilding

-> Datasets
   getBuildingDetails
	getMaps
	getDeptList
	getSchoolList
	getServices
	getPOI
	
Created by: Edward Wickham
Email: ewickham@gci.net
Create date: 2004/04/08

Last Edited by:
Email:
Last Edit date

Version notes:

 --->
<cfinclude template="building_detail_data.cfm">
<html>
<head>
<meta http-equiv="HandheldFriendly" content="True">
<cfoutput><title>#getBuildingDetail.name#</title></cfoutput>
</head>

<body>
<table border="0" cellpadding="1" cellpadding="1">
	<tr>
		<td valign="top">
			<cfinclude template="/avantgo_home/menubar.cfm">
		</td>
      <td valign="top">
			<table border="0" cellpadding="1">
		
				<cfoutput query="getBuildingDetail">
					<tr>
						<td><b>#name# Building</b><br>(#ucase(thisBuilding)#)</td>
					</tr>
					<tr><td>&nbsp;</td></tr>
					<cfif #description# gt "">
						<tr><td>#description#</td></tr>
						<tr><td>&nbsp;</td></tr>
					</cfif>
					<cfset building_number = #bldg_map_no#>
				</cfoutput>
				<tr><td>Map Location(s)</td></tr>
				<tr>
					<td>
						<cfoutput query="getMaps">
							<a href="../maps/map#map_id#.cfm">#location#</a>
							<cfif getMaps.recordcount gt 1 AND 
							      getMaps.currentRow LT getMaps.recordcount>, </cfif>
						</cfoutput>
						<cfoutput><p>Building Number on Map: #variables.building_number#</p></cfoutput>
					</td>
				</tr>	

				<tr><td>&nbsp;</td></tr>
            <tr>
               <td valign="top">Departments</td>
            </tr>
            <tr>
               <td>
                  <cfif getDeptList.recordcount gt 0>
                     <cfoutput query="getDeptList">
                        <a href="../departments/dept_detail.cfm?dept=#department_abbr#">#name#</a><br>
                     </cfoutput>
                  <cfelse>
                     No departments in this building.
                  </cfif>         
               </td>   
            </tr>
				<tr><td>&nbsp;</td></tr>
				<tr>
					<td valign="top">Schools</td>
				</tr>
				<tr>
					<td valign="top">
						<cfif getSchoolList.recordcount gt 0>
							<cfoutput query="getSchoolList">
								#name#<br>
							</cfoutput>					
						<cfelse>
							There are no schools in this building.
						</cfif>
					</td>
				</tr>
				<tr><td>&nbsp;</td></tr>
				<tr>
					<td valign="top">Services</td>
				</tr>
				<tr>
					<td valign="top">				
						<cfif getServiceList.recordCount gt 0>
							<cfoutput query="getServiceList">
								<a href="../services/services_detail.cfm?svc_id=#service_location_id#">#name#</a><br>
							</cfoutput>						
						<cfelse>
							There are no services in this building
						</cfif>
					</td>
				</tr>
				<tr><td>&nbsp;</td></tr>
				<tr>
					<td valign="top" nowrap>Points of Interest</td>
				</tr>
				<tr>	
					<td valign="top">				
						<cfif getPOIList.recordcount gt 0>
							<cfoutput query="getPOIList">
								<a href="../points/poi_detail.cfm?poi_id=#poi_id#">#name#</a><br>
							</cfoutput>		
						<cfelse>
							There are no Points of Interest in this building
						</cfif>
					</td>
				</tr>
			</table>
	   </td>
	</tr>
</table>
</body>
</html>
