<!-- building_detail_data.cfm v1.0 -->
<!--- 
	Name: building_detail_data.cfm
	Version: 1.0
	Purpose: I query the database for all building detail data for a chosen building. 
	In addition to information about the building itselt, it includes data about:
	   Departmants
		Services
		Points of Interest
		Schools

Input parameters:
-> cgi.SCRIPT_NAME

Dataset
   getBuildingDetails
	getMaps
	getDeptList
	getSchoolList
	getServices
	getPOI
	
Created by: Edward Wickham
Email: ewickham@gci.net
Create date: 2004/04/08

Last Edited by:
Email:
Last Edit date

Version notes:

 --->
<cfif isDefined("URL.bldg")>

	<cfset thisBuilding = URL.bldg>
	
	<cfquery name="getBuildingDetail" datasource="uaa_sgt">
		select name, description, bldg_map_no
		from building_tab a
		where building_abbr = <cfqueryparam value="#thisBuilding#" cfsqltype="cf_sql_varchar">
	</cfquery>
	
	<cfquery name="getMaps" datasource="uaa_sgt">
		select a.map_id, b.description as location
		from building_map_tab a, map_tab b
		where a.map_id = b.map_id
			and a.building_abbr = <cfqueryparam value="#thisBuilding#" cfsqltype="cf_sql_varchar">
	</cfquery>
	
	<cfquery name="getDeptList" datasource="uaa_sgt">
		select department_abbr, name
		from department_tab
		where building_abbr = <cfqueryparam value="#thisBuilding#" cfsqltype="cf_sql_varchar">
	</cfquery>

	<cfquery name="getSchoolList" datasource="uaa_sgt">
		select school_abbr, name
		from school_tab
		where building_abbr = <cfqueryparam value="#thisBuilding#" cfsqltype="cf_sql_varchar">
	</cfquery>
	
	<cfquery name="getServiceList" datasource="uaa_sgt">
		select a.service_abbr, a.name, b.service_location_id 
		from services_tab a, service_location_tab b
		where a.service_abbr = b.service_abbr
		and b.building_abbr = <cfqueryparam value="#thisBuilding#" cfsqltype="cf_sql_varchar">
	</cfquery>
	
	<cfquery name="getPOIList" datasource="uaa_sgt">
		select name, poi_id 
		from poi_tab
		where building_abbr = <cfqueryparam value="#thisBuilding#" cfsqltype="cf_sql_varchar">
	</cfquery>
</cfif>