<!-- building_data.cfm v1.0 -->
<!--- 
	Name: building_data.cfm
	Version: 1.0
	Purpose: I query the database for all building summary pages.

Input parameters:
->	[URL.mapNumber]

Dataset
   getBuildings
	
Created by: Edward Wickham
Email: ewickham@gci.net
Create date: 2004/04/06

Last Edited by:
Email:
Last Edit date

Version notes:

 --->

<cfif isDefined ("URL.mapNumber") AND url.mapNumber GT "1">

	<cfif findnocase('x',URL.mapNumber) gt 0>
		<cfset searchField = "summary_map_id">
	<cfelse>
	   <cfset searchField = "map_id">
	</cfif>
	
	<cfquery name="getMaps" datasource="uaa_sgt">
	  select description
	  from map_tab
	  where #searchField# = <cfqueryparam value="#URL.mapNumber#" cfsqltype="cf_sql_varchar">
	</cfquery>
	
	<!--- Get building information specific to this map --->
		<cfquery name="getBuildings" datasource="uaa_sgt">
		select distinct a.name, lcase(a.building_abbr) as abbr, a.bldg_map_no, b.map_id
		from building_tab a, building_map_tab b, map_tab c
		where a.building_abbr = b.building_abbr
		  and b.map_id = c.map_id
		  and c.#searchField# = <cfqueryparam value="#URL.mapNumber#" cfsqltype="cf_sql_varchar">
		order by name
		</cfquery>

<cfelse>
	<!--- Get information about all buildings --->
	<cfquery name="getBuildings" datasource="uaa_sgt" >
		select distinct a.name, lcase(a.building_abbr) as abbr, a.bldg_map_no, b.map_id
		from building_tab a, building_map_tab b
		where a.building_abbr = b.building_abbr
		order by name
	</cfquery>
</cfif>

