<!-- services_summary.cfm v1.0 -->

<!--- 
Name: services_summary.cfm
Version: 1.0
Purpose: I format the output of any request for a summary of services, whether the reference
   is to a particular map, a particular service or all available services. Where appropriate
	I dynamically construct URL links to relevant pages.
	
Input parameters:
-> [URL.mapNumber] optional
-> [URL.svc] optional

Included pages:
   services_data.cfm
	menubar.cfm
	
Datasets
	[getMaps] optional - built by services_data include
	getServices - built by services_data include
	
Created by: Edward Wickham
Email: ewickham@gci.net
Create date: 2004/04/08

Last Edited by:
Email:
Last Edit date:

Version notes:
--->

<cfinclude template="services_data.cfm">

<cfif isDefined("getMaps.description")>
	<cfset pageName = '#getMaps.description# Services'>
<cfelse>
   <cfset pageName = "Services Index">
</cfif>
<html>
<head>
   <cfoutput><title>#pageName#
	</title></cfoutput>
	<meta http-equiv="HandheldFriendly" content="True">
</head>
<body>

<table border="0" cellpadding="1" cellpadding="1">
	<tr>
		<td valign="top">
			<cfinclude template="/avantgo_home/menubar.cfm">
		</td>
      <td valign="top">
			<b><cfoutput>#pageName#</cfoutput></b><br>
			<cfif getServices.recordcount gt 0>
				<cfoutput query="getServices">				
					<!--- Since Points of interest are also used by the locater.cfm page ,
					modify the link href to point to the map if we're here from the locter,
					othewise point to the point of interest detail page --->
						
					<cfif isDefined("url.locater")>
						<cfset link_url = "../maps/map#trim(map_id)#.cfm">
					<cfelseif isDefined("getServices.service_location_id")>
						<cfset link_url = "services_detail.cfm?svc_id=#service_location_id#">
					<cfelse>
						<cfset link_url = "services_summary.cfm?srv=#abbr#">
					</cfif>
					
					<!--- High level summary shows service categories --->
					<a href="#link_url#">#name#</a>
					<cfif isDefined("location") AND location gt "">
						<br>&nbsp;&nbsp;(#location#)
					</cfif><br>
					
				</cfoutput>
			<cfelse>
				No services are on this map.
			</cfif>
	   </td>
	</tr>
</table>
</body>
</html>
