/*
Action class
Heather Koyuk
MultiCellular project
Spring 2005
This class contains the various classes for the actions that a cell is capable of
Currently, only Bud does anything even remotely useful.
These classes will be part of the abstract syntax in the grammar.
*/
package client;

import java.util.*;
// HK super class
class Action{
	String actionname;
	public Action(String name){
		actionname = name;
	}
}
// HK Bud inherits from Action and contains one or more ChildBuds
// Childbuds need to be changed to GrowthVectors since they do the same thing.
class Bud extends Action{
	Vector children;
	public Bud(){
		super("Bud");
		children = new Vector();
	}
	// HK adds a childbud to the Bud action
	public void addChild(Direction d, float f){ children.addElement(new ChildBud(d, f)); }
	public void addChild(ChildBud cb){ children.addElement(cb); }
	// returns and removes next childbud from vector
	public ChildBud getChild(){
		if(children.size()==0) return null;
		ChildBud c = (ChildBud)children.elementAt(0);
		children.removeElementAt(0);
		return c;
	}
}
// HK Divide does nothing useful yet
class Divide extends Action{
	ChildBud a;
	ChildBud b;
	public Divide(){
		super("Divide");
	}
	public Divide(Direction d){
		super("Divide");
		// stuff here to set up a division into two cells
	}
}

// HK replace with GrowthVector
class ChildBud{
	Direction direction;
	float magnitude;
	public ChildBud(Direction d, float f){
		direction = d;
		magnitude = f;
	}
}

