/*
Direction class
This class was created by Nick Armstrong for the MultiCellular project
This class contains a spherical-coordinate vector for growing a child cell
*/

package client;

import java.util.*;

public class Direction {

	public final static float PI = (float) java.lang.Math.PI;

	private float theta; // from 0 to 2pi
	private float phi; // from 0 to pi

	public Direction(float theta, float phi) {
		this.theta = theta;
		this.phi = phi;
		if(this.theta >= 2.0f*PI) theta -= 2.0f*PI;
		if(this.theta < 0) theta += 2.0f*PI;
//		while(this.phi >= PI) phi -= 2.0f*PI;
//		while(this.phi < 0) phi += 2.0f*PI;
	}

	public Direction(float x, float y, float z) {
		if(x != 0) theta = (float) Math.atan2(y, x); // arctan, 0 < theta < pi
		else theta = PI/2.0f;
		if(theta < 0) theta += 2.0f*PI;
		if(theta >= 2.0f*PI) theta -= 2.0f*PI;
		if(z != 0) phi = (float) Math.atan2(x, z); // arctan, 0 < phi < pi
		else  phi = PI/2.0f;
		if(x == 0 && z < 0) phi = PI;
	}

	public String toString() {
		StringBuffer stringVal = new StringBuffer("");
		stringVal.append(theta);
		stringVal.append(' ');
		stringVal.append(phi);
		return stringVal.toString();
	}

	public boolean equals(Direction b) {
		return (theta == b.theta() && phi == b.phi());
	}

	public Direction invert() {
		return new Direction(theta + PI, PI - phi);
	}

	public float theta() {return theta;}
	public float phi() {return phi;}
	public float x() {return (float) (java.lang.Math.cos(theta) * java.lang.Math.sin(phi));} // for the vector xi + yj + zk
	public float y() {return (float) (java.lang.Math.sin(theta) * java.lang.Math.sin(phi));} // for the vector xi + yj + zk
	public float z() {return (float) (java.lang.Math.cos(phi));} // for the vector xi + yj + zk

}