/*
GrowthVector class
Nick Armstrong
MultiCellular project
Spring 2005
This class contains a direction and a magnitude for creating a new child cell. The child cell will be
created in the direction specified by the Direction from the parent cell's center.
*/


package client;

public class GrowthVector {

	private Direction direction;
	private float magnitude;

	public GrowthVector(float theta, float phi, float magnitude) {
		this.direction = new Direction(theta, phi);
		this.magnitude = magnitude;
	}

	public GrowthVector(Direction direction, float magnitude) {
		this.direction = direction;
		this.magnitude = magnitude;
	}

	public String toString() {
		StringBuffer stringVal = new StringBuffer("");
		stringVal.append(direction.theta());
		stringVal.append(' ');
		stringVal.append(direction.phi());
		stringVal.append(' ');
		stringVal.append(magnitude);
		return stringVal.toString();
	}

	public boolean equals(GrowthVector b) {
		return equals(b.direction());
	}

	public boolean equals(Direction b) {
		return (direction.equals(b));
	}

	// inverts direction and magnitude
	public GrowthVector invert() {
		return new GrowthVector(direction.invert(), -1.0f*magnitude);
	}

	// inverts only the direction
	public GrowthVector invertDirection() {
		return new GrowthVector(direction.invert(), magnitude);
	}

	public float theta() {return direction.theta();}
	public float phi() {return direction.phi();}
	public float magnitude() {return magnitude;}
	public Direction direction() {return direction;}
	public float x() {return direction.x();} // for the vector xi + yj + zk
	public float y() {return direction.y();} // for the vector xi + yj + zk
	public float z() {return direction.z();} // for the vector xi + yj + zk

}