/*
Neighbors class (this class was ill-named, but I haven't yet figured out a better name for it)
Heather Koyuk
MultiCellular project
Spring 2005
This class contains and implements all locale-specific functions for a cell, including insertation
and searching of the (single, static) XYZTree.
*/

package client;

import java.util.*;

public class Neighbors{
	// HK contains the neighbors vector (instead of in the Cell class)
	private Vector neighbors = new Vector();
	// HL the cell that is specific to this instance of Neighbors
	private Cell cell;
	// HK specify the radius of neighbor cells to retrieve from the XYZTree
	private float neighborRange = 1.5F;
	// HK the tree
	private static XYZTree theTree;

	// HK initialize with a cell
	public Neighbors(Cell cell){
		this.cell = cell;
	}
	// HK insert cell into XYZTree
	public void insert(){
		// HK note: always get neighbors before inserting the cell into the tree!!!
		neighbors = XYZTree.neighbors(cell, neighborRange);
		theTree.insert(cell);
		for(int i = 0; i<neighbors.size(); i++) ((Cell)neighbors.elementAt(i)).addNeighbor(cell);
	}
	// HK adds a neighbor to the neighbor vector
	public void addNeighbor(Cell newcell){
		neighbors.addElement(newcell);
	}
	// HK removes a neighbor from the neighbor vector
	public void deleteNeighbor(Cell newcell){
		int i = neighbors.indexOf(newcell);
		if(i>=0) neighbors.removeElementAt(i);
	}
	// HK computes the center-to-center distance between two cells
	public float centerDistance(Cell neighbor){
		return centerDistance(neighbor.x(), neighbor.y(), neighbor.z());
	}
	// HK see above
	public float centerDistance(float ex, float ey, float ez){
		float xx = cell.x();
		float yy = cell.y();
		float zz = cell.z();
		return (float) Math.sqrt((xx-ex)*(xx-ex)+(yy-ey)*(yy-ey)+(zz-ez)*(zz-ez));
	}
	// HK computes the distance between the edge of one cell and the current cell
	public float distance(Cell neighbor){
		return this.centerDistance(neighbor)-(cell.radius()+neighbor.radius());
	}
	// HK see above
	public float distance(Point3D centerr, float rad){
		return this.centerDistance(centerr.x(), centerr.y(), centerr.z())-(cell.radius()+rad);
	}
	// HK determines whether another cell overlaps the current cell
	public boolean overlaps(Cell neighbor){
		return (this.distance(neighbor)<-0.05F);
	}
	// HK determines whether a specified center point with a given radius would overlap the current cell
	public boolean overlaps(Point3D centerr, float rad){
		return (this.distance(centerr, rad)<-0.05F);
	}
	// HK removes the cell from the tree and removes the cell from all registered neighbor's neighbor vectors
	public void destroy(){
		for(int i = 0; i<neighbors.size(); i++) ((Cell)neighbors.elementAt(i)).deleteNeighbor(cell);
		this.neighbors = null;
	}
	// HK creates the XYZTree with a single head cell. Only needs to be called once
	public void makeTree(Cell celll){
		if(theTree==null || theTree.isEmpty()) theTree = new XYZTree(celll);
		else{ theTree.reset(celll); }
	}
	// HK clears the XYZTree, removing all cells from the tree
	static public void clear(){
		System.out.println("Warning!! Entire XYZ tree is being deleted");
		theTree.makeEmpty();
	}

	// HK Here are some preliminary aggregation functions as discussed by Nick and Dr. Mock:
	// Note that min and max return the cell itself; I thought this might be useful if
	// we wanted to take distance or something else into account. Can't really do this with
	// sum, ave, or count though!
	public Cell min(int xfactor, int yfactor, int zfactor, float radius){
		Vector n = theTree.quadrant(cell.getCenter(), xfactor, yfactor, zfactor, radius);
		return min(n);
	}
	public Cell max(int xfactor, int yfactor, int zfactor, float radius){
		Vector n = theTree.quadrant(cell.getCenter(), xfactor, yfactor, zfactor, radius);
		return max(n);
	}
	public float sum(int xfactor, int yfactor, int zfactor, float radius){
		Vector n = theTree.quadrant(cell.getCenter(), xfactor, yfactor, zfactor, radius);
		return sum(n);
	}
	public float ave(int xfactor, int yfactor, int zfactor, float radius){
		Vector n = theTree.quadrant(cell.getCenter(), xfactor, yfactor, zfactor, radius);
		return ave(n);
	}
	public int count(int xfactor, int yfactor, int zfactor, float radius){
		Vector n = theTree.quadrant(cell.getCenter(), xfactor, yfactor, zfactor, radius);
		return n.size();
	}
	// HK returns the closest neighbor to the current cell
	public Cell closest(){
		if(neighbors.size()<1) return null;
		Cell near = (Cell)neighbors.elementAt(0);
		Cell temp;
		for(int i = 1; i<neighbors.size(); i++){
			temp = (Cell)neighbors.elementAt(i);
			if(cell.distance(temp)<cell.distance(near)) near = temp;
		}
		return near;
	}
	// HK returns the neighbor within a specified list that has the smallest magnitude
	public Cell min(Vector cells){
		if(cells.size()<1) return null;
		Cell minimum = (Cell)cells.elementAt(0);
		Cell compare = minimum;
		for(int i = 1; i<cells.size(); i++){
			compare = (Cell)cells.elementAt(i);
			if(compare.magnitude()<minimum.magnitude()) minimum = compare;
		}
		return minimum;
	}
	// HK returns the neighbor within a specified list that has the largest magnitude
	public Cell max(Vector cells){
		if(cells.size()<1) return null;
		Cell maximum = (Cell)cells.elementAt(0);
		Cell compare = maximum;
		for(int i = 1; i<cells.size(); i++){
			compare = (Cell)cells.elementAt(i);
			if(compare.magnitude()>maximum.magnitude()) maximum = compare;
		}
		return maximum;
	}
	// HK returns the sum of the magnitudes of all cells within the specified list
	public float sum(Vector cells){
		float sum = 0.0F;
		for(int i = 0; i<cells.size(); i++){
			sum+=((Cell)cells.elementAt(i)).magnitude();
		}
		return sum;
	}
	// HK returns the average of the magnitudes of all cells within the specified list
	public float ave(Vector cells){
		float average = 0.0F;
		for(int i = 0; i<cells.size(); i++){
			average+=((Cell)cells.elementAt(i)).magnitude();
		}
		average = average/cells.size();
		return average;
	}


}