/* Rules class
Nick Armstrong
MultiCellular project
Spring 2005
This class contians the logic for selecting an action and the approriate parameters for each cell during
each time step. This class was created by Nick Armstrong for the MultiCellular project and was modifided
by Heather Koyuk.
*/

package client;

import java.util.*;

public class Rules {

	public static final float PI = (float) java.lang.Math.PI;

	public static final Point3D ORIGIN = new Point3D(0, 0, 0);

	public static final Direction XPLUS = new Direction(0, PI/2.0f);
	public static final Direction YPLUS = new Direction(PI/2.0f, PI/2.0f);
	public static final Direction ZPLUS = new Direction(0, 0);
	public static final Direction XMINUS = new Direction(PI, PI/2.0f);
	public static final Direction YMINUS = new Direction(3.0f*PI/2.0f, PI/2.0f);
	public static final Direction ZMINUS = new Direction(0, PI);

	public static final Direction XPLUS_YPLUS = new Direction(PI/4.0f, PI/2.0f);
	public static final Direction XPLUS_YMINUS = new Direction(7.0f*PI/4.0f, PI/2.0f);
	public static final Direction XPLUS_ZPLUS = new Direction(0, PI/4.0f);
	public static final Direction XPLUS_ZMINUS = new Direction(0, 3.0f*PI/4.0f);
	public static final Direction XMINUS_YPLUS = new Direction(3.0f*PI/4.0f, PI/2.0f);
	public static final Direction XMINUS_YMINUS = new Direction(5.0f*PI/4.0f, PI/2.0f);
	public static final Direction XMINUS_ZPLUS = new Direction(PI, PI/4.0f);
	public static final Direction XMINUS_ZMINUS = new Direction(PI, 3.0f*PI/4.0f);
	public static final Direction YPLUS_ZPLUS = new Direction(PI/2.0f, PI/4.0f);
	public static final Direction YPLUS_ZMINUS = new Direction(PI/2.0f, 3.0f*PI/4.0f);
	public static final Direction YMINUS_ZPLUS = new Direction(3.0f*PI/2.0f, PI/4.0f);
	public static final Direction YMINUS_ZMINUS = new Direction(3.0f*PI/2.0f, 3.0f*PI/4.0f);

	public static final Direction XPLUS_YPLUS_ZPLUS = new Direction(PI/4.0f, PI/4.0f);
	public static final Direction XPLUS_YPLUS_ZMINUS = new Direction(PI/4.0f, 3.0f*PI/4.0f);
	public static final Direction XPLUS_YMINUS_ZPLUS = new Direction(7.0f*PI/4.0f, PI/4.0f);
	public static final Direction XPLUS_YMINUS_ZMINUS = new Direction(7.0f*PI/4.0f, 3.0f*PI/4.0f);
	public static final Direction XMINUS_YPLUS_ZPLUS = new Direction(3.0f*PI/4.0f, PI/4.0f);
	public static final Direction XMINUS_YPLUS_ZMINUS = new Direction(3.0f*PI/4.0f, 3.0f*PI/4.0f);
	public static final Direction XMINUS_YMINUS_ZPLUS = new Direction(5.0f*PI/4.0f, PI/4.0f);
	public static final Direction XMINUS_YMINUS_ZMINUS = new Direction(5.0f*PI/4.0f, 3.0f*PI/4.0f);

	public static final float D_THETA = PI/20.0f; // for circle-based rules
	public static final float HELIX_PHI_INCLINATION = PI/4.0f; // for helix rule
	public static final float CIRCULAR_DIVISION_THRESHHOLD = 256.0f; // limit number of divisions

	public static int count = 0;

	// HK flag for user-defined rules
	public static boolean altRules = false;
	// HK String for parsing... parsing is not implemented yet
	public static String userRules = "";
	// HK hard-coded values for user-defined rule parameters; will be made obselete later when parsing is implemented
	public static String agg1 = "";
	public static String comp = "";
	public static String agg2 = "";
	public static String theta1 = "";
	public static String phi1 = "";
	public static String mag1 = "";
	public static String rad1 = "";
	public static String theta2 = "";
	public static String phi2 = "";
	public static String mag2 = "";
	public static String rad2 = "";
	public static String theta3 = "";
	public static String phi3 = "";
	public static String mag3 = "";
	public static String rad3 = "";
	public static String theta4 = "";
	public static String phi4 = "";
	public static String mag4 = "";
	public static String rad4 = "";
	public static String theta5 = "";
	public static String phi5 = "";
	public static String mag5 = "";
	public static String rad5 = "";
	public static String theta6 = "";
	public static String phi6 = "";
	public static String mag6 = "";
	public static String rad6 = "";

	public static Vector seedCells() {
		Vector seedCells = new Vector();
//		State initialState = new State();
//		initialState.addGrowthVector(new GrowthVector(XPLUS, 2.0f)); // for circle, either cell division or budding (budding does not use magnitude at all
//		seedCells.add(new Cell(ORIGIN, initialState));
//		addCardinalSeedGrowthVectors(initialState);
//		addCardinalAndDiagonalSeedGrowthVectors(initialState);
		addDoubleHelixSeedCells(seedCells);
		return seedCells;
	}

	public static State calculateChildState(State state, GrowthVector tau, Point3D center) {
		if(tau.magnitude() > 0) {
			State childState = new State();
// begin double helix rules
			if(tau.phi() != PI/2.0f) {
				addHelicalGrowthVector(childState, tau, center);
				if((count++)%10 == 8) addHelixRungGrowthVector(childState, tau, center);
			}
			else {
				addMainGrowthVectorDiminished(childState, tau);
			}
// end double helix rules
//			addMainGrowthVectorDiminished(childState, tau);
//			addDiagonalGrowthVectors(childState, tau); // diagonal growth rule
//			addCircularGrowthVector(childState, tau, center);
//			if((((int)tau.magnitude()) % 3) == 2) addBranch(childState, tau); // random branching rule, every three steps
			return childState;
		} else return null;
	}

	public static State calculateDividedChildState(State state, GrowthVector tau) {
//		if(Math.abs(tau.magnitude()) < CIRCULAR_DIVISION_THRESHHOLD) { // limit number of divisions
			State childState = new State();
			childState.addGrowthVector(new GrowthVector(tau.theta() + PI/tau.magnitude(), tau.phi(), 2.0f*tau.magnitude())); // magnitude is used as divisor of 2pi radians, thereby reducing the change in cell division angle each timestep by a factor of 2
			return childState;
//		} else return null;
	}

	public static void addCardinalSeedGrowthVectors(State initialState) {
		GrowthVector tau1 = new GrowthVector(XPLUS, 10);
		GrowthVector tau2 = new GrowthVector(YPLUS, 10);
		GrowthVector tau3 = new GrowthVector(ZPLUS, 10);
		GrowthVector tau4 = new GrowthVector(XMINUS, 10);
		GrowthVector tau5 = new GrowthVector(YMINUS, 10);
		GrowthVector tau6 = new GrowthVector(ZMINUS, 10);
		initialState.addGrowthVector(tau1);
		initialState.addGrowthVector(tau2);
		initialState.addGrowthVector(tau3);
		initialState.addGrowthVector(tau4);
		initialState.addGrowthVector(tau5);
		initialState.addGrowthVector(tau6);
	}

	public static void addCardinalAndDiagonalSeedGrowthVectors(State initialState) {
		GrowthVector tau1 = new GrowthVector(XPLUS, 10);
		GrowthVector tau2 = new GrowthVector(YPLUS, 10);
		GrowthVector tau3 = new GrowthVector(ZPLUS, 10);
		GrowthVector tau4 = new GrowthVector(XMINUS, 10);
		GrowthVector tau5 = new GrowthVector(YMINUS, 10);
		GrowthVector tau6 = new GrowthVector(ZMINUS, 10);
		initialState.addGrowthVector(tau1);
		initialState.addGrowthVector(tau2);
		initialState.addGrowthVector(tau3);
		initialState.addGrowthVector(tau4);
		initialState.addGrowthVector(tau5);
		initialState.addGrowthVector(tau6);
		addDiagonalGrowthVectors(initialState, tau1);
		addDiagonalGrowthVectors(initialState, tau2);
		addDiagonalGrowthVectors(initialState, tau3);
		addDiagonalGrowthVectors(initialState, tau4);
		addDiagonalGrowthVectors(initialState, tau5);
		addDiagonalGrowthVectors(initialState, tau6);
	}

	public static void addDiagonalGrowthVectors(State childState, GrowthVector tau) {
		if(tau.direction().equals(XPLUS)) {
			childState.addGrowthVector(new GrowthVector(XPLUS_YPLUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XPLUS_YMINUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XPLUS_ZPLUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XPLUS_ZMINUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XPLUS_YPLUS_ZPLUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XPLUS_YPLUS_ZMINUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XPLUS_YMINUS_ZPLUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XPLUS_YMINUS_ZMINUS, tau.magnitude() - 1.0f));
		}
		if(tau.direction().equals(XMINUS)) {
			childState.addGrowthVector(new GrowthVector(XMINUS_YPLUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XMINUS_YMINUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XMINUS_ZPLUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XMINUS_ZMINUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XMINUS_YPLUS_ZPLUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XMINUS_YPLUS_ZMINUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XMINUS_YMINUS_ZPLUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XMINUS_YMINUS_ZMINUS, tau.magnitude() - 1.0f));
		}
		if(tau.direction().equals(YPLUS)) {
			childState.addGrowthVector(new GrowthVector(XPLUS_YPLUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XMINUS_YPLUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(YPLUS_ZPLUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(YPLUS_ZMINUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XPLUS_YPLUS_ZPLUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XPLUS_YPLUS_ZMINUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XMINUS_YPLUS_ZPLUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XMINUS_YPLUS_ZMINUS, tau.magnitude() - 1.0f));
		}
		if(tau.direction().equals(YMINUS)) {
			childState.addGrowthVector(new GrowthVector(XPLUS_YMINUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XMINUS_YMINUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(YMINUS_ZPLUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(YMINUS_ZMINUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XPLUS_YMINUS_ZPLUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XPLUS_YMINUS_ZMINUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XMINUS_YMINUS_ZPLUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XMINUS_YMINUS_ZMINUS, tau.magnitude() - 1.0f));
		}
		if(tau.direction().equals(ZPLUS)) {
			childState.addGrowthVector(new GrowthVector(XPLUS_ZPLUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XMINUS_ZPLUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(YPLUS_ZPLUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(YMINUS_ZPLUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XPLUS_YPLUS_ZPLUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XPLUS_YMINUS_ZPLUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XMINUS_YPLUS_ZPLUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XMINUS_YMINUS_ZPLUS, tau.magnitude() - 1.0f));
		}
		if(tau.direction().equals(ZMINUS)) {
			childState.addGrowthVector(new GrowthVector(XPLUS_ZMINUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XMINUS_ZMINUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(YPLUS_ZMINUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(YMINUS_ZMINUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XPLUS_YPLUS_ZMINUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XPLUS_YMINUS_ZMINUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XMINUS_YPLUS_ZMINUS, tau.magnitude() - 1.0f));
			childState.addGrowthVector(new GrowthVector(XMINUS_YMINUS_ZMINUS, tau.magnitude() - 1.0f));
		}
	}

	public static void addCircleSeedCells(Vector seedCells) {
		float bigCircleRadius = 2.0f*Cell.RADIUS/D_THETA;
		State seed1State = new State();
		Point3D seed1Center = new Point3D(bigCircleRadius, 0, 0);
		GrowthVector tau1 = new GrowthVector(new Direction(YPLUS.theta()+D_THETA, PI/2.0f), 1.0f); // magnitude doesn't matter here, grows FOREVER
		seed1State.addGrowthVector(tau1);
		seedCells.add(new Cell(seed1Center, seed1State));
	}

	public static void addDoubleHelixSeedCells(Vector seedCells) {

		float bigCircleRadius = 2.0f*Cell.RADIUS/D_THETA*(float)Math.cos(HELIX_PHI_INCLINATION);

		State seed1State = new State();
		Point3D seed1Center = new Point3D(bigCircleRadius, 0, 0);
		GrowthVector tau1 = new GrowthVector(new Direction(YPLUS.theta()+D_THETA, PI/2.0f-HELIX_PHI_INCLINATION), 10.0f); // magnitude doesn't matter here, grows FOREVER
		seed1State.addGrowthVector(tau1);
		seedCells.add(new Cell(seed1Center, seed1State));

		State seed2State = new State();
		Point3D seed2Center = new Point3D(0, bigCircleRadius, 0);
		GrowthVector tau2 = new GrowthVector(new Direction(XMINUS.theta()+D_THETA, PI/2.0f-HELIX_PHI_INCLINATION), 10.0f); // magnitude doesn't matter here, grows FOREVER
		seed2State.addGrowthVector(tau2);
		seedCells.add(new Cell(seed2Center, seed2State));

	}

	// main diminishing growth rule
	public static void addMainGrowthVectorDiminished(State childState, GrowthVector tau) {
		GrowthVector mainGrowthVectorDiminished = new GrowthVector(tau.theta(), tau.phi(), tau.magnitude() - 1.0f);
		childState.addGrowthVector(mainGrowthVectorDiminished);
	}

	public static void addCircularGrowthVector(State childState, GrowthVector tau, Point3D center) {
		childState.addGrowthVector(new GrowthVector(tau.theta()+D_THETA, tau.phi(), 1.0f)); // magnitude is not used here, grows FOREVER
	}

	public static void addHelicalGrowthVector(State childState, GrowthVector tau, Point3D center) {
		childState.addGrowthVector(new GrowthVector(tau.theta()+D_THETA, tau.phi(), 1.0f)); // magnitude is not used here, grows FOREVER
	}

	public static void addHelixRungGrowthVector(State childState, GrowthVector tau, Point3D center) {
		float rungLength = 2.0f*(float)Math.sqrt(2.0f)*Cell.RADIUS/D_THETA*(float)Math.cos(HELIX_PHI_INCLINATION) - 1.0f; // length of ladder rung; to later be nixed and replaced with "grow until you hit the other side"
		childState.addGrowthVector(new GrowthVector(tau.theta()+PI/4.0f, tau.phi()+HELIX_PHI_INCLINATION, rungLength));
	}


	// random branching rule, every three steps
	public static void addBranch(State childState, GrowthVector tau) {
		float delta_theta = 0;
		float delta_phi = 0;
//		Random r = new Random();
//		delta_theta = r.nextFloat()*PI - PI/2.0f; // between -pi/2 and pi/2
//		delta_phi = r.nextFloat()*PI - PI/2.0f; // between -pi/2 and pi/2
		delta_theta = PI/4.0f;
		delta_phi = PI/6.0f;
		GrowthVector branch = new GrowthVector(tau.theta()+delta_theta, tau.phi()+delta_phi, tau.magnitude() - 1.0f);
		childState.addGrowthVector(branch);
		GrowthVector branch2 = new GrowthVector(tau.theta()+delta_theta, tau.phi()-delta_phi, tau.magnitude() - 1.0f);
		childState.addGrowthVector(branch2);
		GrowthVector branch3 = new GrowthVector(tau.theta()-delta_theta, tau.phi()+delta_phi, tau.magnitude() - 1.0f);
		childState.addGrowthVector(branch3);
		GrowthVector branch4 = new GrowthVector(tau.theta()-delta_theta, tau.phi()-delta_phi, tau.magnitude() - 1.0f);
		childState.addGrowthVector(branch4);
	}
	// HK modified this method to avoid collisions
	public static Point3D calculateChildCenter(Point3D center, GrowthVector tau, float radius) {
		float dx = 2*radius * tau.x()+center.x();
		float dy = 2*radius * tau.y()+center.y();
		float dz = 2*radius * tau.z()+center.z();
		Point3D babyCenter = new Point3D(dx, dy, dz);
		if(isEmptySpace(babyCenter, tau, radius)) return babyCenter;
		return null;
	}
	// HK added helper method
	public static Point3D calculateChildCenter(Point3D center, GrowthVector tau) {
		return calculateChildCenter(center, tau, Cell.RADIUS);
	}
	// HK calculates for potential collisions in the search space; returns a boolean value
	// indicating whether or not a new cell can be created in the specified space.
	private static boolean isEmptySpace(Point3D center, GrowthVector tau, float radius){
		Vector neighbors = XYZTree.neighbors(center, radius);
		for(int i=0; i<neighbors.size(); i++){
			if(((Cell)neighbors.elementAt(i)).overlaps(center, radius-0.2F)){
				System.out.println(" = OVERLAP!");
				return false;
			}
		}
		return true;
	}
	// HK see above
	public static boolean isEmptySpace(Point3D center, float radius){
		Vector neighbors = XYZTree.neighbors(center, radius);
		for(int i=0; i<neighbors.size(); i++){
			if(((Cell)neighbors.elementAt(i)).overlaps(center, (radius-0.3F))){
				System.out.println(" = OVERLAP!");
				return false;
			}
		}
		return true;
	}
	// HK modularized class for retrieving an action for a cell.
	// Implements the Rules Window mockup for very limited dynamic rules selection.
	// The hard-coded values will eventually be replaced by a true parser functionality; the importance
	// of this method is that it allows the Rules class to completely determine a cell's behavior based on
	// the cell's current state and/or the state of its neighbors.
	public static Action getAction(Cell cell){
		if(!altRules) return new Divide();
		float a1 = eval(agg1, cell);
		float a2 = eval(agg2, cell);
		boolean compare = true;
		if(comp.equals(">")&& !(a1>a2)) compare = false;
		else if(comp.equals("<")&& !(a1<a2)) compare = false;
		else if(comp.equals(">=")&& a1<a2) compare = false;
		else if(comp.equals("<=")&& a1>a2) compare = false;
		else if(comp.equals("=")&& a1!=a2) compare = false;
		else if(comp.equals("!=")&& a1==a2) compare = false;
		Bud bud = new Bud();
		// replace childbud with GrowthVector; they both do the same thing
		ChildBud cb;

		if(compare){
			cb = getBud(theta1, phi1, mag1, cell);
			if(cb!=null) bud.addChild(cb);
			cb = getBud(theta2, phi2, mag2, cell);
			if(cb!=null) bud.addChild(cb);
			cb = getBud(theta3, phi3, mag3, cell);
			if(cb!=null) bud.addChild(cb);
		}
		else{
			cb = getBud(theta4, phi4, mag4, cell);
			if(cb!=null) bud.addChild(cb);
			cb = getBud(theta5, phi5, mag5, cell);
			if(cb!=null) bud.addChild(cb);
			cb = getBud(theta6, phi6, mag6, cell);
			if(cb!=null) bud.addChild(cb);
		}
		return bud;
	}
	// HK returns a childbud (i.e., growthVector) from the user rules
	public static ChildBud getBud(String theta, String phi, String mag, Cell cell){
		Direction d1 = Rules.XMINUS;
		if(theta.length()==0) return null;
		if(theta.charAt(0) == ('X')||theta.charAt(0) == ('x')){
			if(theta.charAt(1) == ('-')) d1 = Rules.XMINUS;
			else if(theta.charAt(1) == ('+')) d1 = Rules.XPLUS;
		}
		else if(theta.charAt(0) == ('Y')||theta.charAt(0) == ('y')){
			if(theta.charAt(1) == ('-')) d1 = Rules.YMINUS;
			else if(theta.charAt(1) == ('+')) d1 = Rules.YPLUS;
		}
		else if(theta.charAt(0) == ('Z')||theta.charAt(0) == ('z')){
			if(theta.charAt(1) == ('-')) d1 = Rules.ZMINUS;
			else if(theta.charAt(1) == ('+')) d1 = Rules.ZPLUS;
		}
		else{
			d1 = new Direction((float)Integer.parseInt(theta), (float)Integer.parseInt(phi));
		}
		if(mag.length()>0) {
			float i = eval(mag, cell);
			return new ChildBud(d1, i);
		}
		return null;
	}
	// HK er, does nothing yet (obviously!)
	public static void parseRules(){

	}
	// HK pseudo evaluation method ;)
	public static float eval(String toeval, Cell cell){
		StringTokenizer st = new StringTokenizer(toeval, "-+*/", true);

		float firstnum = 0.0F;
		String comparator = "";
		float secondnum = 0.0F;

		String s = st.nextToken().trim();
		if(s.equals("magnitude")) firstnum = cell.magnitude();
		else if(s.equals("nearest")){
			try{
			firstnum = cell.closest().magnitude();
			}
			catch(Exception e){
				firstnum = cell.magnitude();
			}
		}
		else {
			//System.out.println(s);
			firstnum = Integer.valueOf(s).intValue();
		}
		if(st.hasMoreTokens()){
			comparator = st.nextToken().trim();
			s = st.nextToken().trim();
			if(s.equals("magnitude")) secondnum = cell.magnitude();
			else if(s.equals("nearest")) {
				try{
					secondnum = cell.closest().magnitude();
				}
				catch(Exception e){
					secondnum = cell.magnitude();
				}
			}
			else { secondnum = (float)Integer.valueOf(s).intValue(); }

			if(comparator.equals("-")) firstnum = firstnum - secondnum;
			else if(comparator.equals("+")) firstnum = firstnum + secondnum;
			else if(comparator.equals("*")) firstnum = firstnum * secondnum;
			else if(comparator.equals("/")) firstnum = firstnum / secondnum;
		}
		return firstnum;
	}
	// HK The following is the code that should be replaced with code for a hard-coded user-defined rule.
	// HK Moved all functionality to create a child cell to Rules class (was in both Cell and Rules class)
	public static Cell growChild(Cell parent, GrowthVector tau) {
		State newChildState = calculateChildState(parent.getState(), tau, parent.getCenter());
		Point3D newChildCenter = calculateChildCenter(parent.getCenter(), tau);
		if(newChildState != null && newChildCenter != null) return new Cell(newChildCenter, newChildState);
		return null;
	}
}