/*
State class

Nick Armstrong
MultiCellular project
Spring 2005

This class contains a vector of GrowthVectors and a float-valued magnitude variable that together comprise
a cell's current state.
*/

package client;

import java.util.*;

public class State {

	private Vector growthVectors;
	// HK added magnitude to state
	private float magnitude = 0.0F;

	public State() {
		growthVectors = new Vector();
	}

	public State(GrowthVector tau) {
		growthVectors = new Vector();
		growthVectors.add(tau);
		// HK
		magnitude+=tau.magnitude();
	}

	public State(float theta, float phi, float mag) {
		growthVectors = new Vector();
		growthVectors.add(new GrowthVector(theta, phi, mag));
		// HK
		magnitude+=mag;
	}

	public void addGrowthVector(GrowthVector tau) {
		growthVectors.add(tau);
		// HK
		magnitude+=tau.magnitude();
	}
	public void removeGrowthVector(GrowthVector tau){
		int i = growthVectors.indexOf(tau);
		if(i<=0) growthVectors.removeElementAt(i);
		// HK
		magnitude-=tau.magnitude();
	}
	public String toString() {
		StringBuffer stringVal = new StringBuffer("");
		for(int i = 0; i < growthVectors.size(); i++) {
			stringVal.append(growthVectors.get(i).toString());
			stringVal.append(' ');
		}
		return stringVal.toString();
	}

	public GrowthVector getGrowthVector(int i) {return (GrowthVector) growthVectors.get(i);}
	public Vector getGrowthVectors() {return growthVectors;}
	public int size(){ return growthVectors.size();}
	// HK
	public float magnitude(){ return this.magnitude;}
	// HK
	public void setMagnitude(float f){ this.magnitude = f; }

}