package client;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.SwingUtilities;
import vtk.*;

/**
 *      VisualizationPanel object that handles mouse events for the Visualization.
 *
 * @author         SVA Group
 * @created        February 13, 2003
 */
public class VisualizationPanel extends vtkPanel {

  /** Load all the necessary VTK libraries **/
  static {
    System.loadLibrary("vtkCommonJava");
    System.loadLibrary("vtkFilteringJava");
    System.loadLibrary("vtkIOJava");
    System.loadLibrary("vtkImagingJava");
    System.loadLibrary("vtkGraphicsJava");
    System.loadLibrary("vtkRenderingJava");
    try {
      System.loadLibrary("vtkHybridJava");
    }
    catch (Throwable e) {
		System.out.println("Unable to load library file");
		System.exit(-1);
    }
  }

  /**
   *		Constructor for the vtkPanel object, calls default constructor.
   */
  public VisualizationPanel() {
    super();
  }

	public void clearPanel() {
		 if ( ren != null ) {
			vtkActorCollection Actors = ren.GetActors();
			Actors.InitTraversal();

			int maxi = Actors.GetNumberOfItems();
			for ( int i = 0; i < maxi; i++ ) {
					ren.RemoveActor( Actors.GetNextActor() );
			}
			vtkActor2DCollection Actors2D = ren.GetActors2D();
			Actors2D.InitTraversal();
			maxi = Actors2D.GetNumberOfItems();
			for ( int i = 0; i < maxi; i++ ) {
					ren.RemoveActor( Actors2D.GetNextActor2D() );
			}
		}
	}

	public void resetCameraToRender() {
//		getCamera().Render(ren);
		// yargh! can't figure out how to do this right
	}

  /**
   *      Gets the camera of the VisualizationPanel instance.
   *
   * @return        The VisualizationPanel's camera.
   */
  public vtkCamera getCamera() {
    return ren.GetActiveCamera();
  }

  /**
   *      Gets the light of the VisualizationPanel instance
   *
   * @return        The VisualizationPanel's light.
   */
  public vtkLight getLight() {
    return lgt;
  }

  public void mousePressed(MouseEvent e) {
    rw.SetDesiredUpdateRate(5.0);
    lastX = e.getX();
    lastY = e.getY();
  }

  public void mouseReleased(MouseEvent e) {
//    super.mouseReleased(e);
  }

  public void mouseDragged(MouseEvent e) {
    super.mouseDragged(e);
  }

  public void mouseEntered( MouseEvent e ) { }
  public void keyPressed(KeyEvent e) {  }

  /**      Sets the VisualizationPanel to surface view mode. */
  public void viewAsSurface() {
    vtkActorCollection ac;
    vtkActor anActor;
    vtkActor aPart;
    int i;
    int j;

    ac = ren.GetActors();
    ac.InitTraversal();
    for (i = 0; i < ac.GetNumberOfItems(); i++) {
      anActor = ac.GetNextActor();
      anActor.InitPartTraversal();
      for (j = 0; j < anActor.GetNumberOfParts(); j++) {
        aPart = anActor.GetNextPart();
        aPart.GetProperty().SetRepresentationToSurface();
      }
    }
    this.Render();
  }

  /**      Sets the VisualizationPanel to wireframe view mode. */
  public void viewAsWireframe() {
    vtkActorCollection ac;
    vtkActor anActor;
    vtkActor aPart;
    int i;
    int j;

    ac = ren.GetActors();
    ac.InitTraversal();
    for (i = 0; i < ac.GetNumberOfItems(); i++) {
      anActor = ac.GetNextActor();
      anActor.InitPartTraversal();
      for (j = 0; j < anActor.GetNumberOfParts(); j++) {
        aPart = anActor.GetNextPart();
        aPart.GetProperty().SetRepresentationToWireframe();
      }
    }
    this.Render();
  }

  /**
   *      Caputures the current state of the VisualizationPanel.
   *
   * @return        The current state of the VisualizationPanel.
   */
  public String captureCurrentState() {
    /**
     *	requires: A visualization must be loaded.
     *	effects: returns a string representation of the current state of the visualization.
     */
    String command = "";

    /** Capture the camera position and add it to the command string. **/
    vtkCamera cam = ren.GetActiveCamera();
    double[] camPos = cam.GetPosition();
    for (int i = 0; i < camPos.length; i++) {
      command = command.concat(String.valueOf(camPos[i]) + " ");
    }

    /** Capture the camera focal point and add it to the command string. **/
    double[] focalPt = cam.GetFocalPoint();
    for (int i = 0; i < focalPt.length; i++) {
      command = command.concat(String.valueOf(focalPt[i]) + " ");
    }

    /** Capture the light position and add it to the command string. **/
    double[] lightPos = lgt.GetPosition();
    for (int i = 0; i < lightPos.length; i++) {
      command = command.concat(String.valueOf(lightPos[i]) + " ");
    }

    /** Capture the camera distance and add it to the command string. **/
    double camDist = cam.GetDistance();
    command = command.concat(String.valueOf(camDist) + " ");

    /** Capture the view up and add it to the command string. **/
    double[] viewUp = cam.GetViewUp();
    for (int i = 0; i < viewUp.length; i++) {
      command = command.concat(String.valueOf(viewUp[i]) + " ");
    }

    /** Capture the clipping range and add it to the command string. **/
    double[] clipRange = cam.GetClippingRange();
    for (int i = 0; i < clipRange.length; i++) {
      command = command.concat(String.valueOf(clipRange[i]) + " ");
    }
    return command;
  }

}

