/*
XYZTree class
Heather Koyuk
MultiCellular project
Spring 2005

This class contains the three-dimensional binary search tree for storing and locating cells in the
unbounded search space.

*/

package client;

import java.util.*;

public class XYZTree{

	private int count;
	// head of tree
	private static Cell head;
	private int size;
	// one constructor
	public XYZTree(Cell first){
		head = first;
		size = 1;
	}
	// resets the head to be the specified cell
	public void reset(Cell cell){
		this.head = cell;
	}
	// empties the tree
	public void makeEmpty(){
		this.head = null;
	}
	// izit empty?
	public boolean isEmpty(){
		return (this.head==null);
	}
	// inserts a cell into the tree
	public void insert(Cell child){
		this.insert(this.head, child, 0);
		size ++;
	}
	/* The following recursive method searches the XYZTree for the correct place to insert the new cell. Cells are inserted as follows:
	If the child cell's min x value is less than the parent's, go down the left X side of the tree. If the x ranges are a
	perfect match, continue on to the Y side of the tree. Otherwise, go down the right X side of the tree. Follow the same rules
	for the Y and Z sides of the tree, but a perfect match at the end of the Z side means two cells share exactly the same coordinates.
	checknode() below is a private helper function that checks for a null x or y or z child and inserts the new node as the child
	if no child previously existed, and otherwise, calls the recursive traverseTree function.
	*/
	private void insert(Cell parent, Cell child, int count){
		int min = count; // to access appropriate minimum-valued index in minmax and children arrays
		int max = count+1;	// to access appropriate maximum-valued index in minmax and children arrays
		if(child.minmax[max]<=parent.minmax[min]) this.checknode(parent, child, min);
		else if(child.minmax[min]>=parent.minmax[max]) this.checknode(parent, child, max);
		else{
			// if child is larger than the current cell, they must be swapped
			if(child.minmax[min]<parent.minmax[min]&&child.minmax[max]>parent.minmax[max]){
				// replace smaller node with larger node, then insert the smaller node and children back in the tree
				this.swapAndInsert(child, parent);
			}
				// if the child's min <xyx> is smaller than the parent's, keep going down the left side of the tree
			else if(child.minmax[min]<parent.minmax[min]) this.checknode(parent, child, min);
				// if the child's max <xyz> is larger than the parent's, keep going down the right side of the tree
			else if(child.minmax[max]>parent.minmax[max]) this.checknode(parent, child, max);
			else if((child.minmax[min]>parent.minmax[min]&&child.minmax[max]<=parent.minmax[max])||
			        (child.minmax[min]>=parent.minmax[min]&&child.minmax[max]<parent.minmax[max])) {
				this.checknode(parent, child, max);
			}
			// if current cell is dead, replace with new cell and re-insert all children of dead cell
			else{
				if(count<4) this.insert(parent, child, count+2);
				else{
					if(parent.isDead()){
					this.swapAndInsert(child, parent);
					}
					//else{ System.out.println("Error, two cells occupy exactly the same space"); }
					// link cells in linked list if they are in the same x,y,z range
					else{ link(parent, child); }
				}
			}
		}
	}
	// linked list for cells that occupy exactly the same X, Y, and Z ranges
	private void link(Cell parent, Cell child){
		Cell temp = parent;
		while(temp.next!=null) temp = temp.next;
		parent.next = child;
	}
	// checknode is a helper method that automatically inserts cells if the specified child link is empty, or
	// recurses on the insert method if the specified child link is not empty.
	private void checknode(Cell parent, Cell child, int minOrMax){
		if(parent.children[minOrMax]==null) parent.children[minOrMax] = child;
		else{
			int base = minOrMax;
			if(base%2==1) base--;
			insert(parent.children[minOrMax], child, base);
		}
	}
	// returns a vector of cells within a specified radius from the cell's center
	static public Vector neighbors(Cell cell, float radius){
		return neighbors(cell.x()-radius, cell.x()+radius, cell.y()-radius, cell.y()+radius, cell.z()-radius, cell.z()+radius);
	}
	// see above
	static public Vector neighbors(Point3D center, float radius){
		return neighbors(center.x()-radius, center.x()+radius, center.y()-radius, center.y()+radius, center.z()-radius, center.z()+radius);
	}
	// see above
	static public Vector neighbors(float x, float y, float z, float radius){
		return neighbors(x-radius, x+radius, y-radius, y+radius, z-radius, z+radius);
	}
	// to use the following method, which subdivides the area around a point into 8 bins and can return neighbors
	// from 1, 2, 4, or all 8 of the bins, you specify the center point (x, y, and z) and the radius, and then use
	// integers (positive, negative, or 0) to specify what range to use for each of the x, y, and z values.
	// A negative factor indicates all points less than, 0 is all points less than and greater than,
	// and a positive factor is all points greater than. For instance, an xfactor
	// of 0, a yfactor of -1, and a z factor of 1 will return all neighbors within the range
	// (x-radius -> x+radius), (y-radius -> y), (z, z+radius), or two of the bottom 'quadrants.'
	static public Vector quadrant(float x, float y, float z, int xfactor, int yfactor, int zfactor, float radius){
		float xmin = x-radius;
		if(xfactor>0) xmin = x;
		float xmax = x+radius;
		if(xfactor<0) xmax = x;
		float ymin = y-radius;
		if(yfactor>0) ymin = y;
		float ymax = y+radius;
		if(yfactor<0) ymax = y;
		float zmin = z-radius;
		if(zfactor>0) zmin = z;
		float zmax = z+radius;
		if(zfactor<0) zmax = z;
		return neighbors(xmin, xmax, ymin, ymax, zmin, zmax);
	}
	// see above
	static public Vector quadrant(Point3D startingPoint, int xfactor, int yfactor, int zfactor, float radius){
		return quadrant(startingPoint.x(), startingPoint.y(), startingPoint.z(), xfactor, yfactor, zfactor, radius);
	}
	// alternatively, you can manually specify min and max values for each of x, y, and z, for a
	// rectangular bin with dimensions and location of your choice. Note that this method does not take
	// the original x,y, and z points into account and assumes that calibration has already been performed.
	static public Vector neighbors(float xmin, float xmax, float ymin, float ymax, float zmin, float zmax){
			// the Vector to return
		Vector neighborcells = new Vector();
		float[] minmax = new float[6];

		minmax[0] = (xmin);
		minmax[1] = (xmax);
		minmax[2] = (ymin);
		minmax[3] = (ymax);
		minmax[4] = (zmin);
		minmax[5] = (zmax);

			// Go left or right in the XYZTree to find any matching x value
		neighborcells = findMatches(head, minmax, 0, neighborcells);
		return neighborcells;
	}
	/* the following recursive method traverses the tree, collecting all cells that have overlapping x, y, and z values with the
	requested radius. Note that a cell with a max value equal to a requested min value means that that cell does NOT overlap,
	because floors are used for min values whereas ceilings are used for max values.
	*/
	static private Vector findMatches(Cell parent, float[] minmax, int count, Vector neighborcells){
		int min = count;
		int max = count+1;

		if(parent==null) return neighborcells;
		// too far right in tree for current x-y-z level
		if(minmax[max]<=parent.minmax[min]) {
			neighborcells =  findMatches(parent.children[min],minmax, count, neighborcells);
		}
		// too far left in tree for current x-y-z level
		else if(minmax[min]>=parent.minmax[max]) {
			neighborcells = findMatches(parent.children[max],minmax, count, neighborcells);
		}
		// current xyz level overlaps. Keep recursing, and if x, y, AND z overlap, insert parent into neighbor vector
		else{
			//if((minmax[min]<parent.minmax[min])&&(minmax[max]<parent.minmax[max])) {
				Vector childrenLeft = new Vector();
				childrenLeft = findMatches(parent.children[min],minmax, count, childrenLeft);
				neighborcells = addVectors(neighborcells, childrenLeft);
			//}
			//if((minmax[min]>=parent.minmax[min])&&(minmax[max]>=parent.minmax[max])) {
				Vector childrenRight = new Vector();
				childrenRight = findMatches(parent.children[max], minmax, count, childrenRight);
				neighborcells = addVectors(neighborcells, childrenRight);
			//}
			if(count<4) {
				neighborcells = findMatches(parent, minmax, count+2, neighborcells);
			}
			else{
				if(!parent.isDead() && inRange(minmax, parent)) neighborcells.addElement(parent);
				// HK 2/26 get linked cells as well
				Cell temp = parent;
				while(temp.next!=null){
					if(!temp.next.isDead()&& inRange(minmax, temp.next)) neighborcells.addElement(temp.next);
					temp = temp.next;
				}
			}
		}
		return neighborcells;
	}
	// is a cell within a particular minmax range?
	// private helper method for insertions
	static private boolean inRange(float[] minmax, Cell cell){
		float radius = (minmax[1]-minmax[0])/2;
		float xcenter = minmax[0]+radius;
		float ycenter = minmax[2]+radius;
		float zcenter = minmax[4]+radius;
		Point3D center = new Point3D(xcenter, ycenter, zcenter);
		if(cell.overlaps(center, radius)) return true;
		return false;
	}
	// private helper method to combine the vectors retrieved during insert recursion
	static private Vector addVectors(Vector cellsOne, Vector cellsTwo){
		for(int i = 0; i<cellsTwo.size(); i++) cellsOne.addElement(cellsTwo.elementAt(i));
		return cellsOne;
	}
	// messy printing method
	public void print(){
		print(this.head);
	}
	// messy printing method
	private void print(Cell current){
		if(!current.isDead())System.out.print(current.toString());
		else{System.out.print("/"); }
		System.out.print(": ");
		for(int i = 0; i<6; i++){
			System.out.print("[");
			if(current.children[i]!=null){
				if(current.children[i].isDead()) System.out.print("/");
				else{ System.out.print(current.children[i].toString()); }
			}
			System.out.print("]");
		}
		System.out.println();
		for(int i =0; i<6; i++){
			if(current.children[i]!=null) print(current.children[i]);
		}
		// HK 2/26 print linked cells too
		if(current.next!=null){
			System.out.print("--");
			print(current.next);
		}
	}
	// finds the parent of a specified cell. Returns null if cell is not in the tree.
	public Cell findParent(Cell child){
		if(child==this.head) return child;
		return this.findParent(this.head, child, 0);
	}
	// see above
	private Cell findParent(Cell parent, Cell child, int count){
		int min = count; // to access appropriate minimum-valued index in minmax and children arrays
		int max = count+1;	// to access appropriate maximum-valued index in minmax and children arrays
		if(child.minmax[max]<=parent.minmax[min]) {
			return this.checkParentnode(parent, child, min);
		}
		else if(child.minmax[min]>=parent.minmax[max]) return this.checkParentnode(parent, child, max);
		else{
			if(child.minmax[min]<parent.minmax[min]&&child.minmax[max]>parent.minmax[max]){
				//return this.checkParentnode(parent, child, max);
				System.out.println("Error in cell insertion order");
			}
				// if the child's min <xyz> is smaller than the parent's, keep going down the left side of the tree
			else if(child.minmax[min]<parent.minmax[min]) return this.checkParentnode(parent, child, min);
				// if the child's max <xyz> is larger than the parent's, keep going down the right side of the tree
			else if(child.minmax[max]>parent.minmax[max]) return this.checkParentnode(parent, child, max);
				// if the child's min & max <xyz> is enclosed within the parent, keep going down the right side of the tree
			else if((child.minmax[min]>parent.minmax[min]&&child.minmax[max]<=parent.minmax[max])||
			        (child.minmax[min]>=parent.minmax[min]&&child.minmax[max]<parent.minmax[max])) {
				return this.checkParentnode(parent, child, max);
			}
			else{
				// else, go on to next x-y-z, or return error if already at z.
				if(count<4) return this.findParent(parent, child, count+2);
				else{ System.out.println("Error looking for parent!");
				 	return null; }
			}
		}
		return null;
	}
	// private helper method to check each cell to see if it is the child's parent
	private Cell checkParentnode(Cell parent, Cell child, int minOrMax){
			// if specified link is empty, we have an error, or the specified child cell is not in the tree
		if(parent.children[minOrMax]==null) return null;
			//if specified link is the child, we have found the parent
		else if(parent.children[minOrMax]==child) return parent;
			// recurse on the findParent method
		else{
			int base = minOrMax;
			if(base%2==1) base--;
			return findParent(parent.children[minOrMax], child, base);
		}
	}
	// swaps a given cell for another, re-inserting the swapped cell subtree back into the XYZtree
	public void swapAndInsert(Cell replacement, Cell replaced){
		Cell replacedParent = this.findParent(replaced);
		if(replacedParent==null) {
			System.out.println("parent is null in swapAndInsert!");
			return;
		}
		// deal with the case where the cell to be swapped out is the head of the tree
		if(replacedParent==replaced){
			this.head = replacement;
		}
		else{
			int i = 0;
			for(; i<6; i++) if(replacedParent.children[i]==replaced) break;
			System.out.println("i = "+i);
			if(i>5) { /*shouldn't ever happen */ System.out.println("parent null in swapAndInsert"); }
			replacedParent.children[i] = replacement;
		}
		insertAll(replaced);
	}
	// the following method inserts all cells in a subtree back into the main XYZ tree
	private void insertAll(Cell child){
		Cell[] grandchildren = new Cell[6];
		// retrieve all children and remove links to first cell in subtree
		for(int i = 0; i<6; i++){
			if(child.children[i]!=null) grandchildren[i] = child.children[i];
			child.children[i] = null;
		}
		// insert the first cell into the main XYZ tree
		//if(!(child.isDead())) {insert(child);
		// HK 2/26 first remove all dead links
		Cell temp = removeDeadLinks(child);
		if(!temp.isDead()) insert(temp);
		// insert each of the children into the main xyz tree, removing and inserting their children as well
		for(int i = 0; i<6; i++){
			if(grandchildren[i]!=null) insertAll(grandchildren[i]);
		}
	}
	//HK 2/26 removes all dead links, returns a dead cell if all links (including the original) are dead
	private Cell removeDeadLinks(Cell cell){
		Cell temp = cell;
		// find the first non-dead cell in the linked list
		while(temp.isDead()&&temp.next!=null) temp = temp.next;
		// if temp is still dead, there are no live links in the list
		// if next link is null, return the only cell (dead or alive)
		if(temp.isDead()||temp.next==null) return temp;
		// link the remaining live links to the first live link
		Cell tempTwo = temp;
		Cell tempNext = tempTwo.next;
		while(tempNext!=null){
			// find next live link
			while(tempNext.isDead()&&tempNext.next!=null) tempNext = tempNext.next;
			// if a live link exists, link last live link to it
			if(!tempNext.isDead()) {
				tempTwo.next = tempNext;
				tempTwo = tempTwo.next;
				tempNext = tempTwo.next;
			}
		}
		return temp;
	}


	// removes all the dead cells from the tree by re-inserting all living cells back into the tree
	// (except for the head, which is simply ignores)
	public void cleanup(){
		Cell[] children = new Cell[6];
		for(int i = 0; i<6; i++){
			children[i] = this.head.children[i];
			this.head.children[i] = null;
		}
		for(int i = 0; i<6; i++) {
			if(children[i]!=null)this.insertAll(children[i]);
		}
	}
// How to use this class:
	/*public static void  main(String[] args){
		Cell first = new Cell(0,0,0,2);
		XYZTree theTree = new XYZTree(first);
		theTree.insert(new Cell(1,0,0,2));
		theTree.print();
		System.out.println();
		Cell second = new Cell(1,1,0,1);
		theTree.insert(second);
		theTree.print();
		System.out.println();
		theTree.insert(new Cell(1,2,0,3));
		theTree.print();
		System.out.println();
		theTree.insert(new Cell(1,2,1,4));
		theTree.print();
		System.out.println();
		theTree.insert(new Cell(1,0,1,1));
		theTree.print();
		System.out.println();
		second.destroy();
		theTree.print();
		theTree.cleanup();
		System.out.println();
		theTree.print();
	}*/


}