<circuit access="public">

	<prefuseaction>
		<if condition="!isset($_SERVER['PHP_AUTH_USER']) || $myFusebox['originalCircuit'] != 'Admin'" >
			<true>
				<relocate url="{$FUSEBOX_APPLICATION_PATH}index.php" />
			</true>
		</if>
	</prefuseaction>
	
	<fuseaction name="Main">
		<smt.assign name="title" value='"$storeName - Site Administration"' />
		<do action="Menu" />
		<do action="vAdmin.Main" contentvariable="pagecontent" />
	</fuseaction>

	<fuseaction name="Orders">
		<smt.assign name="title" value='"$storeName - Incoming Orders"' />
		<do action="Menu" />
		<smt.assign name="IncomingOrders" value="$IncomingOrders" />
		<smt.assign name="xfa_onOrderClick" value="'Admin.Order'" />
	
		<do action="vAdmin.Orders" contentvariable="pagecontent" />
	</fuseaction>
	
	<fuseaction name="Order">
		<smt.assign name="title" value='"$storeName - Order Information"' />
		
		<do action="Checkout.GetPrivateReceipt" contentvariable="receiptContent" />
		<smt.assign name="receiptContent" value="$receiptContent" />
		<smt.assign name="order_id" value="$order_id" />
		
		<smt.assign name="xfa_doAcceptOrderSubmit" value="'Admin.MarkOrderBilled'" />
		<smt.assign name="xfa_doDenyOrderSubmit" value="'Admin.CancelOrder'" />
		
		<do action="Menu" />
		<do action="vAdmin.Order" contentvariable="pagecontent" />
	</fuseaction>
	
	<fuseaction name="MarkOrderBilled">
		<do action="mAdmin.MarkOrderBilled" />
		
		<relocate url="index.php?fuseaction=Admin.Orders" />
	</fuseaction>
	
	<fuseaction name="CancelOrder">
		<do action="mAdmin.CancelOrder" />
	
		<relocate url="index.php?fuseaction=Admin.Orders" />
	</fuseaction>
	
	<fuseaction name="PastOrders">
		<do action="mAdmin.GetPastOrders" />
		<smt.assign name="PastOrders" value="$PastOrders" />
		<smt.assign name="title" value='"$storeName - Past Orders"' />
		
		<smt.assign name="xfa_onOrderClick" value="'Admin.PastOrder'" />
		<smt.assign name="xfa_onDeleteOrderClick" value="'Admin.DeleteOrder'" />
		
		<do action="Menu" />
		<do action="vAdmin.PastOrders" contentvariable="pagecontent" />
	</fuseaction>
	
	<fuseaction name="PastOrder">
		<smt.assign name="title" value='"$storeName - Order Information"' />
		
		<do action="Checkout.GetPrivateReceipt" contentvariable="receiptContent" />
		<smt.assign name="receiptContent" value="$receiptContent" />
		<smt.assign name="order_id" value="$order_id" />
		
		<smt.assign name="xfa_doAcceptOrderSubmit" value="'Admin.MarkOrderBilled'" />
		<smt.assign name="xfa_doDenyOrderSubmit" value="'Admin.CancelOrder'" />
		
		<do action="Menu" />
		<do action="vAdmin.PastOrder" contentvariable="pagecontent" />
	</fuseaction>
	
	<fuseaction name="DeleteOrder">
		<do action="mAdmin.DeleteOrder" />
		
		<relocate url="index.php?fuseaction=Admin.PastOrders" />
	</fuseaction>
	
	<fuseaction name="Products">
		
		<do action="mAdmin.GetProductsList" />
		<smt.assign name="ProductsList" value="$ProductsList" />
		<do action="mAdmin.GetCategoriesList" />
		<smt.assign name="CategoriesList" value="$CategoriesList" />
	
		<smt.assign name="title" value='"$storeName - Products"' />
	
		<smt.assign name="xfa_onAddProductClick" value="'Admin.AddProduct'" />
		<smt.assign name="xfa_onEditProductClick" value="'Admin.EditProduct'" />
		<smt.assign name="xfa_doSubmit" value="'Admin.UpdateProductStatus'" />
		
		<do action="Menu" />
		<do action="vAdmin.Products" contentvariable="pagecontent" />
	</fuseaction>
	
	<fuseaction name="AddProduct">
		<smt.assign name="title" value='"$storeName - Add Product"' />
	
		<smt.assign name="xfa_doSubmit" value="'Admin.InsertProduct'" />
		
		<do action="mAdmin.GetCategoriesList" />
		<smt.assign name="CategoriesList" value="$CategoriesList" />
	
		<do action="Menu" />
		<do action="vAdmin.ShowProduct" contentvariable="pagecontent" />
	</fuseaction>
	
	<fuseaction name="InsertProduct">
		<do action="mAdmin.UploadMainImage" />
		<do action="mAdmin.InsertProduct" />
		<do action="mAdmin.UpdateProductParagraphs" />
		
		<relocate url="index.php?fuseaction=Admin.Products" />
	</fuseaction>
	
	<fuseaction name="EditProduct">
		<smt.assign name="title" value='"$storeName - Edit Product"' />
		
		<smt.assign name="xfa_doSubmit" value="'Admin.UpdateProduct'" />
		<smt.assign name="xfa_onPhotoGalleryClick" value="'Admin.ProductPhotosList'" />
		
		<do action="mAdmin.GetCategoriesList" />
		<smt.assign name="CategoriesList" value="$CategoriesList" />
	
		<do action="mAdmin.GetProduct" />
		<smt.assign name="Product" value="$Product[0]" />
		
		<do action="mAdmin.GetProductParagraphs" />
		<smt.assign name="ProductParagraphs" value="$ProductParagraphs" />
		
		<smt.assign name="paragraph_id_list" value="$paragraph_id_list" />
	
		<do action="Menu" />
		<do action="vAdmin.ShowProduct" contentvariable="pagecontent" />
	</fuseaction>
	
	<fuseaction name="ProductPhotosList">
		<smt.assign name="title" value='"$storeName - Product Photo Gallery"' />
		
		<do action="mAdmin.GetProductPhotosList" />
		<smt.assign name="ProductPhotosList" value="$ProductPhotosList" />
		
		<smt.assign name="xfa_doSubmit" value="'Admin.UpdatePhotoGallery'" />
		
		<do action="Menu" />
		<do action="vAdmin.ProductPhotosList" contentvariable="pagecontent" />
		
	</fuseaction>
	
	<fuseaction name="UpdatePhotoGallery">
	
	</fuseaction>
	
	<fuseaction name="UpdateProduct">
		<do action="mAdmin.UploadMainImage" />
		<do action="mAdmin.UpdateProduct" />
		<do action="mAdmin.UpdateProductParagraphs" />
		
		<relocate url="index.php?fuseaction=Admin.Products" />
	</fuseaction>
	
	<fuseaction name="UpdateProductStatus">
		<do action="mAdmin.UpdateProductStatus" />
		
		<relocate url="index.php?fuseaction=Admin.Products&amp;message=updated" />
	</fuseaction>
	
	<fuseaction name="ShippingAndHandling">
		<smt.assign name="title" value='"$storeName - Shipping and Handling"' />
	
		<do action="mAdmin.GetShippingCosts" />
		<smt.assign name="ShippingCosts" value="$ShippingCosts" />
		
		<smt.assign name="xfa_doShippingSubmit" value="'Admin.SubmitShipping'" />
		<smt.assign name="xfa_doHandlingSubmit" value="'Admin.SubmitHandling'" />
	
		<if condition="isset($message)">
			<true>
				<smt.assign name="message" value="$message" />
			</true>
		</if>
	
		<do action="Menu" />
		<do action="vAdmin.ShippingAndHandling" contentvariable="pagecontent" />
	</fuseaction>
	
	<fuseaction name="SubmitShipping">
		<do action="mAdmin.GetShippingCosts" />
		<do action="mAdmin.UpdateShipping" />
		
		<relocate url="index.php?fuseaction=Admin.ShippingAndHandling&amp;message=ShippingUpdated" />
	</fuseaction>
	
	<fuseaction name="SubmitHandling">
		<do action="mAdmin.UpdateHandling" />
		
		<relocate url="index.php?fuseaction=Admin.ShippingAndHandling&amp;message=HandlingUpdated" />
	</fuseaction>
	
	<fuseaction name="SystemSettings">
		
		<smt.assign name="title" value='"$storeName - System Settings"' />
		
		<do action="mAdmin.GetSettings" />
		<smt.assign name="SettingsQuery" value="$mySettings" />
		<if condition="isset($message)">
			<true>
				<smt.assign name="message" value="$message" />
			</true>
		</if>
		
		<smt.assign name="xfa_doSubmit" value="'Admin.UpdateSettings'" />
		<do action="Menu" />
		<do action="vAdmin.SystemSettings" contentvariable="pagecontent" />
	</fuseaction>
	
	<fuseaction name="UpdateSettings">
	
		<do action="mAdmin.UpdateSettings" />
		
		<relocate url="index.php?fuseaction=Admin.SystemSettings&amp;message=updated" />
	
	</fuseaction>
	
	<fuseaction name="FroogleSync">
	
		<do action="mAdmin.GetProductsList" />
		<smt.assign name="ProductsList" value="$ProductsList" />
		
		<do action="vAdmin.FroogleFormat" contentvariable="froogleData" />
		<do action="mAdmin.SendDataToFroogle" />
		
		<relocate url="index.php?fuseaction=Admin.FroogleStatus&amp;status=$status" />

	</fuseaction>

	<fuseaction name="FroogleStatus">
	
		<smt.assign name="title" value='"$storeName - Froogle Sync Status"' />
		
		<smt.assign name="status" value="$status" />
		<do action="Menu" />
		
		<do action="vAdmin.FroogleStatus" contentvariable="pagecontent" />
	
	</fuseaction>


	<fuseaction name="Menu" access="internal">
	
		<do action="mAdmin.GetIncomingOrders" />
		<smt.assign name="numberIncomingOrders" value="count($IncomingOrders)" />
		<do action="vAdmin.Menu" contentvariable="menucontent" />
	
	</fuseaction>

</circuit>
