<?PHP
/*
<?xml version="1.0" encoding="UTF-8"?>

<fusedoc fuse="qry_GetCartInfo.cfm" language="PHP" specification="2.0">
  <responsibilities>
	I return data associated with the shopping cart items.
  </responsibilities>
  <io>
    <in>
    		<struct name="productList" />
    </in>
    <out>
      <recordset name="CartInfo">
      		<string name="name" />
      		<string name="short_description" />
      		<number name="price" />
      		<number name="weight" />
      		<number name="product_id" />
      		<number name="quantity" />
      		<number name="cost" />
      </recordset>
      <number name="subTotalCost" />
      <number name="totalWeight" />
      	<number name="additional_handling" />
    </out>
  </io>
  <properties>
    <history author="Jake Feasel" email="jfeasel@gmail.com" date="5/8/2005" role="Programmer" type="Code Complete" />
  </properties>
</fusedoc>
*/
	$idList = join(",", array_keys($productList));
	if ($idList == "") $idList = 0;
	
	$SQL = "
	SELECT
		p.name,
		p.short_description,
		p.price,
		p.weight,
		p.product_id,
		p.additional_handling
	FROM
		tbl_Product p
	WHERE
		product_id IN ($idList)
	";

	if ( DB::isError( $CartInfo = $db->getAll($SQL) ) )
	{
		die ("[" . $idList . "]" . DB::errorMessage($CartInfo));
	}
	
 
	$subTotalCost = 0;
	$totalWeight = 0;
	$additional_handling = 0;
	
	for ($i = 0; $i < count($CartInfo); $i++)
	{
		$id = $CartInfo[$i]["product_id"];
		$CartInfo[$i]["quantity"] = $productList[$id];
		$CartInfo[$i]["cost"] = $CartInfo[$i]["quantity"] * $CartInfo[$i]["price"];
		$subTotalCost += $CartInfo[$i]["cost"];
		$totalWeight += $CartInfo[$i]["weight"];
		$additional_handling += $CartInfo[$i]["additional_handling"] * $CartInfo[$i]["quantity"];
	}
	
?>