<?PHP
/*
<?xml version="1.0" encoding="UTF-8"?>

<fusedoc fuse="qry_GetCategoriesList.cfm" language="PHP" specification="2.0">
  <responsibilities>
	I return a list of categories.
  </responsibilities>
  <io>
    <in>
    </in>
    <out>
      <recordset name="CategoriesList">
      	<number name="category_id" />
      	<string name="description" />
      	<number name="num_in_category" />
      </recordset>
    </out>
  </io>
  <properties>
    <history author="Jake Feasel" email="jfeasel@gmail.com" date="5/8/2005" role="Programmer" type="Code Complete" />
  </properties>
</fusedoc>
 */
 
	$SQL = "
	SELECT
		c.category_id,
		c.description,
		count(*) as num_in_category
	FROM
		tblref_Category c
			INNER JOIN tbl_Product p ON
				c.category_id = p.category_id AND
				p.active = 1
	WHERE
		c.is_public = 1
	GROUP BY
		c.category_id,
		c.description,
		c.logicalOrdering
	HAVING
		count(*) > 0
	ORDER BY
		c.logicalOrdering
	";
	
	
	if ( DB::isError( $CategoriesList = $db->getAll($SQL) ) )
	{
		die ("GetCategoriesList: " . DB::errorMessage($CategoriesList));
	}
	  
?>
