<?PHP
/*
<?xml version="1.0" encoding="UTF-8"?>

<fusedoc fuse="qry_GetProductsList.cfm" language="PHP" specification="2.0">
  <responsibilities>
	I return a list of products for a given category.
  </responsibilities>
  <io>
    <in>
    		<number name="category_id" />
    </in>
    <out>
      <recordset name="ProductsList">
      		<string name="name" />
      		<string name="short_description" />
      		<number name="price" />
      		<number name="weight" />
      		<number name="product_id" />
      		<number name="image_id" />
      		<number name="additional_handling" />
      		<boolean name="active" />
      		<number name="category_id" />
      		<string name="imageSrc" />
      		<string name="category" />
      </recordset>
    </out>
  </io>
  <properties>
    <history author="Jake Feasel" email="jfeasel@gmail.com" date="5/8/2005" role="Programmer" type="Code Complete" />
  </properties>
</fusedoc>
 */

	/* if (isset($_SERVER['PHP_AUTH_USER']) && !isset($category_id)) $category_clause = "is_public = 0";
	else */ if (! isset($category_id)) $category_clause = "is_default = 1";
	else $category_clause = "c.category_id = $category_id";

	$SQL = "
	SELECT
		p.name,
		p.short_description,
		p.price,
		p.weight,
		p.product_id,
		p.image_id,
		p.additional_handling,
		p.active,
		p.category_id,
		i.imageSrc,
		c.description as category
  	FROM
		tbl_Product p
			LEFT OUTER JOIN tbl_Image i ON
				p.image_id = i.image_id
			INNER JOIN tblref_Category c ON
				p.category_id = c.category_id AND
				$category_clause
	WHERE
		active = 1
  	ORDER BY
		p.name
  	";
  	
  	

	
	if ( DB::isError( $ProductsList = $db->getAll($SQL) ) )
	{
		die (DB::errorMessage($ProductsList));
	}
	  	

?>
