{*
<?xml version="1.0" encoding="UTF-8"?>

<fusedoc fuse="dsp_viewCart.cfm" language="PHP" specification="2.0">
  <responsibilities>
	I display the shopping cart to the user.
  </responsibilities>
  <io>
    <in>
    	<number name="totalCost" />
    	<boolean name="weightExceeded" />
    	<number name="shippingCost" />
    	<number name="totalHandlingCost" />
      <recordset name="CartInfo">
      		<string name="name" />
      		<string name="short_description" />
      		<number name="price" />
      		<number name="weight" />
      		<number name="product_id" />
      		<number name="quantity" />
      		<number name="cost" />
      </recordset>
      <number name="subTotalCost" />
      <number name="totalWeight" />
      <number name="additional_handling" />
      <string name="xfa_doRemoveSubmit" />
      <string name="xfa_doCheckoutSubmit" />
    </in>
    <out>
    </out>
  </io>
  <properties>
    <history author="Jake Feasel" email="jfeasel@gmail.com" date="5/8/2005" role="Programmer" type="Code Complete" />
  </properties>
</fusedoc>
	
	
*}

{if (count($CartInfo))}
	
	<h1>Shopping Cart Contents</h1>
	<form action="index.php" method="POST">
	<input type="hidden" name="fuseaction" value="{$xfa_doRemoveSubmit}">
	<table border=1 cellspacing="0" width=500>
	<tr>
	
	<td><b>Remove</b></td>
	<td><b>Product</b></td>
	<td><b>Quantity</b></td>
	<td><b>Cost Per Product</b></td>
	<td><b>Amount</b></td>
	</tr>
	
	{section name="i" loop=$CartInfo}
	
		<tr>
		<td><input type="checkbox" name="removeList[]" value="{$CartInfo[i].product_id}"></td>
		<td>{$CartInfo[i].name}</td>
		<td>{$CartInfo[i].quantity}</td>
		<td>${$CartInfo[i].price|string_format:"%.2f"} each</td>
		<td align=right>${$CartInfo[i].cost|string_format:"%.2f"}</td>
		</tr>
	
	{/section}

	{if !$weightExceeded}
	
		<tr>
			<td colspan=4 align="right">Shipping</td>
			<td align=right>${$shippingCost|string_format:"%.2f"}</td>
		</tr>
		
		<tr>
			<td colspan=4 align="right">Handling</td>
			<td align=right>${$totalHandlingCost|string_format:"%.2f"}</td>
		</tr>
		
		<tr>
			<td colspan=4 align="right"><b>Total</b></td>
			<td align=right>${$totalCost|string_format:"%.2f"}</td>
		</tr>
	
	{/if}
		
	</table>
	<br>
	<table width="500">
	<tr>
		<td>
			<input type="submit" value="Remove Items">
		</td>
	</form>
	<form action="{$settings.secureSiteRoot}?PHPSESSID={$PHPSESSID}" method="post">
	<td align="right">
	<input type="hidden" name="fuseaction" value="{$xfa_doCheckoutSubmit}">
	<input type="submit" value="Proceed to secure checkout">
	</td>
	</form>
	</table>

{else}


<p class="alert">
There were no items found in your cart!  Please use the links on the side to find something you'd like.<br><br>
Thanks for shopping!
</p>

{/if}